/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.RouterManagementMsg;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;

public class ActorRouterRegMsg
extends RouterManagementMsg {
    public static String SENDER_TYPE_ACTOR = "A";
    public static String SENDER_TYPE_CLIENT = "C";
    public static String SENDER_TYPE_SERVER = "S";
    public Vector actors;
    public int legCount;
    public String senderType;

    public ActorRouterRegMsg() {
    }

    public ActorRouterRegMsg(Vector actors, int legCount) {
        this.actors = actors;
        this.legCount = legCount;
        this.senderType = SENDER_TYPE_ACTOR;
    }

    public ActorRouterRegMsg(Vector actors, int legCount, String senderType) {
        this.actors = actors;
        this.legCount = legCount;
        this.senderType = senderType;
    }

    public ActorRouterRegMsg(ActorMsg am) {
        super(am);
    }

    public Vector getActors() {
        return this.actors;
    }

    public void setActors(Vector actors) {
        this.actors = actors;
    }

    public int getLegCount() {
        return this.legCount;
    }

    public void setLegCount(int legCount) {
        this.legCount = legCount;
    }

    public String messageContent() {
        return super.messageContent() + "Reg actors: " + this.actors;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ((OutputStream)dout).write(super.serialize());
        ((OutputStream)dout).write(VectorHelper.persist((Vector)this.actors));
        dout.writeInt(this.legCount);
        ((OutputStream)dout).write(StringHelper.persist((String)this.senderType));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = super.deSerialize(data, cl);
        DataInputStream din = new DataInputStream(bin);
        this.actors = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.legCount = din.readInt();
        this.senderType = StringHelper.resurrect((DataInputStream)din);
        return bin;
    }
}

