/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.messages;

import org.coos.javaframe.messages.JFConstants;

/**
 * This class contains all message declarations on actorframe layer
 * 
 * @author Knut Eilif Husa, Tellu AS
 */
public interface AFConstants extends JFConstants {

	int LEVEL_0 = 0; // Nameserver etc
	int LEVEL_1 = 1; // Enablers
	int LEVEL_2 = 2; // Servers
	int LEVEL_3 = 3; // Applications
	int LEVEL_4 = 4; // All other

	String ASSOCIATION_ERROR_MSG = "AssociationErrorMsg";

	/**
	 * Connector protocol
	 */
	String CONNECTOR_CONFIRM_MSG = "ConnectorConfirmMsg";

	/**
	 * Request for setting up an connector
	 */
	String CONNECTOR_REQUEST_MSG = "ConnectorRequestMsg";
	// Properties
	String CONNECTOR_REQUEST_MSG_REQUEST_BIDIRECTIONAL = "requestBidirectional";

	String CONNECTOR_REMOVE_MSG = "ConnectorRemoveMsg";
	String CONNECTOR_REMOVE_MSG_CONNECTORS = "connectors";

	/**
	 * Path protocol
	 */
	String PATH_REMOVE_MSG = "PathRemoveMsg";

	String PATH_REQUEST_MSG = "PathRequestMsg";
	String PATH_REQUEST_MSG_REASON_CODE = "reasonCode";

	String PATH_REQUEST_NACK_MSG = "PathRequestNackMsg";

	/**
	 * Port protocol
	 */
	String PORT_CREATE_MSG = "PortCreateMsg";
	String PORT_CREATE_MSG_CONNECTORS = "connectorAddresses";

	String PORT_CREATE_ACK_MSG = "PortCreateAckMsg";
	String PORT_TIME_OUT_MSG = "PortTimeOutMsg";
	String PORT_CREATE_NACK_MSG = "PortCreateNackMsg";
	String PORT_REMOVE_MSG = "PortRemoveMsg";

	String CHECK_SPEC_MSG = "CheckSpecMsg";

	String CONNECTOR_Add_MSG = "ConnectorAddMsg";
	String CONNECTOR_ADD_MSG_CONNECTORS = "connectors";

	/**
	 * Port properties
	 */
	String DEFAULT_IN_PORT = "defaultInPort";

	/**
	 * Message indicating update of partpec
	 */

	/**
	 * Message indicating new definition of structure
	 */
	String SERVICE_FILE_CHANGED_MSG = "ServiceFileChangedMsg";

	/**
	 * Message indicating request for partspec
	 */
	String PART_SPEC_REQUEST_MSG = "PartSpecRequestMsg";

	/**
	 * Message containing partspec
	 */
	String PART_SPEC_RESPONSE_MSG = "PartSpecResponseMsg";
	String VISIBLE_PROP = "visible";
	String PART_SPECS_PROP = "partSpecs";

	// String ACTOR_TYPE_PROP = "actorType"

	/**
	 * Properties
	 */

	// String ACTOR_ID_PROP = "actorId";
	// String ACTOR_TYPE_PROP = "actorType"

	/**
	 * Message indicating request for adding an Actor
	 */
	String LOOK_UP_MSG = "LookUpMsg";

	/**
	 * Properties
	 */

	// String ACTOR_ID_PROP = "actorId";
	// String ACTOR_TYPE_PROP = "actorType"

	/**
	 * Message containing the LookUpResult
	 */
	String LOOK_UP_RESULT_MSG = "LookUpResultMsg";

	/**
	 * Properties
	 */
	String RES_PROP = "res";

	/**
	 * Message confirming management request
	 */
	String MANAGEMENT_REQUEST_CONFIRM_MSG = "ManagementRequestConfirmMsg";

	/**
	 * Properties
	 */
	String INFO_PROP = "info";

	/**
	 * Message confirming management request
	 */
	String MANAGEMENT_REQUEST_ERROR_MSG = "ManagementRequestErrorMsg";

	/**
	 * Properties
	 */
	String ERROR_DESCRIPTION_PROP = "errorDescription";

	/**
	 * Message requesting actors in a routing table
	 */
	String REQUEST_LOCAL_ACTORS_MSG = "RequestLocalActorsMsg";

	/**
	 * Properties
	 */
	String RESULT_PROP = "result";

	/**
	 * Properties
	 */

	String ACTORS_PROP = "actors";

	String ACTOR_APPEARED_MSG = "ActorAppearedMsg";
	String ACTOR_APPEARED_MSG_ACTORS = ACTORS_PROP;

	String ACTOR_DISAPPEARED_MSG = "ActorDisappearedMsg";
	String ACTOR_DISAPPEARED_MSG_ACTORS = ACTORS_PROP;

	String ACTOR_ROUTER_REG_MSG = "ActorRouterRegMsg";
	String ACTOR_ROUTER_REG_MSG_ACTORS = ACTORS_PROP;
	String ACTOR_ROUTER_REG_MSG_LEGCOUNT = "legCount";
	String ACTOR_ROUTER_REG_MSG_SENDERTYPE = "senderType";

	String ACTOR_ROUTER_UNREG_MSG = "ActorRouterUnRegMsg";
	String ACTOR_ROUTER_UNREG_MSG_ACTORS = ACTORS_PROP;

	String SET_APPEARENT_MANAGER_MSG = "SetAppearentManagerMsg";
	String SET_APPEARENT_MANAGER_MSG_ADDRESS = "address";

	String TIMER_ACTOR_REG_ID = "TimerRegId";

	String ARE_YOU_THERE = "ARE_YOU_THERE";
	String YES_I_AM = "YES_I_AM";

    String START_LEVEL_TIMER = "StartLevelTimer";
    int START_LEVEL_TIMER_VALUE = 1000;
}
