/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.actorframe.messages.AFConstants;
import org.coos.actorframe.application.Session;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;

import java.util.Vector;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class MidletSchedulerImpl extends SchedulerImpl {
	public MidletSchedulerImpl(SchedulerData schedulerData) {
		super(schedulerData);
	}

	public void addRouter(Session domainSession) {
	}

	public void upDateVisibleActors(StateMachine sm) {
		Vector v = getVisibleStateMachines();
		AFPropertyMsg arrm = new AFPropertyMsg(AFConstants.ACTOR_ROUTER_REG_MSG, true);
		arrm.setProperty("actors", v);
		arrm.setProperty("legCount", new Integer(1));
		arrm.setProperty("senderType", "C");
		sm.sendMessage(arrm, new ActorAddress(sm.getID(), "ActorRouter"));
	}
}
