/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.util.serialize.StringHelper;

import java.io.*;

/**
 * This class contains the nec. information to create a port and the connectors
 * which it shall set up upon creation.
 * 
 */
public class PortSpec implements AFSerializer {
	public String portName = null; // Name of the Port.
	public String portType = null; // Type of Protocol state machine.
	ActorAddress targetActor = null;

	public PortSpec() {
	}

	public PortSpec(String portName, String portType, ActorAddress targetActor) {
		this.portName = portName;
		this.portType = portType;
		this.targetActor = targetActor;
	}

	public String getPortName() {
		return portName;
	}

	public String getPortType() {
		return this.portType;
	}

	public ActorAddress getTargetActor() {
		return targetActor;
	}

	public Object clone() {
		return new PortSpec(portName, portType, targetActor);
	}

	public String toString() {
		return "portName: " + portName + " portType: " + portType + " TargetActor: " + targetActor;
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (o == null || getClass() != o.getClass())
			return false;

		PortSpec portSpec = (PortSpec) o;

		if (!portName.equals(portSpec.portName))
			return false;
		if (portType != null ? !portType.equals(portSpec.portType) : portSpec.portType != null)
			return false;
		if (targetActor != null ? !targetActor.equals(portSpec.targetActor) : portSpec.targetActor != null)
			return false;

		return true;
	}

	/**
	 * Parse Element to create the ActorPortSpec.
	 * 
	 * @param e
	 *            org.jdom.Element to parse.
	 */

	/*
	 * public ActorPortSpec(org.jdom.Element e) { portName =
	 * e.getChildTextTrim("name"); portType = e.getChildTextTrim("type"); String
	 * strIsBehavior = e.getChildTextTrim("isbehavior"); String strHideInner =
	 * e.getChildTextTrim("hideinner"); String strSessionEnabled =
	 * e.getChildTextTrim("sessions"); isBehavior = ((strIsBehavior != null) &&
	 * strIsBehavior.equalsIgnoreCase("true")); hideInner = ((strHideInner !=
	 * null) && strHideInner.equalsIgnoreCase("true")); sessionEnabled =
	 * ((strSessionEnabled != null) &&
	 * strSessionEnabled.equalsIgnoreCase("true")); }
	 */

	/**
	 * This function must implement the serialization of the object.
	 * 
	 * @return a byte array with the objects data
	 * @throws java.io.IOException
	 */
	public byte[] serialize() throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		dout.write(StringHelper.persist(portName));
		dout.write(StringHelper.persist(portType));
		dout.write(ActorAddressHelper.persist(targetActor));
		dout.flush();

		return bout.toByteArray();
	}

	/**
	 * Use this function for resurrection of the object.
	 * 
	 * @param data
	 *            The serialized data containing the object data.
	 * @throws java.io.IOException
	 */
	public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
		ByteArrayInputStream bin = new ByteArrayInputStream(data);
		DataInputStream din = new DataInputStream(bin);
		portName = StringHelper.resurrect(din);
		portType = StringHelper.resurrect(din);
		targetActor = ActorAddressHelper.resurrect(din);

		return bin;
	}
}
