/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.javaframe.messages.Message;
import org.coos.actorframe.application.Session;
import org.coos.actorframe.application.Container;

import java.util.Hashtable;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class SchedulerData {
	/**
	 * The name of the domain
	 */
	private String actorDomainName;

	/**
	 * Contains all state machines. The key is the actor address
	 */
	private Hashtable mySystem = new Hashtable();

	/**
	 * Contains a map between type of actor type and scheduler instance such
	 * that actor instances are allocated to correct scheduler
	 */
	private Hashtable schedulerConfig = new Hashtable();

	// private static SessionManager theRouterSessionManager;
	private Message lastMsgFromRouter = null;

	// reference to the default scheduler which is set if no scheduler is
	// created
	private Scheduler defaultScheduler = null;

	// A reference to the router session that this scheduler group have in
	// common
	private Session theRouterSession;

	// application specification
	private ApplicationSpec applicationSpec;

	// The container
	private Container container;

	public void setContainer(Container container) {
		this.container = container;
	}

	/**
	 * A refernce to the container class
	 */
	public Container getContainer() {
		return container;
	}

	public String getActorDomainName() {
		return actorDomainName;
	}

	/**
	 * Set actor domain name. The name must be unique.
	 * 
	 * @param actorDomainName
	 */
	public void setActorDomainName(String actorDomainName) {
		this.actorDomainName = actorDomainName;
	}

	public Session getTheRouterSession() {
		return theRouterSession;
	}

	public void setTheRouterSession(Session theRouterSession) {
		this.theRouterSession = theRouterSession;
	}

	public Hashtable getMySystem() {
		return mySystem;
	}

	public void setMySystem(Hashtable mySystem) {
		this.mySystem = mySystem;
	}

	public Hashtable getSchedulerConfig() {
		return schedulerConfig;
	}

	public void setSchedulerConfig(Hashtable schedulerConfig) {
		this.schedulerConfig = schedulerConfig;
	}

	public Message getLastMsgFromRouter() {
		return lastMsgFromRouter;
	}

	public void setLastMsgFromRouter(Message lastMsgFromRouter) {
		this.lastMsgFromRouter = lastMsgFromRouter;
	}

	public Scheduler getDefaultScheduler() {
		return defaultScheduler;
	}

	public void setDefaultScheduler(Scheduler defaultScheduler) {
		this.defaultScheduler = defaultScheduler;
	}

	public ApplicationSpec getApplicationSpec() {
		return applicationSpec;
	}

	public void setApplicationSpec(ApplicationSpec applicationSpec) {
		this.applicationSpec = applicationSpec;
	}

}
