/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Date;
import org.coos.javaframe.CLDCLoggingEvent;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;

public class CLDCLoggerImpl
implements Logger {
    private static boolean consoleLog = true;
    private static boolean remoteLog = false;
    private static String remoteHost = "";
    private static int remotePort;
    String loggerName;
    int traceLevel;

    public void log(int level, int categories, String value) {
        if (level >= this.traceLevel) {
            if (level < 4) {
                if (consoleLog) {
                    switch (level) {
                        case 3: {
                            System.out.println(CLDCLoggerImpl.getTimeString() + " WARN " + this.loggerName + " " + value);
                            break;
                        }
                        case 2: {
                            System.out.println(CLDCLoggerImpl.getTimeString() + " INFO " + this.loggerName + " " + value);
                            break;
                        }
                        case 1: {
                            System.out.println(CLDCLoggerImpl.getTimeString() + " DEBUG " + this.loggerName + " " + value);
                        }
                    }
                }
                if (remoteLog) {
                    CLDCLoggingEvent le = new CLDCLoggingEvent(remoteHost, remotePort);
                    le.log(value, this.loggerName, level);
                }
            } else {
                if (consoleLog) {
                    switch (level) {
                        case 4: {
                            System.err.println(CLDCLoggerImpl.getTimeString() + " ERROR " + this.loggerName + " " + value);
                            break;
                        }
                        case 5: {
                            System.err.println(CLDCLoggerImpl.getTimeString() + " FATAL " + this.loggerName + " " + value);
                        }
                    }
                }
                if (remoteLog) {
                    CLDCLoggingEvent le = new CLDCLoggingEvent(remoteHost, remotePort);
                    le.log(value, this.loggerName, level);
                }
            }
        }
    }

    private static String getTimeString() {
        return new Date(System.currentTimeMillis()).toString();
    }

    public void log(int level, String value) {
        this.log(level, 0, value);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public static void setConsoleLog(boolean consoleLog) {
        CLDCLoggerImpl.consoleLog = consoleLog;
    }

    public static void setRemoteLog(boolean remoteLog) {
        CLDCLoggerImpl.remoteLog = remoteLog;
    }

    public static void setRemoteHost(String remoteHost) {
        CLDCLoggerImpl.remoteHost = remoteHost;
    }

    public static void setRemotePort(int remotePort) {
        CLDCLoggerImpl.remotePort = remotePort;
    }

    public boolean isDebugEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel <= 1;
    }

    public boolean isErrorEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel <= 4;
    }

    public boolean isInfoEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel <= 2;
    }

    public boolean isTraceEnabled() {
        return LoggerFactory.isTraceOn() && this.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return LoggerFactory.isTraceOn() && this.traceLevel <= 3;
    }
}

