/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.javaframe.messages.Message;
import org.coos.javaframe.messages.PropertyException;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;

public class ActorMsg
extends Message
implements AFSerializer {
    private ActorAddress receiverRole;
    private ActorAddress senderRole;
    private static int msgCounter = 0;
    private int msgRef;
    protected boolean frameworkMsg;
    private short msgType = 0;
    public static final String BODY_PROPERTY = "Body";
    public static final short MSG_TYPE_PROPERTY = 0;
    public static final short MSG_TYPE_TEST = 1;
    public static final short MSG_TYPE_RESET = 2;

    public ActorMsg() {
        this.receiverRole = null;
        this.senderRole = null;
        this.msgRef = msgCounter++;
        this.frameworkMsg = false;
    }

    public static int getMsgCounter() {
        return msgCounter;
    }

    public static void setMsgCounter(int msgCounter) {
        ActorMsg.msgCounter = msgCounter;
    }

    public void assignId() {
        this.msgRef = msgCounter++;
    }

    public int getMsgRef() {
        return this.msgRef;
    }

    public ActorMsg(ActorAddress aa) {
        this.receiverRole = aa;
        this.msgRef = msgCounter++;
        this.frameworkMsg = false;
    }

    public ActorMsg(ActorMsg am) {
        this.receiverRole = am.getReceiverRole();
        this.senderRole = am.getSenderRole();
    }

    public short getMsgType() {
        return this.msgType;
    }

    public void setMsgType(short msgType) {
        this.msgType = msgType;
    }

    public ActorAddress getReceiverRole() {
        return this.receiverRole;
    }

    public ActorAddress getSenderRole() {
        return this.senderRole;
    }

    public void setSenderRole(String senderRole) {
        this.setSenderRole(new ActorAddress(senderRole));
    }

    public void setReceiverRole(ActorAddress recieverRole) {
        this.receiverRole = recieverRole;
    }

    public void setReceiverRole(String recieverRole) {
        this.setReceiverRole(new ActorAddress(recieverRole));
    }

    public void setMsgRef(int msgRef) {
        this.msgRef = msgRef;
    }

    public void setFrameworkMsg(boolean frameworkMsg) {
        this.frameworkMsg = frameworkMsg;
    }

    public void setSenderRole(ActorAddress senderRole) {
        this.senderRole = senderRole;
    }

    public boolean isFrameworkMsg() {
        return this.frameworkMsg;
    }

    public String getSignalName() {
        return ActorMsg.getSignal(this.toString());
    }

    public boolean equals(int cmd) {
        return super.equals(new Integer(cmd));
    }

    public String messageContent() {
        String tmp = " MESSAGE: ID: " + this.msgRef + " NAME:" + this.getSignalName();
        tmp = this.receiverRole != null ? tmp + " RECEIVER:" + this.receiverRole.toString() : tmp + " RECEIVER: null";
        tmp = this.senderRole != null ? tmp + " SENDER:" + this.senderRole.toString() : tmp + " SENDER: null";
        return tmp + " CONTENT: ";
    }

    public static String getSignal(String s) {
        int length;
        int start = 0;
        int end = 0;
        for (int i = length = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '@') {
                end = i;
            }
            if (c != '.') continue;
            start = i + 1;
            i = 0;
        }
        return s.substring(start, end);
    }

    public ActorMsg getCopy(AFClassLoader cl) {
        ActorMsg msg = null;
        try {
            byte[] data = this.serialize();
            String className = this.getClass().getName();
            Class myClass = null;
            myClass = cl == null || cl.loadClass(className) == null ? Class.forName(className) : cl.loadClass(className);
            msg = (ActorMsg)myClass.newInstance();
            int msgNo = msg.msgRef;
            msg.deSerialize(data, cl);
            if (this.senderRole != null) {
                msg.senderRole = (ActorAddress)this.senderRole.clone();
            }
            if (this.receiverRole != null) {
                msg.receiverRole = (ActorAddress)this.receiverRole.clone();
            }
            msg.msgRef = msgNo;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass().getName()).log(4, "Ignored Exception " + e);
        }
        return msg;
    }

    public String getMsgId() {
        throw new PropertyException();
    }

    public void setMsgId(String msgId) {
        throw new PropertyException();
    }

    public AFPropertyMsg setBody(Object body) {
        throw new PropertyException();
    }

    public void setProperties(Hashtable properties) {
        throw new PropertyException();
    }

    public Hashtable getProperty() {
        throw new PropertyException();
    }

    public Object getBody() {
        throw new PropertyException();
    }

    public Object getProperty(String name) {
        throw new PropertyException();
    }

    public String getString(String name) {
        throw new PropertyException();
    }

    public String getString(String name, String defaultValue) {
        throw new PropertyException();
    }

    public ActorAddress getActorAddress(String name) {
        throw new PropertyException();
    }

    public Vector getVector(String name) {
        throw new PropertyException();
    }

    public int getInt(String name) {
        throw new PropertyException();
    }

    public int getInt(String name, int defaultValue) {
        throw new PropertyException();
    }

    public boolean getBoolean(String name) {
        throw new PropertyException();
    }

    public AFPropertyMsg setByteArray(String name, byte[] array) {
        throw new PropertyException();
    }

    public byte[] getByteArray(String name) {
        throw new PropertyException();
    }

    public AFPropertyMsg setFloat(String name, float value) {
        throw new PropertyException();
    }

    public float getFloat(String name) {
        throw new PropertyException();
    }

    public AFPropertyMsg setDouble(String name, double value) {
        throw new PropertyException();
    }

    public double getDouble(String name) {
        throw new PropertyException();
    }

    public AFPropertyMsg setLong(String name, long value) {
        throw new PropertyException();
    }

    public long getLong(String name) {
        throw new PropertyException();
    }

    public long getLong(String name, long defaultValue) {
        throw new PropertyException();
    }

    public Object removeProperty(String name) {
        throw new PropertyException();
    }

    public AFPropertyMsg setProperty(String name, Object value) {
        throw new PropertyException();
    }

    public AFPropertyMsg setBoolean(String name, boolean value) {
        throw new PropertyException();
    }

    public AFPropertyMsg setInt(String name, int value) {
        throw new PropertyException();
    }

    public boolean hasProperty(String propertyName) {
        return false;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeShort(this.msgType);
        if (this.msgType != 1) {
            ((OutputStream)dout).write(ActorAddressHelper.persist(this.receiverRole));
            ((OutputStream)dout).write(ActorAddressHelper.persist(this.senderRole));
            dout.writeInt(this.msgRef);
            dout.writeBoolean(this.frameworkMsg);
        }
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.readInput(din, cl);
        return bin;
    }

    protected void readInput(DataInputStream din, AFClassLoader cl) throws IOException {
        this.msgType = din.readShort();
        if (this.msgType != 1) {
            this.receiverRole = ActorAddressHelper.resurrect(din);
            this.senderRole = ActorAddressHelper.resurrect(din);
            this.msgRef = din.readInt();
            this.frameworkMsg = din.readBoolean();
        }
    }

    public ActorMsg cloneMsg(AFClassLoader cl) {
        Class<?> c = this.getClass();
        try {
            ActorMsg am = (ActorMsg)c.newInstance();
            if (cl == null || cl.loadClass(c.getName()) == null) {
                am.deSerialize(this.serialize(), null);
            } else {
                am.deSerialize(this.serialize(), cl);
            }
            return am;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

