/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.coos.javaframe.ActorAddress;

public class AFProperties
extends Properties {
    private static AFProperties instance = null;
    static final String PROPERTYFILE = "AFProperties.properties";
    public static final String GATEWAY_IP_ADDRESS = "GATEWAY_IP_ADDRESS";
    public static final String GATEWAY_PORT_NUMBER = "GATEWAY_PORT_NUMBER";
    public static final String SERVER_PORT_NUMBER = "SERVER_PORT_NUMBER";
    public static final String PUBLIC_IP_ADDRESS = "PUBLIC_IP_ADDRESS";
    public static final String ACTOR_ROUTER_ID = "ACTOR_ROUTER_ID";
    public static final String DEPLOYMENT_DESCRIPTOR = "DEPLOYMENT_DESCRIPTOR";
    public static final String LOG4J_LOCATION = "LOG4J_LOCATION";
    public static final String CONFIG_LOCATION = "CONFIG_LOCATION";
    public static final String ACTOR_DOMAIN = "ACTOR_DOMAIN";
    public static final String APPLICATION_NAME = "APPLICATION_NAME";
    public static final String STORE_LOCATION = "STORE_LOCATION";
    public static final String RESOURCE_LOCATION = "RESOURCE_LOCATION";
    public static final String UDP = "UDP";
    public static final String J2SE = "J2SE";
    public static final String TCP = "TCP";
    public static final String TCP_SESSION = "TCP_SESSION";
    public static final String GATEWAY_TCP_SESSION = "GATEWAY_TCP_SESSION";
    public static final String BLUETOOTH = "BLUETOOTH";
    public static final String USER_NAME = "USER_NAME";
    public static final String USER_PASSWORD = "USER_PASSWORD";
    public static final String NAME_SERVER = "NAME_SERVER";
    private String dir = System.getProperty("user.dir");
    private URL context = null;

    private AFProperties() {
        this.load();
    }

    private void load() {
        try {
            this.context = new URL("file://localhost/" + this.dir + "/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            InputStream filestream;
            block6: {
                filestream = null;
                try {
                    filestream = new FileInputStream(PROPERTYFILE);
                }
                catch (FileNotFoundException e) {
                    filestream = this.getClass().getResourceAsStream("/AFProperties.properties");
                    if (filestream != null) break block6;
                    throw new IOException("Cannot find AFProperties");
                }
            }
            this.load(filestream);
            this.setProperty(GATEWAY_IP_ADDRESS, this.getProperty(GATEWAY_IP_ADDRESS, "127.0.0.1"));
            this.setProperty(GATEWAY_PORT_NUMBER, this.getProperty(GATEWAY_PORT_NUMBER, "6666"));
            this.setProperty(SERVER_PORT_NUMBER, this.getProperty(SERVER_PORT_NUMBER, "4444"));
            this.setProperty(PUBLIC_IP_ADDRESS, this.getProperty(PUBLIC_IP_ADDRESS, "127.0.0.1"));
            this.setProperty(DEPLOYMENT_DESCRIPTOR, this.getProperty(DEPLOYMENT_DESCRIPTOR, "actordeploy/") + "/");
            this.setProperty(LOG4J_LOCATION, this.getProperty(LOG4J_LOCATION, ".") + "/");
            this.setProperty(CONFIG_LOCATION, this.getProperty(CONFIG_LOCATION, ".") + "/");
            this.setProperty(STORE_LOCATION, this.getProperty(STORE_LOCATION, "store/") + "/");
            this.setProperty(RESOURCE_LOCATION, this.getProperty(RESOURCE_LOCATION, "res") + "/");
            this.setProperty(ACTOR_DOMAIN, this.getProperty(ACTOR_DOMAIN, "default"));
            this.setProperty(APPLICATION_NAME, this.getProperty(APPLICATION_NAME, "tellU"));
            this.setProperty(TCP, this.getProperty(TCP, "true"));
            this.setProperty(UDP, this.getProperty(UDP, "true"));
            this.setProperty(TCP_SESSION, this.getProperty(TCP_SESSION, "true"));
            this.setProperty(GATEWAY_TCP_SESSION, this.getProperty(GATEWAY_TCP_SESSION, "false"));
            this.setProperty(BLUETOOTH, this.getProperty(BLUETOOTH, "false"));
            this.setProperty(USER_NAME, this.getProperty(USER_NAME, "guest"));
            this.setProperty(USER_PASSWORD, this.getProperty(USER_PASSWORD, "guest"));
            this.setProperty(NAME_SERVER, this.getProperty(NAME_SERVER, "telluNS"));
        }
        catch (IOException e) {
            System.out.println("AFProperties: Property file error: " + e.getMessage());
            System.out.println("AFProperties: Default values are entered");
            this.setProperty(GATEWAY_IP_ADDRESS, "127.0.0.1");
            this.setProperty(GATEWAY_PORT_NUMBER, "6666");
            this.setProperty(SERVER_PORT_NUMBER, "4444");
            this.setProperty(PUBLIC_IP_ADDRESS, "127.0.0.1");
            this.setProperty(DEPLOYMENT_DESCRIPTOR, "actordeploy/");
            this.setProperty(LOG4J_LOCATION, "./");
            this.setProperty(STORE_LOCATION, "store/");
            this.setProperty(RESOURCE_LOCATION, "res/");
            this.setProperty(CONFIG_LOCATION, "./");
            this.setProperty(ACTOR_DOMAIN, "default");
            this.setProperty(APPLICATION_NAME, "tellU");
            this.setProperty(TCP, "true");
            this.setProperty(UDP, "true");
            this.setProperty(TCP_SESSION, "true");
            this.setProperty(GATEWAY_TCP_SESSION, "false");
            this.setProperty(BLUETOOTH, "false");
            this.setProperty(USER_NAME, "guest");
            this.setProperty(USER_PASSWORD, "guest");
            this.setProperty(NAME_SERVER, "telluNS");
        }
        System.out.println("AFproperties: Property file: AFproperties.properties: " + this.toString());
    }

    public void loadProperties() {
        this.load();
    }

    public URL getDeployLocation() {
        try {
            return new URL(this.context, this.getProperty(DEPLOYMENT_DESCRIPTOR));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getLogConfigLocation() {
        try {
            return new URL(this.context, this.getProperty(LOG4J_LOCATION));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getStandaloneConfigLocation() {
        try {
            return new URL(this.context, this.getProperty(CONFIG_LOCATION));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AFProperties getAFProperties() {
        if (instance == null) {
            instance = new AFProperties();
        }
        return instance;
    }

    public URL getStorageDir() {
        try {
            return new URL(this.context, this.getProperty(STORE_LOCATION));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getResourceDir() {
        try {
            return new URL(this.context, this.getProperty(RESOURCE_LOCATION));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ActorAddress getNameServerAddress() {
        return new ActorAddress(this.getProperty(NAME_SERVER), "NameServer");
    }
}

