/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.coos.javaframe.AFProperties;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Standalone {
    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("WARNING All input arguments are skipped, use configuration file standalone.xml");
        }
        AFProperties properties = AFProperties.getAFProperties();
        String configDir = properties.getProperty("CONFIG_LOCATION");
        String xmlFileName = configDir + "standalone.xml";
        URL url = null;
        try {
            url = new URL(xmlFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = null;
        file = new File(url.getFile());
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setValidating(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("This actordescriptor is invalid according to standalone.dtd: \n ActorDescriptor Error:\n" + e.getMessage());
            return;
        }
        Element system = doc.getDocumentElement();
        NodeList schedulerList = system.getElementsByTagName("scheduler");
        for (int x = 0; x < schedulerList.getLength(); ++x) {
            Element sched = (Element)schedulerList.item(x);
            String name = sched.getElementsByTagName("name").item(0).getNodeValue();
            String noThreads = sched.getElementsByTagName("threads").item(0).getNodeValue();
            if (noThreads == null) {
                noThreads = "1";
            }
            SchedulerImpl schedInstance = new SchedulerImpl(new SchedulerData());
            NodeList smlist = sched.getElementsByTagName("statemachine");
            for (int i = 0; i < smlist.getLength(); ++i) {
                Element sm = (Element)smlist.item(i);
                String classname = sm.getElementsByTagName("class").item(0).getNodeValue();
                String actortype = sm.getElementsByTagName("actortype").item(0).getNodeValue();
                try {
                    schedInstance.addStateMachine((StateMachine)Class.forName(classname).newInstance(), actortype);
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        String strDisplayConsole = system.getElementsByTagName("displayconsole").item(0).getNodeValue();
        Standalone.startConsole(strDisplayConsole != null && strDisplayConsole.equalsIgnoreCase("true"));
        String strWebConsolePort = system.getElementsByTagName("webconsoleport").item(0).getNodeValue();
        Standalone.startWebConsole(strWebConsolePort);
        String strRoutingEnabled = system.getElementsByTagName("routingenabled").item(0).getNodeValue();
        Standalone.startRouting(strRoutingEnabled != null && strRoutingEnabled.equalsIgnoreCase("true"));
        String actorid = properties.getProperty("ACTOR_DOMAIN");
        AFPropertyMsg msg = new AFPropertyMsg("RoleCreateMsg", true);
        msg.setReceiverRole(new ActorAddress(actorid, "ActorDomain"));
        msg.setSenderRole(new ActorAddress(null, null));
        msg.getReceiverRole().setProtocol("udp");
    }

    private static void startRouting(boolean startRouting) {
        if (startRouting) {
            Runnable router = new Runnable(){

                @Override
                public void run() {
                }
            };
            new Thread(router).start();
        }
    }

    private static void startWebConsole(String strWebConsolePort) {
    }

    private static void startConsole(boolean startConsole) {
        if (startConsole) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                }
            };
            new Thread(r).start();
        }
    }
}

