/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class TestScheduler
extends SchedulerImpl {
    private boolean printing = true;

    public TestScheduler(SchedulerData schedulerData) {
        this.setSchedulerData(schedulerData);
        if (this.getSchedulerData().getDefaultScheduler() == null) {
            this.getSchedulerData().setDefaultScheduler(this);
        }
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    @Override
    public void output(ActorMsg sig, Schedulable curfsm) {
        String msgId = sig instanceof AFPropertyMsg ? ((AFPropertyMsg)sig).getMsgId() : sig.getSignalName();
        if (this.isPrinting()) {
            System.out.println("Output received: " + msgId);
        }
        if (curfsm != null && curfsm.getScheduler().isTraceOn()) {
            curfsm.getScheduler().getTraceObject().traceOutput(sig);
        }
    }

    @Override
    public void upDateVisibleActors(StateMachine sm) {
        if (this.isPrinting()) {
            System.out.println("TestScheduler.upDateVisibleActors: SM:" + sm.getMyActorAddress());
        }
    }

    @Override
    public void unRegVisibleActor(ActorAddress aa) {
        if (this.isPrinting()) {
            System.out.println("TestScheduler.unRegVisibleActor: SM:" + aa);
        }
    }

    @Override
    public boolean containsStateMachine(ActorAddress aa) {
        return true;
    }
}

