/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.util.serialize.AFClassLoader;

public class OptimizedMsg
extends ActorMsg {
    public static ActorAddress receiveAddress;
    public static ActorAddress sendAddress;
    public Vector content = new Vector();
    public byte classId;
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int INTEGER = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int STRING = 5;
    private static final int BOOLEAN = 6;

    public OptimizedMsg() {
    }

    public OptimizedMsg(ActorAddress aa, Vector replyStack) {
        super(aa);
    }

    public OptimizedMsg(ActorAddress aa) {
        super(aa);
    }

    public OptimizedMsg(ActorMsg am) {
        super(am);
    }

    public OptimizedMsg(byte classId) {
        this.classId = classId;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeByte(this.classId);
        dout.writeByte(this.content.size());
        for (int i = 0; i < this.content.size(); ++i) {
            Object o = this.content.elementAt(i);
            if (o instanceof Integer) {
                dout.writeByte(2);
                dout.writeInt((Integer)o);
                continue;
            }
            if (o instanceof Byte) {
                dout.writeByte(0);
                dout.writeByte(((Byte)o).byteValue());
                continue;
            }
            if (o instanceof Short) {
                dout.writeByte(1);
                dout.writeShort(((Short)o).shortValue());
                continue;
            }
            if (o instanceof String) {
                dout.writeByte(5);
                dout.writeUTF((String)o);
                continue;
            }
            if (o instanceof Long) {
                dout.writeByte(3);
                dout.writeLong((Long)o);
                continue;
            }
            if (o instanceof Float) {
                dout.writeByte(4);
                dout.writeFloat(((Float)o).floatValue());
                continue;
            }
            if (o instanceof Boolean) {
                dout.writeByte(6);
                dout.writeBoolean((Boolean)o);
                continue;
            }
            throw new IOException("Cannot persist object of type " + o.getClass().getName());
        }
        dout.flush();
        return bout.toByteArray();
    }

    @Override
    public String messageContent() {
        return super.messageContent() + " Optimized classid: " + this.classId + " content: " + this.content + " receiver: " + super.getReceiverRole() + " senderAddress: " + super.getSenderRole();
    }

    @Override
    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.content = new Vector();
        this.classId = din.readByte();
        int contentSize = din.readByte();
        for (int i = 0; i < contentSize; ++i) {
            byte type = din.readByte();
            if (type == 2) {
                this.content.addElement(new Integer(din.readInt()));
                continue;
            }
            if (type == 0) {
                this.content.addElement(new Byte(din.readByte()));
                continue;
            }
            if (type == 1) {
                this.content.addElement(new Short(din.readShort()));
                continue;
            }
            if (type == 5) {
                this.content.addElement(din.readUTF());
                continue;
            }
            if (type == 3) {
                this.content.addElement(new Long(din.readLong()));
                continue;
            }
            if (type == 4) {
                this.content.addElement(new Float(din.readFloat()));
                continue;
            }
            if (type == 6) {
                this.content.addElement(new Boolean(din.readBoolean()));
                continue;
            }
            throw new IOException("Cannot read object of type " + type);
        }
        if (super.getReceiverRole() == null) {
            super.setReceiverRole(receiveAddress);
        }
        if (super.getSenderRole() == null) {
            super.setSenderRole(sendAddress);
        }
        return bin;
    }
}

