/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

/**
 * Factor class for Logger. This factory will search for predefined loggers. You
 * may insert your own implementation of Logger class using the method
 * setLoggerImplClass().
 * 
 * @author Knut Eilif Husa, Tellu AS
 * @author Robert Bjarum, Tellu AS
 * @see Logger
 */
public class LoggerFactory {
	static boolean traceOn = true, traceError = true;
	static Class LOGGER_IMPL_CLASS = null;

	public static boolean isTraceOn() {
		return traceOn;
	}

	public static void setTrace(boolean enabled) {
		traceOn = enabled;
	}

	public static boolean isTraceError() {
		return traceError;
	}

	public static void setTraceError(boolean on) {
		traceError = on;
	}

	public static void setLoggerImplClass(Class loggerImplClass) {
		LOGGER_IMPL_CLASS = loggerImplClass;
		Logger logger;
		if (loggerImplClass != null) {
			try {
				logger = (Logger) LOGGER_IMPL_CLASS.newInstance();
			} catch (Exception e) {
				System.err.println("Failed create instance of " + LOGGER_IMPL_CLASS.getClass().getName());
				System.err.println();
				e.printStackTrace();
			} finally {
				logger = getLogger(LoggerFactory.class.getName());
				logger.log(TraceConstants.tlInfo, "Using " + logger.getClass().getName());
			}
		}
	}

	public static Logger getLogger(String loggerName) {
		/*
		 * Your own Logger implementation
		 */
		try {
			if (LOGGER_IMPL_CLASS != null) {
				Logger logger = (Logger) LOGGER_IMPL_CLASS.newInstance();
				logger.setLoggerName(loggerName);
				return logger;
			}
		} catch (Exception e) {
		}

		/*
		 * Logger for J2SE
		 */
		try {
			Logger logger = (Logger) (Class.forName("org.coos.javaframe.J2SELoggerImpl").newInstance());
			logger.setLoggerName(loggerName);

			return logger;
		} catch (Exception e) {
		}

		try {
			Logger logger = (Logger) (Class.forName("no.tellu.cdc.javaframe.LoggerImpl").newInstance());
			logger.setLoggerName(loggerName);

			return logger;
		} catch (Exception e) {
		}

		try {
			Logger logger = (Logger) (Class.forName("org.coos.javaframe.CLDCLoggerImpl").newInstance());
			logger.setLoggerName(loggerName);

			return logger;
		} catch (Exception e) {
		}

		// default logger
		return new BasicLoggerImpl();
	}
}
