/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe.messages;

import org.coos.javaframe.ActorAddress;

/**
 * @author Knut Eilif Husa, Tellu AS
 * 
 * 
 *         This class contains all message declarations on javaframe layer
 */
public interface JFConstants {
	String TIMER_MSG = "TimerMsg";
	String TIMER_ID = "timerId";
	String DURATION = "duration";

	String TRACE_LEVEL_PROP = "traceLevel";
	/**
	 * The role protocol
	 */
	String ROLE_REQUEST_MSG = "RoleRequestMsg";
	String ROLE_REQUEST_MSG_ROLE_ID = ActorAddress.ROLE_ID;
	String ROLE_REQUEST_MSG_ROLE_TYPE = ActorAddress.ROLE_TYPE;
	String ROLE_RESET_MSG = "RoleResetMsg";
	String ROLE_CONFIRM_MSG = "RoleConfirmMsg";
	String ROLE_CONFIRM_RRM = "rrm";

	String ROLE_CREATE_ACK_MSG = "RoleCreateAckMsg";

	String ROLE_CREATE_MSG = "RoleCreateMsg";
	String ROLE_CREATE_MSG_CONNECTORS = "connectors";
	String ROLE_CREATE_MSG_PORTS = "ports";
	String ROLE_CREATE_MSG_VISIBLE = "visible";
	String ROLE_CREATE_MSG_TARGET_ACTOR = "targetActor";

	String ROLE_CREATE_NACK_MSG = "RoleCreateNackMsg";
	String ROLE_PLAY_ACK_MSG = "RolePlayAckMsg";
	String ROLE_PLAY_ENDED_MSG = "RolePlayEndedMsg";
	String ROLE_PLAY_MSG = "RolePlayMsg";
	String ROLE_PLAY_MSG_CONNECTORS = "connectors";
	String ROLE_PLAY_MSG_PORTS = "ports";
	String ROLE_PLAY_MSG_RRM = "rrm";
	String ROLE_PLAY_MSG_TARGET_ACTOR = "targetActor";
	String ROLE_PLAY_MSG_VISIBLE = "visible";
	String ROLE_PLAY_MSG_TRACE_LEVEL = TRACE_LEVEL_PROP;
	String ROLE_PLAY_MSG_TRACE_CATEGORIES = "tracecategories";
	String ROLE_PLAY_MSG_TARGET_TRACEPARTS = "traceparts";

	String ROLE_UPDATE_MSG = "RoleUpdateMsg";
	// Properties:
	String ROLE_UPDATE_MSG_PORTS = "ports";
	String ROLE_UPDATE_MSG_CONNECTORS = "connectors";

	String ROLE_UPDATE_ACK_MSG = "RoleUpdateAckMsg";
	String ROLE_UPDATE_NACK_MSG = "RoleUpdateNackMsg";

	String ROLE_PLAY_NACK_MSG = "RolePlayNackMsg";
	String ROLE_RELEASE_MSG = "RoleReleaseMsg";
	String ROLE_REMOVE_MSG = "RoleRemoveMsg";
	String PATH_REQUEST_ACK_MSG = "PathRequestAckMsg"; /*
														 * Message for setting
														 * trace level on Actors
														 */
	String SET_ACTOR_TRACE_MSG = "SetActorTraceMsg"; /*
													 * TraceLevel property
													 */

	/**
	 * Properties
	 */
	String REQUEST_TYPE_PROP = "requestType";

	/**
	 * Message requesting a report from an Actor
	 */
	String REPORT_REQUEST_MSG = "ReportRequestMsg";

	/**
	 * Message requesting a report from an Actor
	 */
	String REPORT_RESPONS_MSG = "ReportResponsMsg";

	/**
	 * Properties
	 */
	String ACTOR_REPORT_PROP = "actorReport";

	/**
	 * Timer Message controlling timout for a report from an Actor
	 */
	String ACTOR_REPORT_TIMER_MSG = "ActorReportTimerMsg";
	String ROLE_DENIED_MSG = "RoleDeniedMsg";
	String ROLE_DENIED_MSG_RESONCODE = "reasonCode";

	/**
	 * Message containing actors in a routing table
	 */
	String RESPONSE_LOCAL_ACTORS_MSG = "ResponseLocalActorsMsg";
	String START_PLAYING_MSG = "StartPlayingMsg";
	String STOP_PLAYING_MSG = "StopPlayingMsg";
	String CONFIGURE_MSG = "ConfigureMsg";

	/**
	 * TimerMessage that controls the updateperiod for the routing system
	 */
	String ROUTER_UPDATE_TIMER_MSG = "RouterUpdateTimerMsg";

	/**
	 * Run an update on the actors
	 */

	/**
	 * Message requesting a status from an Actor
	 */
	String REQUEST_STATUS_MSG = "RequestStatusMsg";

	/**
	 * Properties
	 */

	// String REQUEST_TYPE_PROP = "requestType";
	String RESULT_TYPE_PROP = "resultType";

	/**
	 * Message containing status from an Actor
	 */
	String RESPONS_STATUS_MSG = "ResponsStatusMsg";

	/**
	 * Properties
	 */

	// String RESULT_PROP = "result";
	// String RESULT_TYPE_PROP = "resultType";
	String JAVA_OBJECT_PROP = "javaObject";
	String CONNECTOR_RELEASE_MSG = "ConnectorReleaseMsg";

	/**
	 * Message indicating request for adding an Actor
	 */
	String DELETE_ACTOR_MSG = "DeleteActorMsg";
	String CONNECTOR_DENIED_MSG = "ConnectorDeniedMsg";

	/**
	 * Messages used to suspending and resume an actor
	 */
	String SUSPEND_MSG = "SuspendMsg";
	String SUSPENDED_MSG = "SuspendedMsg";
	String RESUME_MSG = "ResumeMsg";
	String RESUMED_MSG = "ResumedMsg";

	String APPLICATION_SPEC_CHANGED_MSG = "ApplicationSpecChanged";
	String APPLICATION_SPEC_CHANGED_MSG_APP_SPEC = "AppSpec";

	String ROLE_RESTART_MSG = "RoleRestartMsg";

	/**
	 * Properties
	 */
	String ACTOR_TYPE_PROP = "actorType";

	/**
	 * Message indicating request for adding an Actor
	 */
	String ADD_ACTOR_MSG = "AddActorMsg";
	String ADD_ACTOR_MSG_ACTOR_TYPE = "type";
	String ADD_ACTOR_MSG_ACTOR_ID = "id";

	/**
	 * Properties
	 */
	String ACTOR_ID_PROP = "actorId";
}
