/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.InputStream;
import junit.framework.TestCase;
import org.coos.actorframe.ActorSM;
import org.coos.actorframe.ActorSpecParser;
import org.coos.actorframe.application.Application;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.J2SEContainerImpl;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.ApplicationTester;

public abstract class TestApplication
extends TestCase
implements AFConstants {
    private ApplicationTester app;
    private ApplicationSpec appSpec;
    private Container container;
    private int timeout = 1000;

    protected void setUp() throws Exception {
        if (this.app == null) {
            TestApplication.assertNotNull((String)"TestApplication setUp() method requires an application spec. Use setAppSpec().", (Object)this.appSpec);
            this.app = new ApplicationTester(this.appSpec);
        }
        if (this.container == null) {
            this.container = new J2SEContainerImpl((Application)this.app);
        }
        super.setUp();
    }

    protected ApplicationSpec createApplicationSpec(String name) {
        InputStream fi = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        ApplicationSpec appSpec = new ApplicationSpec("ApplicationTester");
        ActorSpecParser.parseXml((InputStream)fi, (ApplicationSpec)appSpec, (Container)this.container);
        return appSpec;
    }

    protected void startApp() {
        this.container.start();
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected ApplicationTester getApp() {
        return this.app;
    }

    protected void setApp(ApplicationTester app) {
        this.app = app;
    }

    protected ApplicationSpec getAppSpec() {
        return this.appSpec;
    }

    public void setAppSpec(ApplicationSpec appSpec) {
        this.appSpec = appSpec;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected void setContainer(Container container) {
        this.container = container;
    }

    protected int timeout() {
        return this.timeout;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected ActorSM waitCreationOfActor(String actorAddress, int timeOut) {
        long timeAtStart = System.currentTimeMillis();
        ActorSM actor = null;
        while (actor == null) {
            actor = (ActorSM)this.app.getStateMachine(actorAddress);
            long waitTime = System.currentTimeMillis() - timeAtStart;
            if (timeOut > 0 && waitTime > (long)timeOut) break;
            this.sleep(10);
        }
        return actor;
    }

    protected ActorSM waitCreationOfActor(String actorAddress) {
        return this.waitCreationOfActor(actorAddress, 0);
    }

    protected String getCurrentState(ActorSM actor) {
        if (actor.getCurrentState() != null) {
            return actor.getCurrentState().stateName();
        }
        return "null";
    }

    protected boolean waitForState(ActorSM actor, String stateName, int timeOut) {
        long timeAtStart = System.currentTimeMillis();
        String currState = this.getCurrentState(actor);
        while (!currState.equals(stateName)) {
            long waitTime = System.currentTimeMillis() - timeAtStart;
            if (timeOut > 0 && waitTime > (long)timeOut) {
                return false;
            }
            this.sleep(10);
            currState = this.getCurrentState(actor);
        }
        return true;
    }
}

