/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Enumeration;
import java.util.Hashtable;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.ActorMsg;

public abstract class CompositeState
extends State {
    public StateMachine curfsm;
    public Hashtable children = new Hashtable();

    public CompositeState(String sn, CompositeState cs) {
        super(sn, cs);
    }

    public CompositeState(String s) {
        super(s, null);
    }

    protected void exitState(int exitNo, StateMachine curfsm) {
        curfsm.exitStateIsDone = true;
        curfsm.setCurrentState(this.enclosingState);
        this.enclosingState.outofInnerCompositeState(this, exitNo, curfsm);
    }

    protected void performExit(StateMachine curfsm) {
        if (curfsm.performExitIsDone) {
            return;
        }
        State st = curfsm.getCurrentState();
        curfsm.performExitIsDone = true;
        do {
            st.exit(curfsm);
        } while (this != (st = st.enclosingState));
        curfsm.setCurrentState(this);
    }

    protected void performExit(StateMachine curfsm, CompositeState cs) {
        if (curfsm.performExitIsDone) {
            return;
        }
        if (curfsm.getScheduler().isTraceOn()) {
            curfsm.trace.traceWarning("Method performExit() is called with illegal Composite state, not of RoleCS type ");
        }
        if (curfsm.performExitIsDone) {
            if (curfsm.getScheduler().isTraceOn()) {
                curfsm.trace.traceWarning("Method sameState() is not allowed to be called, when performExit() is already called");
            }
        } else {
            curfsm.sameStateIsDone = true;
            curfsm.nextState = null;
        }
    }

    protected void sameState(StateMachine curfsm) {
        if (curfsm.performExitIsDone) {
            if (curfsm.getScheduler().isTraceOn()) {
                curfsm.trace.traceWarning("Method sameState() is not allowed to be called, when performExit() is already called");
            }
        } else {
            curfsm.sameStateIsDone = true;
            curfsm.nextState = null;
        }
    }

    protected void save(ActorMsg sig, StateMachine curfsm) {
        curfsm.saveDone = true;
        if (!curfsm.sameStateIsDone && !curfsm.performExitIsDone) {
            curfsm.saveQueue.addMessage(sig);
            if (curfsm.getScheduler().isTraceOn()) {
                curfsm.trace.traceTask("Input signal saved");
            }
        } else if (curfsm.getScheduler().isTraceOn()) {
            curfsm.trace.traceWarning("Method save(): Signal " + sig + " not saved, because the input signal has already triggered a transition");
        }
    }

    @Override
    public State findCurrentState(String sn) {
        State st = (State)this.children.get(sn);
        if (st == null) {
            Enumeration en = this.children.elements();
            while (en.hasMoreElements()) {
                State state = (State)en.nextElement();
                st = state.findCurrentState(sn);
                if (st == null) continue;
                return st;
            }
        }
        return st;
    }

    public void enterState(int enterNo, StateMachine curfsm) {
        throw new IllegalStateException("This method must be overriden!");
    }

    @Override
    public void enterState(StateMachine curfsm) {
        throw new IllegalStateException("This method must be overriden!");
    }

    public abstract void execTrans(ActorMsg var1, State var2, StateMachine var3);

    public void outofInnerCompositeState(CompositeState cs, int exNo, StateMachine curfsm) {
    }
}

