/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.Message;
import org.coos.javaframe.messages.OptimizedMsg;
import org.coos.javaframe.messages.RouterManagementMsg;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.StringHelper;

public class RouterMsg
extends Message {
    public byte typeOfMessage;
    public ActorAddress receiver;
    public ActorAddress sender;
    public int timeToLive;
    public String className;
    public int msgLength;
    public byte[] data;
    public boolean receivingRoutingInfo;
    public static final byte ROUTER_MESSAGE = 1;
    public static final byte ACTOR_MESSAGE = 2;
    public static final byte TEST_MESSAGE = 3;
    public static final byte OPTIMIZED_MESSAGE = 4;
    public static final byte AFPROPERTY_MESSAGE = 5;
    public static final byte CLDC_MESSAGE = 6;
    public static final int NORMAL_TIME_TO_LIVE = 10;
    private static String AFPROPERTY_CLASS_NAME = "org.coos.javaframe.messages.AFPropertyMsg";
    private Logger log;

    public RouterMsg() {
        this.log = LoggerFactory.getLogger(this.getClass().getName());
    }

    public RouterMsg(ActorMsg msg) throws IOException {
        this.initClass(msg, 10);
    }

    public RouterMsg(ActorMsg msg, int timeToLive) throws IOException {
        this.initClass(msg, timeToLive);
    }

    private void initClass(ActorMsg msg, int timeToLive) throws IOException {
        if (msg instanceof RouterManagementMsg) {
            this.typeOfMessage = 1;
        } else if (msg instanceof OptimizedMsg) {
            this.typeOfMessage = (byte)4;
            this.className = "OptimizedMsg";
        } else if (msg instanceof AFPropertyMsg) {
            this.typeOfMessage = (byte)5;
            this.className = AFPROPERTY_CLASS_NAME;
        } else {
            this.typeOfMessage = (byte)2;
        }
        this.receiver = msg.getReceiverRole();
        this.sender = msg.getSenderRole();
        this.timeToLive = timeToLive;
        this.data = msg.serialize();
        this.msgLength = this.data.length;
        if (this.className == null) {
            this.className = msg.getClass().getName();
        }
    }

    public RouterMsg(byte[] indata) throws IOException {
        this(new ByteArrayInputStream(indata));
    }

    public RouterMsg(InputStream is) throws IOException {
        DataInputStream din = new DataInputStream(is);
        this.typeOfMessage = din.readByte();
        if (this.typeOfMessage == 4) {
            String actorId = din.readUTF();
            String actorType = din.readUTF();
            this.sender = new ActorAddress(actorId, actorType);
            this.receiver = OptimizedMsg.sendAddress;
            this.timeToLive = 20;
            this.msgLength = din.readInt();
            this.data = new byte[this.msgLength];
            din.readFully(this.data, 0, this.msgLength);
            this.className = "OptimizedMsg";
        } else if (this.typeOfMessage == 3) {
            this.sender = null;
            this.receiver = null;
        } else if (this.typeOfMessage == 5) {
            this.receiver = ActorAddressHelper.resurrect(din);
            this.sender = ActorAddressHelper.resurrect(din);
            this.timeToLive = din.readInt();
            this.receivingRoutingInfo = din.readBoolean();
            this.msgLength = din.readInt();
            this.data = new byte[this.msgLength];
            din.readFully(this.data, 0, this.msgLength);
            this.className = AFPROPERTY_CLASS_NAME;
        } else if (this.typeOfMessage == 6) {
            this.timeToLive = 10;
            this.receivingRoutingInfo = false;
            this.msgLength = din.readInt();
            this.data = new byte[this.msgLength];
            din.readFully(this.data, 0, this.msgLength);
            this.className = AFPROPERTY_CLASS_NAME;
            ActorAddress[] header = this.readHeader(this.data);
            this.receiver = header[0];
            this.sender = header[1];
        } else if (this.typeOfMessage == 1 || this.typeOfMessage == 2) {
            this.receiver = ActorAddressHelper.resurrect(din);
            this.sender = ActorAddressHelper.resurrect(din);
            this.timeToLive = din.readInt();
            this.className = StringHelper.resurrect((DataInputStream)din);
            this.receivingRoutingInfo = din.readBoolean();
            this.msgLength = din.readInt();
            this.data = new byte[this.msgLength];
            din.readFully(this.data, 0, this.msgLength);
        }
    }

    private ActorAddress[] readHeader(byte[] data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        return new ActorAddress[]{ActorAddressHelper.resurrect(din), ActorAddressHelper.resurrect(din)};
    }

    public ActorMsg deSerializeMessage() throws IOException {
        return this.deSerializeMessage(null);
    }

    public ActorMsg deSerializeMessage(AFClassLoader loader) throws IOException {
        try {
            ActorMsg msg;
            if (this.typeOfMessage == 4) {
                msg = new OptimizedMsg();
                this.className = "OptimizedMsg";
                msg.setReceiverRole(this.receiver);
                msg.setSenderRole(this.sender);
            } else if (this.typeOfMessage == 5) {
                msg = new AFPropertyMsg();
                this.updatePropMsg((AFPropertyMsg)msg);
            } else if (this.typeOfMessage == 6) {
                msg = new AFPropertyMsg();
            } else {
                Class cl = loader == null ? Class.forName(this.className) : loader.loadClass(this.className);
                msg = (ActorMsg)cl.newInstance();
            }
            msg.deSerialize(this.data, loader);
            return msg;
        }
        catch (ClassNotFoundException e) {
            this.log.log(4, 2, "RouterMsg.deSerializeMessage:Class name for the message not found: " + this.className);
            return null;
        }
        catch (IllegalAccessException e) {
            this.log.log(4, 2, "RouterMsg.deSerializeMessage:IllegalAccessException occured: " + e);
            return null;
        }
        catch (InstantiationException e) {
            this.log.log(4, 2, "RouterMsg.deSerializeMessage:InstantiationException occured: " + e);
            return null;
        }
    }

    public AFPropertyMsg updatePropMsg(AFPropertyMsg pm) {
        AFPropertyMsg rrm;
        if ((pm.equals("RolePlayMsg") || pm.equals("RoleConfirmMsg")) && !(rrm = (AFPropertyMsg)pm.getProperty("rrm")).getSenderRole().isIpAddressSet()) {
            rrm.getSenderRole().setActorIP(pm.getSenderRole().getActorIP());
            rrm.getSenderRole().setActorIPPort(pm.getSenderRole().getActorIPPort());
            rrm.getSenderRole().setProtocol(pm.getSenderRole().getProtocol());
        }
        return pm;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte(this.typeOfMessage);
        if (this.typeOfMessage == 1 || this.typeOfMessage == 2) {
            dout.write(ActorAddressHelper.persist(this.receiver));
            dout.write(ActorAddressHelper.persist(this.sender));
            dout.writeInt(this.timeToLive);
            dout.write(StringHelper.persist((String)this.className));
            dout.writeBoolean(this.receivingRoutingInfo);
            dout.writeInt(this.msgLength);
            dout.write(this.data);
        } else if (this.typeOfMessage == 5) {
            dout.write(ActorAddressHelper.persist(this.receiver));
            dout.write(ActorAddressHelper.persist(this.sender));
            dout.writeInt(this.timeToLive);
            dout.writeBoolean(this.receivingRoutingInfo);
            dout.writeInt(this.msgLength);
            dout.write(this.data);
        } else if (this.typeOfMessage == 6) {
            dout.writeInt(this.msgLength);
            dout.write(this.data);
        } else if (this.typeOfMessage == 4) {
            dout.writeUTF(this.sender.getActorID());
            dout.writeUTF(this.sender.getActorType());
            dout.writeInt(this.msgLength);
            dout.write(this.data);
        } else if (this.typeOfMessage == 3) {
            // empty if block
        }
        dout.close();
        out.close();
        return out.toByteArray();
    }

    public byte getTypeOfMessage() {
        return this.typeOfMessage;
    }

    public void setTypeOfMessage(byte typeOfMessage) {
        this.typeOfMessage = typeOfMessage;
    }

    public ActorAddress getReceiver() {
        return this.receiver;
    }

    public ActorAddress getSender() {
        return this.sender;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setReceiver(ActorAddress receiver) {
        this.receiver = receiver;
    }

    public void setSender(ActorAddress sender) {
        this.sender = sender;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isReceivingRoutingInfo() {
        return this.receivingRoutingInfo;
    }

    public void setReceivingRoutingInfo(boolean receivingRoutingInfo) {
        this.receivingRoutingInfo = receivingRoutingInfo;
    }

    @Override
    public String messageContent() {
        StringBuffer sb = new StringBuffer("RouterMsg:");
        sb.append(" ClassName: " + this.className);
        sb.append(" MsgLength " + this.msgLength);
        sb.append(" TypeOfMessage:" + this.typeOfMessage);
        sb.append(" Receiver: " + this.receiver);
        sb.append(" Sender:" + this.sender);
        sb.append(" ReceivingRoutingInfo: " + this.receivingRoutingInfo);
        return sb.toString();
    }

    public String toString() {
        return "RouterMsg type:" + this.typeOfMessage;
    }
}

