/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.javaframe.SchedulerSpec;

import java.util.Vector;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class DomainSpec {

	private Vector schedulerSpec = new Vector();
	private String actor;
	private String name;
	private String domainName;
	private boolean validated = false;

	public DomainSpec(String name, String actor) {
		this.actor = actor;
		this.name = name;
		this.domainName = name + System.currentTimeMillis();
	}

	public String getActor() {
		return actor;
	}

	/**
	 * Get the domain name.
	 * 
	 * @return domainName
	 */
	public String getDomainName() {
		return domainName;
	}

	/**
	 * Set domain name. If not set, a unique domainName is created by combining
	 * <code>name</code> and time.
	 * 
	 * @param domainName
	 */
	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public String getName() {
		return name;
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!(o instanceof DomainSpec))
			return false;

		DomainSpec that = (DomainSpec) o;

		if (name != null ? !name.equals(that.name) : that.name != null)
			return false;

		return true;
	}

	public void addSchedulerSpec(String actorType, int threads) {
		SchedulerSpec ss = new SchedulerSpec();
		ss.setThreads(threads);
		ss.setId(actorType);
		schedulerSpec.addElement(ss);
	}

	public void addSchedulerSpec(SchedulerSpec spec) {
		schedulerSpec.addElement(spec);
	}

	public Vector getSchedulerSpecs() {
		return schedulerSpec;
	}

	public void setSchedulerSpec(Vector schedulerSpec) {
		this.schedulerSpec = schedulerSpec;
	}

	public boolean isValidated() {
		return validated;
	}

	public void setValidated(boolean validated) {
		this.validated = validated;
	}

	public SchedulerSpec getSchedulerSpec(String id) {
		for (int i = 0; i < schedulerSpec.size(); i++) {
			SchedulerSpec spec = (SchedulerSpec) schedulerSpec.elementAt(i);
			if (spec.getId().equals(id)) {
				return spec;
			}
		}
		return null;
	}

	public SchedulerSpec containsActorType(String actorType) {
		for (int i = 0; i < schedulerSpec.size(); i++) {
			SchedulerSpec spec = (SchedulerSpec) schedulerSpec.elementAt(i);
			if (spec.getActorType(actorType) != null)
				return spec;
		}
		return null;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(" Name: <" + name + "> Domain actor: <" + actor + "> Domain name: <" + domainName + ">");
		if (schedulerSpec != null) {
			for (int i = 0; i < schedulerSpec.size(); i++) {
				SchedulerSpec spec = (SchedulerSpec) schedulerSpec.elementAt(i);
				sb.append("\n   " + spec.toString());
			}
		}
		return sb.toString();
	}
}
