/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.javaframe.messages.ActorMsg;

/**
 * 
 * @author Knut Eilif Husa, Tellu AS
 */
public abstract class SchedulableAdapter implements Schedulable {
	Scheduler sched;
	MailBox mailbox = new MailBox();
	ActorAddress address;

	protected SchedulableAdapter(ActorAddress address) {
		this.address = address;
	}

	public MailBox getMailbox() {
		return this.mailbox;
	}

	public void setScheduler(Scheduler sched) {
		this.sched = sched;
	}

	public Scheduler getScheduler() {
		return this.sched;
	}

	public void processMessage(ActorMsg sig) {
	}

	public boolean isReadyToBeDeleted() {
		return false;
	}

	public void init() {
	}

	public String getType() {
		return address.getActorType();
	}

	public String getID() {
		return address.getActorID();
	}

	public ActorAddress getMyActorAddress() {
		return address;
	}

	public void destroy() {
	}

	public void pause() {
	}
}
