/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.io.IOException;

import org.coos.actorframe.application.Container;
import org.coos.util.serialize.AFClassLoader;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.Message;
import org.coos.actorframe.application.Session;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public interface Scheduler {

	void addStateMachine(StateMachine sm, String type);

	public void output(ActorMsg sig, Schedulable schedulable);

	TraceObject getTraceObject();

	void remove(ActorAddress actorAddress);

	SchedulerData getSchedulerData();

	String getName();

	void clearLastMsgFromRouter();

	AFClassLoader getClassLoader();

	StateMachine createActor(ActorMsg sig, Schedulable curfsm);

	void setStopFlag();

	void interrupt();

	void notifyScheduler();

	void addRouter(Session domainSession);

	void addSchedulable(Schedulable schedulable, ActorAddress adr);

	void removeRouter();

	void destroyApp();

	void upDateVisibleActors(StateMachine curfsm);

	void unRegVisibleActor(ActorAddress address);

	void postMessageToScheduler(Message message, Schedulable schedulable) throws IOException;

	boolean isTraceOn();

	void setTrace(boolean on);

	boolean isTraceError();

	void setTraceError(boolean on);

	void setThreads(int threads);

	void setName(String id);

	void setSchedulerData(SchedulerData schedulerData);

	void setClassLoader(Container container);

	void configure(String s);

	void start();
}
