/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.util.Enumeration;
import java.util.Vector;
import org.coos.actorframe.ActorCS;
import org.coos.actorframe.ActorPortSpec;
import org.coos.actorframe.Port;
import org.coos.actorframe.RoleSpec;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorFrameException;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.RoleCS;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class ActorSM
extends StateMachine
implements AFConstants {
    protected static String ROUTER_UPDATE_INTERVAL_ID = "ROUTER_UPDATE_INTERVAL";
    public static final String ACTOR_REPORT_TIMER = "ACTOR_REPORT_TIMER";
    public static long ACTOR_REPORT_TIMEOUT = 10000L;
    protected static final String li = "<li>";
    protected static final String lie = "</li>";
    protected static final String br = "<br>";
    protected static final String h3 = "<h3>";
    protected static final String h3e = "</h3>";
    protected static final String bold = "<b>";
    protected static final String boldend = "</b>";
    public Vector resumedActors;
    public Vector suspendedActors;
    public ActorAddress suspendActor;
    public ActorAddress resumeActor;
    public ActorSpec newActorSpec;
    public Vector removedParts;
    public Vector changedParts;
    public ActorAddress roleUpdateSender;
    public int startLevel = 0;

    public ActorSM() {
        this.setBehaviorClass(new ActorCS("ActorCS"));
    }

    public Vector clonePorts(Vector ports) {
        Vector<Object> res = new Vector<Object>();
        if (ports != null) {
            Enumeration it = ports.elements();
            while (it.hasMoreElements()) {
                ActorPortSpec ps = (ActorPortSpec)it.nextElement();
                res.addElement(ps.clone());
            }
        }
        return res;
    }

    @Override
    protected void initStateMachine() {
        if (this.myCompositeState == null) {
            this.myCompositeState = new ActorCS("ActorCS");
        }
        this.insertActorRoles(this.actorSpec.getRoleDesc());
    }

    protected void updateCompositeStructure() {
        this.readActorDescription();
        Vector partSpecs = this.actorSpec.getPartDesc();
        for (int i = 0; i < partSpecs.size(); ++i) {
            PartSpec o = (PartSpec)partSpecs.elementAt(i);
            if (this.context.sizeOfChildrenRoles(o.getRoleType()) <= o.getHigh() || !this.scheduler.isTraceOn()) continue;
            this.trace.traceOut(3, this.trace.getTraceHeader() + "INNER PART SET " + o.getRoleType() + " exceeds redefined cardinality!!");
        }
        Vector childrenRoles = this.context.getChildrenRoles();
        boolean defined = false;
        for (int i = 0; i < childrenRoles.size(); ++i) {
            String actualRoleType = ((ActorAddress)childrenRoles.elementAt(i)).getActorType();
            ActorAddress aa = (ActorAddress)childrenRoles.elementAt(i);
            defined = false;
            for (int j = 0; j < partSpecs.size(); ++j) {
                PartSpec o = (PartSpec)partSpecs.elementAt(j);
                String specRoleType = o.getRoleType();
                if (!actualRoleType.equals(specRoleType)) continue;
                defined = true;
                Vector names = this.getApplicationSpec().getActorSpec(specRoleType).getPortNames();
                AFPropertyMsg msg = new AFPropertyMsg("RoleUpdateMsg", true);
                msg.setProperty("ports", names);
                this.sendMessage((ActorMsg)msg, aa);
                break;
            }
            if (defined || !this.scheduler.isTraceOn()) continue;
            this.trace.traceOut(4, this.trace.getTraceHeader() + "PART: " + actualRoleType + " is not defined!!");
        }
        if (this.createParts() && this.scheduler.isTraceOn()) {
            this.trace.traceTask("New parts defined");
        }
    }

    @Override
    public boolean createParts() {
        return this.createParts(this.actorSpec, 4);
    }

    public boolean createParts(ActorSpec as) {
        return this.createParts(as, 4);
    }

    public boolean createParts(ActorSpec as, int level) {
        boolean childrenCreated = false;
        String s = "INNER PARTS: ";
        Vector partSpecs = as.getPartDesc();
        if (partSpecs == null) {
            throw new ActorFrameException("No part description for <" + as.getActorType() + ">");
        }
        while (!childrenCreated && level <= 4) {
            for (int i = 0; i < partSpecs.size(); ++i) {
                PartSpec ps = (PartSpec)partSpecs.elementAt(i);
                if (ps.getLevel() != level) continue;
                if (ps.getBind() != null) {
                    if (!this.scheduler.isTraceOn()) continue;
                    this.trace.traceOut(2, " Scheduler.createParts: Actor spec: " + ps.getRoleType() + " is bind to: " + ps.getBind());
                    continue;
                }
                s = s + ", " + ps.toString();
                int noOfExistingRoles = this.context.getChildrenRoles(ps.getRoleType()).size();
                if (ps.getLow() - noOfExistingRoles <= 0) continue;
                for (int j = noOfExistingRoles; j < ps.getLow(); ++j) {
                    ActorAddress aa;
                    Vector names = this.getApplicationSpec().getActorSpec(ps.getRoleType()).getPortNames();
                    AFPropertyMsg rcm = this.createRoleCreateMsg(ps, names);
                    if (ps.getRoleNames() == null || ps.getRoleNames().length <= j) {
                        String instanceName = this.getContextString() + ps.getSetId() + String.valueOf(j + noOfExistingRoles);
                        aa = new ActorAddress(instanceName, ps.getRoleType());
                    } else {
                        aa = new ActorAddress(this.getContextString() + ps.getRoleNames()[j], ps.getRoleType());
                    }
                    if (ps.getActorDomain() != null) {
                        rcm.setProperty("targetActor", aa);
                        this.context.getCreationOfChildren().addElement(aa);
                        this.sendMessage((ActorMsg)rcm, ps.getActorDomain());
                    } else {
                        this.context.getCreationOfChildren().addElement(aa);
                        this.sendMessage((ActorMsg)rcm, aa);
                    }
                    childrenCreated = true;
                }
            }
            if (childrenCreated) continue;
            ++level;
        }
        if (this.scheduler.isTraceOn()) {
            this.trace.traceOut(2, this.trace.getTraceHeader() + s);
        }
        this.startLevel = level > 4 ? 4 : level;
        return childrenCreated;
    }

    @Override
    public boolean createParts(Vector v) {
        boolean childrenCreated = false;
        Vector partSpecs = this.actorSpec.getPartDesc();
        for (int i = 0; i < partSpecs.size(); ++i) {
            PartSpec ps = (PartSpec)partSpecs.elementAt(i);
            if (ps.getBind() != null) {
                if (!this.scheduler.isTraceOn()) continue;
                this.trace.traceOut(2, " Scheduler.createParts: Actor spec: " + ps.getRoleType() + " is bind to: " + ps.getBind());
                continue;
            }
            for (int j = 0; j < v.size(); ++j) {
                Vector ports = this.getApplicationSpec().getActorSpec(ps.getRoleType()).getPortNames();
                AFPropertyMsg rcm = this.createRoleCreateMsg(ps, ports);
                ActorAddress aa = (ActorAddress)v.elementAt(j);
                String s = aa.key();
                if (!s.endsWith(ps.getRoleType())) continue;
                String actorId = s.substring(0, s.indexOf("@"));
                aa = new ActorAddress(actorId, ps.getRoleType());
                if (ps.getActorDomain() != null) {
                    String id = this.getContextString() + ps.getRoleNames()[j];
                    rcm.setProperty("targetActor", new ActorAddress(id, ps.getRoleType()));
                    this.sendMessage((ActorMsg)rcm, ps.getActorDomain());
                } else {
                    this.sendMessage((ActorMsg)rcm, aa);
                }
                childrenCreated = true;
            }
        }
        return childrenCreated;
    }

    @Override
    public boolean createPorts(Vector connectors) {
        this.ports.clear();
        boolean createdPorts = false;
        ActorPortSpec dPS = new ActorPortSpec();
        dPS.setPortName("defaultInPort");
        dPS.setIsBehavior(true);
        this.ports.put("defaultInPort", new Port(dPS, this.getMyActorAddress()));
        if (this.actorSpec.getPortDesc() == null) {
            return false;
        }
        Enumeration enumer = this.actorSpec.getPortDesc().elements();
        while (enumer.hasMoreElements()) {
            ActorPortSpec actorPortSpec = (ActorPortSpec)enumer.nextElement();
            if (this.ports.containsKey(actorPortSpec.getPortName())) continue;
            Port port = new Port(actorPortSpec, this.getMyActorAddress());
            this.ports.put(port.name, port);
            createdPorts = true;
        }
        return createdPorts;
    }

    public void createConnectors() {
        if (this.actorSpec.getConnectorDesc() == null) {
            return;
        }
        Vector parts = this.actorSpec.getPartDesc();
        for (int i = 0; i < parts.size(); ++i) {
            PartSpec spec = (PartSpec)parts.elementAt(i);
            this.createConnectors(spec);
        }
        this.createConnectorsToItself();
    }

    public void createConnectors(ActorAddress aa) {
        PartSpec ps = this.findRoleSpec(aa.getActorType(), this.actorSpec.getPartDesc());
        if (ps == null) {
            return;
        }
        Enumeration names = this.getApplicationSpec().getActorSpec(aa.getActorType()).getPortNames().elements();
        if (aa.getActorPort() != null) {
            Vector connectors = this.rewriteContextualConnectors(this.actorSpec.getConnectorDesc(aa.getActorType(), aa.getActorPort()));
            ActorAddress receiverPort = (ActorAddress)aa.clone();
            receiverPort.setActorPort(aa.getActorPort());
            AFPropertyMsg msg = new AFPropertyMsg("PortCreateMsg", true);
            msg.setFrameworkMsg(true);
            msg.setProperty("connectorAddresses", connectors);
            msg.setSenderRole(this.getMyActorAddress());
            this.sendMessage((ActorMsg)msg, receiverPort);
            return;
        }
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Vector connectors = this.rewriteContextualConnectors(this.actorSpec.getConnectorDesc(aa.getActorType(), key));
            ActorAddress receiverPort = (ActorAddress)aa.clone();
            receiverPort.setActorPort(key);
            AFPropertyMsg msg = new AFPropertyMsg("PortCreateMsg", true);
            msg.setFrameworkMsg(true);
            msg.setProperty("connectorAddresses", connectors);
            msg.setSenderRole(this.getMyActorAddress());
            this.sendMessage((ActorMsg)msg, receiverPort);
        }
    }

    public boolean createConnectors(PartSpec ps) {
        boolean created = false;
        Vector children = this.context.getChildrenRoles(ps.getRoleType());
        Enumeration it = this.getApplicationSpec().getActorSpec(ps.getRoleType()).getPortNames().elements();
        while (it.hasMoreElements()) {
            String portName = (String)it.nextElement();
            Vector connectors = this.actorSpec.getConnectorDesc(ps.getRoleType(), portName);
            Vector connectorsAddresses = this.rewriteContextualConnectors(connectors);
            Enumeration cit = children.elements();
            Vector<ActorAddress> portAA = new Vector<ActorAddress>();
            block1: while (cit.hasMoreElements()) {
                ActorAddress recv = (ActorAddress)cit.nextElement();
                String[] roleNames = ps.getRoleNames();
                if (roleNames != null) {
                    for (int i = 0; i < roleNames.length; ++i) {
                        String roleName = roleNames[i];
                        if (!recv.getActorID().endsWith(roleName)) continue;
                        recv = (ActorAddress)recv.clone();
                        recv.setActorPort(portName);
                        portAA.addElement(recv);
                        created = true;
                        continue block1;
                    }
                    continue;
                }
                if (!recv.getActorID().endsWith("Set" + ps.getSetNo())) continue;
                recv = (ActorAddress)recv.clone();
                recv.setActorPort(portName);
                portAA.addElement(recv);
                created = true;
            }
            AFPropertyMsg pcm = new AFPropertyMsg("PortCreateMsg", true);
            pcm.setProperty("connectorAddresses", connectorsAddresses);
            pcm.setSenderRole(this.getMyActorAddress());
            this.sendMessage((ActorMsg)pcm, portAA);
        }
        return created;
    }

    public void createConnectorsToItself() {
        Enumeration names = this.getActorSpec().getPortNames().elements();
        while (names.hasMoreElements()) {
            String portName = (String)names.nextElement();
            Vector connectors = this.actorSpec.getConnectorDesc(this.getMyActorAddress().getActorType(), portName);
            Vector v = this.rewriteContextualConnectors(connectors);
            AFPropertyMsg pcm = new AFPropertyMsg("PortCreateMsg", true);
            pcm.setProperty("connectorAddresses", v);
            pcm.setSenderRole(this.getMyActorAddress());
            pcm.setFrameworkMsg(true);
            this.sendMessage((ActorMsg)pcm, portName);
        }
    }

    @Override
    protected void initInstance() {
    }

    public void addPort(Port port) {
        this.ports.put(port.name, port);
    }

    public void removePort(Port port) {
        if (this.ports.containsKey(port.name)) {
            this.ports.remove(port);
        }
    }

    public Port getPort(String portName) {
        if (this.ports.containsKey(portName)) {
            return (Port)this.ports.get(portName);
        }
        return null;
    }

    @Override
    protected void processPortMessage(ActorMsg msg) {
        this.myActorId = msg.getReceiverRole().getActorID();
        this.myActorType = msg.getReceiverRole().getActorType();
        Port port = this.getPort(msg.getReceiverRole().getActorPort());
        if (port != null) {
            this.trace.traceInit(this);
            this.trace.setActor(msg.getReceiverRole());
            this.trace.setInputSignal(msg);
            port.exec(msg, this);
        } else if (this.scheduler.isTraceOn()) {
            this.trace.traceError("Port: " + msg.getReceiverRole().getActorPort() + " set in ActorMsg, but the Port was not found for the ActorAddress " + msg.getReceiverRole());
        }
        if (this.scheduler.isTraceOn() && this.getTraceLevel() <= 1) {
            this.trace.traceOut(1, 16, this.trace.toString());
        }
    }

    @Override
    public void processMessage(ActorMsg msg) {
        if (msg.getReceiverRole().hasActorPort()) {
            this.processPortMessage(msg);
            return;
        }
        super.processMessage(msg);
    }

    @Override
    public void sendMessage(ActorMsg am, String portName) {
        Port port = this.getPort(portName);
        if (port == null) {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError("Illegal port name: " + portName + " Message: " + am.toString());
            }
            return;
        }
        am.setSenderRole(this.getMyActorAddress());
        if (this.isTesting() && this.scheduler.isTraceOn()) {
            this.trace.traceOutput(am);
        }
        port.exec(am, this);
    }

    protected Vector searchForActors(String actorId, String actorType) {
        if (actorId == null && actorType == null) {
            return this.context.getChildrenRoles();
        }
        Vector<ActorAddress> res = new Vector<ActorAddress>();
        Vector roles = this.context.getChildrenRoles();
        for (int i = 0; i < roles.size(); ++i) {
            ActorAddress actorAddress = (ActorAddress)roles.elementAt(i);
            boolean added = false;
            if (actorId != null && actorAddress.getActorID().equals(actorId)) {
                res.addElement(actorAddress);
                added = true;
            }
            if (actorType == null || added || !actorAddress.getActorType().equals(actorType)) continue;
            res.addElement(actorAddress);
        }
        return res;
    }

    @Override
    protected boolean isCreateMsg(ActorMsg msg) {
        return msg.equals("RoleCreateMsg") || msg.equals("RolePlayMsg");
    }

    @Override
    public ApplicationSpec getApplicationSpec() {
        return this.getScheduler().getSchedulerData().getApplicationSpec();
    }

    protected String makeRoleName(String roleId) {
        String s = this.getContextString();
        return s.substring(0, s.length() - 1) + "." + roleId;
    }

    public ActorAddress createRole(String id, String className) {
        RoleCS rcs = null;
        ActorAddress actorAddress = null;
        try {
            rcs = (RoleCS)this.scheduler.getClassLoader().loadClass(className).newInstance();
            String actorId = this.myActorId + "." + id;
            actorAddress = new ActorAddress(actorId, this.myActorType);
            this.addStateMachine(id, rcs);
            if (this.scheduler.isTraceOn()) {
                this.trace.traceTask("Role: " + actorId + " added");
            }
        }
        catch (IllegalAccessException e) {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError("IllegalAccessException in method insertActorRoles()");
            }
        }
        catch (InstantiationException e) {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError("InstantiationException in method insertActorRoles()");
            }
        }
        catch (ClassNotFoundException e) {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError("ClassNotFoundException in method insertActorRoles()");
            }
            return null;
        }
        if (actorAddress != null) {
            this.sendMessage("StartPlayingMsg", actorAddress);
        }
        return actorAddress;
    }

    protected boolean insertActorRoles(Vector roleSpecs) {
        boolean res = true;
        for (int i = 0; i < roleSpecs.size(); ++i) {
            RoleSpec rs = (RoleSpec)roleSpecs.elementAt(i);
            if (!rs.isPersistent() || rs.getInstance() == null) continue;
            res = res && this.createRole(rs.getInstance(), rs.getRoleClass()) != null;
        }
        return res;
    }
}

