/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.coos.actorframe.ActorPartSpec;
import org.coos.actorframe.ActorPortSpec;
import org.coos.actorframe.ActorSpecException;
import org.coos.actorframe.RoleSpec;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.DomainSpec;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.SchedulerSpec;
import org.coos.javaframe.TraceConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActorSpecParser {
    public static ApplicationSpec parseXml(String fileName, Container container) throws ActorSpecException {
        ApplicationSpec spec = new ApplicationSpec();
        ActorSpecParser.parseXml(fileName, spec, container);
        return spec;
    }

    public static ApplicationSpec parseXml(String fileName) throws ActorSpecException {
        return ActorSpecParser.parseXml(fileName, (Container)null);
    }

    public static ApplicationSpec parseXml(String fileName, ApplicationSpec spec) throws ActorSpecException {
        return ActorSpecParser.parseXml(fileName, spec, null);
    }

    public static ApplicationSpec parseXml(String fileName, ApplicationSpec spec, Container container) throws ActorSpecException {
        InputStream is = null;
        try {
            is = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            is = null;
        }
        if (is == null) {
            is = ActorSpecParser.class.getResourceAsStream(fileName);
        }
        ActorSpecParser.parseXml(is, spec, container);
        return spec;
    }

    public static ApplicationSpec createApplicationSpec(String name, String appName) {
        return ActorSpecParser.createApplicationSpec(name, appName, null);
    }

    public static ApplicationSpec createApplicationSpec(String name, String appName, Container container) {
        ApplicationSpec appSpec = new ApplicationSpec(appName);
        appSpec = ActorSpecParser.createApplicationSpec(name, appSpec, container);
        return appSpec;
    }

    public static ApplicationSpec createApplicationSpec(String name, ApplicationSpec appSpec) {
        return ActorSpecParser.createApplicationSpec(name, appSpec, null);
    }

    public static ApplicationSpec createApplicationSpec(String name, ApplicationSpec appSpec, Container container) {
        InputStream fi = ActorSpecParser.class.getResourceAsStream(name);
        ActorSpecParser.parseXml(fi, appSpec, container);
        return appSpec;
    }

    public static void parseXml(InputStream is, ApplicationSpec spec) throws ActorSpecException {
        ActorSpecParser.parseXml(is, spec, null);
    }

    public static void parseXml(InputStream is, ApplicationSpec spec, Container container) throws ActorSpecException {
        if (is == null) {
            throw new ActorSpecException("Inputstream cannot be null. Check name of application spec. (xml) resource.");
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception e) {
            throw new ActorSpecException("Failed to parse application spec. (xml). Check content.", e);
        }
        Element appElement = doc.getDocumentElement();
        Vector traces = ActorSpecParser.getChildren(appElement, "trace");
        if (traces.size() > 0) {
            Element traceElement = (Element)traces.get(0);
            spec.setTraceEnabled(ActorSpecParser.getAttrBoolean(traceElement, "trace", spec.isTraceEnabled()));
        }
        String name = ActorSpecParser.getAttrString(appElement, "name", spec.getAppName());
        spec.setAppName(name);
        Vector descriptions = ActorSpecParser.getChildren(appElement, "description");
        String description = null;
        if (descriptions.size() > 0) {
            description = ((Element)descriptions.get(0)).getFirstChild().getNodeValue();
        }
        spec.setDescription(description);
        Vector domains = ActorSpecParser.getChildren(appElement, "domain");
        for (int x = 0; x < domains.size(); ++x) {
            DomainSpec aps = ActorSpecParser.parseDomainSpec((Element)domains.get(x), spec.getDomainSpec());
            spec.setDomainSpec(aps);
        }
        String extend = null;
        Vector actors = ActorSpecParser.getChildren(appElement, "actor");
        for (int x = 0; x < actors.size(); ++x) {
            Element e = (Element)actors.get(x);
            extend = ActorSpecParser.getAttrString(e, "extends", null);
            String type = ActorSpecParser.getAttrString(e, "name", null);
            if (type == null) {
                throw new ActorSpecException("Actor spec: No name defined in element " + e.getNodeName());
            }
            ActorSpec as = spec.getActorSpec(type);
            if (as == null) {
                as = new ActorSpec();
                as.setActorType(type);
            } else if (extend == null) {
                throw new ActorSpecException("Actor spec: actor type <" + type + "> already exist, illegal extension");
            }
            as.setActorClassName(ActorSpecParser.parseClassName(e, as, container));
            Vector roleSpecs = as.getRoleDesc();
            Vector roleSpec = ActorSpecParser.getChildren(e, "role");
            for (int i = 0; i < roleSpec.size(); ++i) {
                RoleSpec aps = ActorSpecParser.parseRoleSpec((Element)roleSpec.get(i), as);
                as.addRoleSpec(aps);
            }
            Vector actorPortSpecs = as.getPortDesc();
            Vector actorPorts = ActorSpecParser.getChildren(e, "port");
            for (int i = 0; i < actorPorts.size(); ++i) {
                ActorPortSpec aps = ActorSpecParser.parseActorPortSpec((Element)actorPorts.get(i), as);
                as.addPortSpec(aps);
            }
            Vector connectors = as.getConnectorDesc();
            connectors = ActorSpecParser.parseConnectors(e, connectors, as);
            as.setConnectorDesc(connectors);
            Vector actorPartSpecs = as.getPartDesc();
            Vector actorParts = ActorSpecParser.getChildren(e, "part");
            for (int i = 0; i < actorParts.size(); ++i) {
                ActorPartSpec aps = ActorSpecParser.parseActorPartSpec((Element)actorParts.get(i), as);
                if (as.getPartSpec(aps.getRoleType()) != null) {
                    as.deletePartSpec(aps.getRoleType());
                }
                actorPartSpecs.addElement(aps);
            }
            as.setPartDesc(actorPartSpecs);
            spec.addActorSpec(as);
        }
    }

    private static String parseClassName(Element e, ActorSpec as, Container container) {
        String className = ActorSpecParser.getAttrString(e, "class", as.getActorClassName());
        try {
            if (container != null) {
                container.loadClass(className);
            } else {
                Class.forName(className);
            }
            return className;
        }
        catch (ClassNotFoundException e1) {
            throw new ActorSpecException("Class <" + className + "> not found");
        }
    }

    private static void parseTraceSpec(Element e, PartSpec ps) {
        ps.setTraceLev(TraceConstants.getTraceLevel(ActorSpecParser.getAttrString(e, "trace", TraceConstants.getTraceLevel(ps.getTraceLev()))));
    }

    private static Vector parseConnectors(Element e, Vector connectors, ActorSpec as) {
        NodeList ic = e.getChildNodes();
        for (int x = 0; x < ic.getLength(); ++x) {
            if (!ic.item(x).getNodeName().equals("connector")) continue;
            Element connector = (Element)ic.item(x);
            String name = ActorSpecParser.getAttrString(connector, "name", null);
            if (name == null) {
                throw new ActorSpecException("Connector spec: no connector name");
            }
            ConnectorSpec cs = as.getConnectorDesc(name);
            if (cs == null) {
                cs = new ConnectorSpec();
                cs.setName(name);
            }
            cs.setIsBidirectional(ActorSpecParser.getAttrBoolean(connector, "bidirectional", cs.isBidirectional()));
            String fromString = ActorSpecParser.getAttrString(connector, "from", null);
            if (fromString == null || fromString.equals("")) {
                throw new ActorSpecException("Connector spec: from address");
            }
            cs.setFrom(new ActorAddress(fromString));
            String toString = ActorSpecParser.getAttrString(connector, "to", null);
            if (toString == null || fromString.equals("")) {
                throw new ActorSpecException("Connector spec: to address");
            }
            cs.setTo(new ActorAddress(toString));
            connectors.addElement(cs);
        }
        return connectors;
    }

    private static int getAttrInt(Element e, String name, int defaultValue) {
        String res = e.getAttribute(name);
        if (res == null || res.equals("")) {
            return defaultValue;
        }
        return Integer.parseInt(res.trim());
    }

    private static String getAttrString(Element e, String name, String defaultValue) {
        String res = e.getAttribute(name);
        if (res == null || res.equals("")) {
            return defaultValue;
        }
        return res.trim();
    }

    private static boolean getAttrBoolean(Element e, String name, boolean defaultValue) {
        String attr = e.getAttribute(name);
        boolean res = attr == null ? defaultValue : Boolean.parseBoolean(attr);
        return res;
    }

    private static Vector getChildren(Element e, String type) {
        Vector<Node> v = new Vector<Node>();
        NodeList nl = e.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            if (!nl.item(x).getNodeName().equals(type)) continue;
            v.add(nl.item(x));
        }
        return v;
    }

    private static RoleSpec parseRoleSpec(Element e, ActorSpec actorSpec) {
        String type = ActorSpecParser.getAttrString(e, "type", null);
        if (type == null) {
            throw new ActorSpecException("Actor spec: illegal role type definition");
        }
        RoleSpec aps = actorSpec.getRoleSpec(type);
        if (aps == null) {
            aps = new RoleSpec();
            aps.setType(type);
        }
        aps.setRoleClass(ActorSpecParser.getAttrString(e, "class", aps.getRoleClass()));
        aps.setInstance(ActorSpecParser.getAttrString(e, "instance", aps.getInstance()));
        aps.setPersistent(ActorSpecParser.getAttrBoolean(e, "persistent", aps.isPersistent()));
        return aps;
    }

    private static ActorPortSpec parseActorPortSpec(Element e, ActorSpec actorSpec) {
        String portName = ActorSpecParser.getAttrString(e, "name", null);
        if (portName == null) {
            throw new ActorSpecException("Port name < " + portName + "> cannot be null");
        }
        ActorPortSpec portSpec = (ActorPortSpec)actorSpec.getPortSpec(portName);
        if (portSpec == null) {
            portSpec = new ActorPortSpec(portName);
        }
        portSpec.setPortType(ActorSpecParser.getAttrString(e, "class", portSpec.getPortType()));
        portSpec.setBehavior(ActorSpecParser.getAttrBoolean(e, "isbehavior", portSpec.isBehavior()));
        return portSpec;
    }

    private static ActorPartSpec parseActorPartSpec(Element e, ActorSpec spec) {
        Vector inst;
        String roleType = ActorSpecParser.getAttrString(e, "actor", null);
        if (roleType == null) {
            throw new ActorSpecException("Part spec: illegal actor type definition");
        }
        ActorPartSpec apc = (ActorPartSpec)spec.getPartSpec(roleType);
        if (apc == null) {
            apc = new ActorPartSpec();
            apc.setRoleType(roleType);
        }
        apc.setVisible(ActorSpecParser.getAttrBoolean(e, "visible", apc.isVisible()));
        apc.setLevel(ActorSpecParser.getAttrInt(e, "level", apc.getLevel()));
        apc.setCredentialsRequired(ActorSpecParser.getAttrBoolean(e, "credentialsrequired", apc.isCredentialsRequired()));
        String ad = ActorSpecParser.getAttrString(e, "actordomain", null);
        if (ad != null) {
            apc.setActorDomain(new ActorAddress(ad));
        }
        apc.setBind(ActorSpecParser.getAttrString(e, "bind", apc.getBind()));
        apc.setSetId(ActorSpecParser.getAttrString(e, "set", apc.getSetId()));
        apc.setLow(ActorSpecParser.getAttrInt(e, "min", apc.getLow()));
        apc.setHigh(ActorSpecParser.getAttrInt(e, "max", apc.getHigh()));
        Vector rn = ActorSpecParser.toVector(apc.getRoleNames());
        String instanceName = ActorSpecParser.getAttrString(e, "instance", null);
        if (instanceName != null) {
            rn.add(instanceName);
        }
        Hashtable<String, Hashtable> instanceProperties = null;
        Hashtable properties = ActorSpecParser.readProperties(e);
        if (properties != null) {
            instanceProperties = new Hashtable<String, Hashtable>();
            instanceProperties.put("default", properties);
        }
        if ((inst = ActorSpecParser.getChildren(e, "instance")).size() > 0 && instanceProperties == null) {
            instanceProperties = new Hashtable();
        }
        for (int i = 0; i < inst.size(); ++i) {
            Element ie = (Element)inst.get(i);
            String s = ActorSpecParser.getAttrString(ie, "name", null);
            if (s == null) continue;
            rn.add(s);
            properties = ActorSpecParser.readProperties(ie);
            if (properties == null) continue;
            instanceProperties.put(s, properties);
        }
        apc.setActorProperties(instanceProperties);
        apc.setRoleNames(ActorSpecParser.toStringArray(rn));
        ActorSpecParser.parseTraceSpec(e, apc);
        return apc;
    }

    private static String[] toStringArray(Vector v) {
        if (v == null) {
            return new String[0];
        }
        String[] sa = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            sa[i] = (String)v.elementAt(i);
        }
        return sa;
    }

    private static Vector toVector(String[] sa) {
        Vector<String> v = new Vector<String>();
        if (sa == null) {
            return v;
        }
        for (int i = 0; i < sa.length; ++i) {
            v.add(sa[i]);
        }
        return v;
    }

    private static Hashtable readProperties(Element ie) {
        Vector itProps = ActorSpecParser.getChildren(ie, "property");
        if (itProps.size() > 0) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            for (int x = 0; x < itProps.size(); ++x) {
                Element ieProp = (Element)itProps.get(x);
                properties.put(ActorSpecParser.getAttrString(ieProp, "name", null), ActorSpecParser.getAttrString(ieProp, "value", null));
            }
            return properties;
        }
        return null;
    }

    private static DomainSpec parseDomainSpec(Element e, DomainSpec domainSpec) {
        String actor = ActorSpecParser.getAttrString(e, "actor", "ActorDomain");
        String name = ActorSpecParser.getAttrString(e, "name", actor);
        boolean validated = ActorSpecParser.getAttrBoolean(e, "validated", false);
        String extend = ActorSpecParser.getAttrString(e, "extends", null);
        if (domainSpec == null) {
            domainSpec = new DomainSpec(name, actor);
        } else if (extend == null) {
            throw new ActorSpecException("Domain <" + domainSpec.getName() + "> already exists, no extension is defined");
        }
        domainSpec.setValidated(validated);
        Vector scheduler = ActorSpecParser.getChildren(e, "scheduler");
        if (scheduler.size() > 0) {
            for (int i = 0; i < scheduler.size(); ++i) {
                Element et = (Element)scheduler.get(i);
                String id = ActorSpecParser.getAttrString(et, "name", "sched" + String.valueOf(i));
                if (id == null) {
                    throw new ActorSpecException("Scheduler name not defined");
                }
                SchedulerSpec ss = domainSpec.getSchedulerSpec(id);
                if (ss == null) {
                    ss = new SchedulerSpec();
                    ss.setId(id);
                }
                String threads = ActorSpecParser.getAttrString(et, "threads", String.valueOf(ss.getThreads()));
                ss.setThreads(Integer.parseInt(threads));
                if (ss.getThreads() > 1) {
                    ss.setClassName("org.coos.javaframe.ThreadPooledScheduler");
                } else {
                    ss.setClassName("org.coos.javaframe.SchedulerImpl");
                }
                Vector r = ActorSpecParser.getChildren(et, "actor");
                for (int x = 0; x < r.size(); ++x) {
                    String actorType = ActorSpecParser.getAttrString((Element)r.get(x), "type", null);
                    SchedulerSpec spec = domainSpec.containsActorType(actorType);
                    if (spec != null) {
                        throw new ActorSpecException("Scheduler: actor: " + actorType + " is already defined in <" + spec.getId() + ">");
                    }
                    ss.addActorType(actorType);
                }
                domainSpec.addSchedulerSpec(ss);
            }
        } else {
            SchedulerSpec ss = new SchedulerSpec();
            ss.setId("default");
            domainSpec.addSchedulerSpec(ss);
        }
        return domainSpec;
    }
}

