/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.ActorPortSpec;
import org.coos.actorframe.PortSM;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public final class Port
implements AFConstants {
    private Vector outConnectors;
    private Vector inConnectors;
    private Vector requesterConnectors;
    private Vector createConnectors;
    private Vector routeQueue = new Vector();
    private Vector messageQueue = new Vector();
    private Hashtable createTimers;
    public ActorAddress portAddress;
    public ActorAddress actorsAddress;
    public String name;
    private boolean isBehavior = false;
    private boolean hideInner = false;
    private boolean sessionEnabled = false;
    private Hashtable clientSessions;
    private PortSM protocolSM;
    private ActorAddress sender;

    public Port(ActorPortSpec actorPortSpec, ActorAddress actorsAddress) {
        this.name = actorPortSpec.portName;
        this.isBehavior = actorPortSpec.isBehavior;
        this.hideInner = actorPortSpec.hideInner;
        this.portAddress = (ActorAddress)actorsAddress.clone();
        this.portAddress.setActorPort(this.name);
        this.actorsAddress = actorsAddress;
        this.sessionEnabled = actorPortSpec.sessionEnabled;
        if (this.sessionEnabled) {
            this.clientSessions = new Hashtable();
        }
        if (actorPortSpec.getPortType() != null) {
            this.setPortSM(actorPortSpec.getPortType());
        } else {
            this.setPortSM(new PortSM());
        }
    }

    protected void setPortSM(PortSM psm) {
        psm.initInstance();
        psm.enterState(this);
        this.protocolSM = psm;
    }

    protected void setPortSM(String className) {
        if (className == null || className.equals("")) {
            this.protocolSM = new PortSM();
        } else {
            if (className.indexOf(".") == -1) {
                className = "actor." + this.actorsAddress.getActorType().toLowerCase() + "." + className;
            }
            try {
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                this.protocolSM = !(o instanceof PortSM) ? new PortSM() : (PortSM)o;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.protocolSM = new PortSM();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                this.protocolSM = new PortSM();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                this.protocolSM = new PortSM();
            }
        }
        this.protocolSM.initInstance();
        this.protocolSM.enterState(this);
    }

    protected void reconfigurePort(ActorPortSpec ps) {
        this.name = ps.portName;
        this.isBehavior = ps.isBehavior;
        this.hideInner = ps.hideInner;
    }

    public void exec(ActorMsg sig, StateMachine curfsm) {
        if (curfsm.isTesting()) {
            curfsm.trace.addPortInputSignal(this.name, sig);
        }
        if (sig.isFrameworkMsg()) {
            this.execTrans(sig, curfsm);
            this.handleMessages(curfsm);
            this.handleTimers(curfsm);
            return;
        }
        this.protocolSM.execTrans(sig, this.protocolSM.getCurrentState(), this);
        this.handleMessages(curfsm);
        this.handleTimers(curfsm);
    }

    private void handleTimers(StateMachine curfsm) {
        if (this.createTimers != null && !this.createTimers.isEmpty()) {
            Enumeration e = this.createTimers.keys();
            while (e.hasMoreElements()) {
                String timerid = (String)e.nextElement();
                Long duration = (Long)this.createTimers.get(timerid);
                if (duration == null) {
                    curfsm.stopTimer(timerid);
                    continue;
                }
                curfsm.startTimer(duration, timerid, this.portAddress);
            }
            this.createTimers.clear();
        }
    }

    private void handleMessages(StateMachine curfsm) {
        int i;
        if (this.routeQueue != null && !this.routeQueue.isEmpty()) {
            for (i = 0; i < this.routeQueue.size(); ++i) {
                this.routeMessage((ActorMsg)this.routeQueue.elementAt(i), curfsm);
            }
            this.routeQueue.removeAllElements();
        }
        if (this.messageQueue != null && !this.messageQueue.isEmpty()) {
            for (i = 0; i < this.messageQueue.size(); ++i) {
                curfsm.sendMessage((ActorMsg)this.messageQueue.elementAt(i));
            }
            this.messageQueue.removeAllElements();
        }
    }

    public void sendMessage(ActorMsg msg) {
        this.routeQueue.addElement(msg);
    }

    public void sendMessage(ActorMsg msg, ActorAddress aa) {
        msg.setReceiverRole(aa);
        this.messageQueue.addElement(msg);
    }

    public void sendMessage(ActorMsg msg, Vector addressess) {
        Enumeration enumer = addressess.elements();
        while (enumer.hasMoreElements()) {
            ActorMsg tmpMsg = msg.cloneMsg(null);
            msg.setReceiverRole((ActorAddress)enumer.nextElement());
            this.messageQueue.addElement(tmpMsg);
        }
    }

    public void startTimer(long duration, String timerId) {
        if (this.createTimers == null) {
            this.createTimers = new Hashtable();
        }
        this.createTimers.put(timerId, new Long(duration));
    }

    public void stopTimer(String timerId) {
        if (this.createTimers == null) {
            this.createTimers = new Hashtable();
        }
        this.createTimers.put(timerId, null);
        if (this.createTimers.isEmpty()) {
            this.createTimers = null;
        }
    }

    private void routeMessage(ActorMsg msg, StateMachine curfsm) {
        ActorAddress sender = msg.getSenderRole();
        if (this.isBehavior) {
            msg.setReceiverRole(this.actorsAddress);
            curfsm.sendMessage(msg);
            return;
        }
        if ((this.outConnectors == null || this.outConnectors.isEmpty()) && (this.inConnectors == null || this.inConnectors.isEmpty())) {
            if (curfsm.getScheduler().isTraceOn()) {
                curfsm.trace.traceError(" No connectors to this port: " + this.portAddress + " Message: " + msg.toString());
            }
            return;
        }
        if (sender == null || sender.equals(this.actorsAddress)) {
            if (this.outConnectors.size() > 0) {
                curfsm.sendMessage(msg, this.outConnectors);
                if (this.inConnectors != null && this.inConnectors.size() > 0) {
                    ActorMsg sig = msg.getCopy(curfsm.getScheduler().getClassLoader());
                    curfsm.sendMessage(sig, this.inConnectors);
                }
            } else {
                curfsm.sendMessage(msg, this.outConnectors);
            }
            if (curfsm.isTesting()) {
                curfsm.trace.addPortOutputSignal(this.name, msg);
            }
        } else if (this.actorsAddress.isInnerActor(sender)) {
            curfsm.sendMessage(msg, this.outConnectors);
        } else {
            curfsm.sendMessage(msg, this.inConnectors);
        }
    }

    protected void execTrans(ActorMsg sig, StateMachine curfsm) {
        if (sig.equals("PortCreateMsg")) {
            AFPropertyMsg crm;
            Vector connectors = (Vector)sig.getProperty("connectorAddresses");
            this.sender = null;
            for (int i = 0; i < connectors.size(); ++i) {
                ConnectorSpec cs = (ConnectorSpec)connectors.elementAt(i);
                ActorAddress address = (ActorAddress)cs.getTo().clone();
                if (address.getActorPort() == null || address.getActorPort().equals("")) {
                    address.setActorPort("defaultInPort");
                }
                if (this.getConfiguredConnectors().contains(address)) continue;
                crm = new AFPropertyMsg("ConnectorRequestMsg", true);
                crm.setBoolean("requestBidirectional", cs.getIsBidirectional());
                crm.setSenderRole(this.portAddress);
                crm.setReceiverRole(address);
                crm.setFrameworkMsg(true);
                curfsm.sendMessage(crm);
                if (this.createConnectors == null) {
                    this.createConnectors = new Vector();
                }
                this.createConnectors.addElement(address);
            }
            Enumeration ite = null;
            if (this.portAddress.isInnerActor(sig.getSenderRole())) {
                if (this.inConnectors != null) {
                    ite = this.inConnectors.elements();
                }
            } else if (this.outConnectors != null) {
                ite = this.outConnectors.elements();
            }
            while (ite != null && ite.hasMoreElements()) {
                ActorAddress ex = (ActorAddress)ite.nextElement();
                Vector conns = ConnectorSpec.getAddresses(connectors);
                if (conns.contains(ex)) continue;
                crm = new AFPropertyMsg("ConnectorReleaseMsg", true);
                crm.setSenderRole(this.portAddress);
                this.remove(ex);
                crm.setFrameworkMsg(true);
                crm.setReceiverRole(ex);
                curfsm.sendMessage(crm);
            }
            if (this.createConnectors == null) {
                this.createConnectors = new Vector();
            }
            if (this.createConnectors.isEmpty()) {
                AFPropertyMsg pcam = new AFPropertyMsg("PortCreateAckMsg", true);
                pcam.setFrameworkMsg(true);
                pcam.setReceiverRole(this.actorsAddress);
                pcam.setSenderRole(this.portAddress);
                curfsm.sendMessage(pcam);
            }
            return;
        }
        if (sig.equals("ConnectorRequestMsg")) {
            boolean bidir = sig.getBoolean("requestBidirectional");
            if (bidir) {
                if (this.actorsAddress.isInnerActor(sig.getSenderRole())) {
                    if (this.inConnectors == null) {
                        this.inConnectors = new Vector();
                    }
                    Port.addConnector(this.inConnectors, sig.getSenderRole());
                } else {
                    if (this.outConnectors == null) {
                        this.outConnectors = new Vector();
                    }
                    Port.addConnector(this.outConnectors, sig.getSenderRole());
                }
            } else {
                if (this.requesterConnectors == null) {
                    this.requesterConnectors = new Vector();
                }
                Port.addConnector(this.requesterConnectors, sig.getSenderRole());
            }
            AFPropertyMsg ccm = new AFPropertyMsg("ConnectorConfirmMsg", true);
            ccm.setFrameworkMsg(true);
            ccm.setSenderRole(this.portAddress);
            ccm.setReceiverRole(sig.getSenderRole());
            curfsm.sendMessage(ccm);
            return;
        }
        if (sig.equals("ConnectorConfirmMsg")) {
            if (this.portAddress.isInnerActor(sig.getSenderRole())) {
                if (this.inConnectors == null) {
                    this.inConnectors = new Vector();
                }
                Port.addConnector(this.inConnectors, sig.getSenderRole());
            } else {
                if (this.outConnectors == null) {
                    this.outConnectors = new Vector();
                }
                Port.addConnector(this.outConnectors, sig.getSenderRole());
            }
            if (this.createConnectorsDone(sig.getSenderRole())) {
                AFPropertyMsg pcam = new AFPropertyMsg("PortCreateAckMsg", true);
                pcam.setSenderRole(this.portAddress);
                pcam.setFrameworkMsg(true);
                pcam.setReceiverRole(this.actorsAddress);
                curfsm.sendMessage(pcam);
                if (this.sender != null) {
                    pcam = new AFPropertyMsg("PortCreateAckMsg", true);
                    pcam.setSenderRole(this.portAddress);
                    pcam.setFrameworkMsg(true);
                    pcam.setReceiverRole(this.sender);
                    curfsm.sendMessage(pcam);
                }
            }
            return;
        }
        if (sig.equals("ConnectorReleaseMsg")) {
            this.remove(sig.getSenderRole());
            if (curfsm.scheduler.isTraceOn()) {
                curfsm.trace.traceTask("Connector released: " + sig.getSenderRole());
            }
            return;
        }
        if (sig.equals("PortTimeOutMsg")) {
            if (this.createConnectors != null && !this.createConnectors.isEmpty()) {
                for (int i = 0; i < this.createConnectors.size(); ++i) {
                    AFPropertyMsg crm = new AFPropertyMsg("ConnectorRequestMsg", true);
                    crm.setSenderRole(this.portAddress);
                    crm.setReceiverRole((ActorAddress)this.createConnectors.elementAt(i));
                    crm.setFrameworkMsg(true);
                    curfsm.sendMessage(crm);
                }
            }
            return;
        }
        if (sig.equals("PortRemoveMsg")) {
            this.removePort(curfsm);
            return;
        }
        if (sig.equals("ConnectorRemoveMsg")) {
            ConnectorSpec connectorSpec = (ConnectorSpec)sig.getProperty("connectors");
            if (this.sessionEnabled) {
                AFPropertyMsg prm = new AFPropertyMsg("PathRemoveMsg", true);
                prm.setSenderRole(this.actorsAddress);
                prm.setFrameworkMsg(true);
                prm.setReceiverRole(connectorSpec.getFrom());
                curfsm.sendMessage(prm);
            }
            if (curfsm.scheduler.isTraceOn()) {
                curfsm.trace.traceTask("Connector removed: " + connectorSpec);
            }
            AFPropertyMsg crm = new AFPropertyMsg("ConnectorReleaseMsg", true);
            crm.setSenderRole(this.portAddress);
            crm.setFrameworkMsg(true);
            crm.setReceiverRole(connectorSpec.getFrom());
            this.remove(connectorSpec.getTo());
            curfsm.sendMessage(crm);
            return;
        }
        if (sig.equals("ConnectorAddMsg")) {
            ActorAddress conn;
            ConnectorSpec connectorSpec = (ConnectorSpec)sig.getProperty("connectors");
            this.sender = sig.getSenderRole();
            if (curfsm.scheduler.isTraceOn()) {
                curfsm.trace.traceTask("Connector added: " + connectorSpec);
            }
            if ((conn = (ActorAddress)connectorSpec.getTo().clone()).getActorPort() == null || conn.getActorPort().equals("")) {
                conn.setActorPort("defaultInPort");
            }
            if (!this.getConfiguredConnectors().contains(conn)) {
                AFPropertyMsg crm = new AFPropertyMsg("ConnectorRequestMsg", true);
                crm.setBoolean("requestBidirectional", connectorSpec.getIsBidirectional());
                crm.setSenderRole(this.portAddress);
                crm.setReceiverRole(conn);
                curfsm.sendMessage(crm);
                this.createConnectors = new Vector();
                this.createConnectors.addElement(conn);
            }
            return;
        }
        this.routeMessage(sig, curfsm);
    }

    public void removePort(StateMachine curfsm) {
        if (this.sessionEnabled) {
            AFPropertyMsg prm = new AFPropertyMsg("PathRemoveMsg", true);
            prm.setSenderRole(this.actorsAddress);
            prm.setFrameworkMsg(true);
            curfsm.sendMessage((ActorMsg)prm, this.getConfiguredConnectors());
        }
        AFPropertyMsg crm = new AFPropertyMsg("ConnectorReleaseMsg", true);
        crm.setSenderRole(this.portAddress);
        crm.setFrameworkMsg(true);
        curfsm.sendMessage((ActorMsg)crm, this.getAndClearAllAssociations());
    }

    private boolean createConnectorsDone(ActorAddress connectorAddress) {
        if (this.createConnectors != null) {
            this.createConnectors.removeElement(connectorAddress);
            return this.createConnectors.isEmpty();
        }
        return true;
    }

    private Vector getAndClearAllAssociations() {
        Vector all = new Vector();
        if (this.outConnectors != null) {
            this.addVector(all, this.outConnectors);
        }
        if (this.inConnectors != null) {
            this.addVector(all, this.inConnectors);
        }
        if (this.createConnectors != null) {
            this.addVector(all, this.createConnectors);
        }
        if (this.requesterConnectors != null) {
            this.addVector(all, this.requesterConnectors);
        }
        if (this.requesterConnectors != null) {
            this.requesterConnectors.removeAllElements();
        }
        if (this.createConnectors != null) {
            this.createConnectors.removeAllElements();
        }
        if (this.inConnectors != null) {
            this.inConnectors.removeAllElements();
        }
        if (this.outConnectors != null) {
            this.outConnectors.removeAllElements();
        }
        return all;
    }

    private static boolean addConnector(Vector connectors, ActorAddress aa) {
        if (!connectors.contains(aa)) {
            connectors.addElement(aa);
            return true;
        }
        return false;
    }

    private boolean remove(ActorAddress aa) {
        boolean removed = false;
        if (this.inConnectors != null && this.inConnectors.removeElement(aa)) {
            removed = true;
        }
        if (this.outConnectors != null && this.outConnectors.removeElement(aa)) {
            removed = true;
        }
        if (this.requesterConnectors != null && this.requesterConnectors.removeElement(aa)) {
            removed = true;
        }
        return removed;
    }

    private Vector getConfiguredConnectors() {
        Vector all = new Vector();
        if (this.inConnectors != null) {
            Enumeration enumer = this.inConnectors.elements();
            while (enumer.hasMoreElements()) {
                all.addElement(enumer.nextElement());
            }
        }
        if (this.outConnectors != null && !this.outConnectors.isEmpty()) {
            this.addVector(all, this.outConnectors);
        }
        return all;
    }

    private void removeSessionInstance(String sessionId) {
        this.clientSessions.remove(sessionId);
    }

    private void addVector(Vector v1, Vector v2) {
        for (int i = 0; i < v2.size(); ++i) {
            Object o = v2.elementAt(i);
            v1.addElement(o);
        }
    }

    public ActorAddress getPortAddress() {
        return this.portAddress;
    }

    public boolean isSessionEnabled() {
        return this.sessionEnabled;
    }

    public Vector getOutConnectors() {
        return this.outConnectors;
    }

    public Vector getInConnectors() {
        return this.inConnectors;
    }

    public ActorAddress getConnectorEndAdddress(Vector ends, String actorType) {
        for (int i = 0; i < ends.size(); ++i) {
            ActorAddress address = (ActorAddress)ends.elementAt(i);
            if (!address.getActorType().equals(actorType)) continue;
            return address;
        }
        return null;
    }
}

