/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.util.Enumeration;
import java.util.Vector;
import org.coos.actorframe.ActorSM;
import org.coos.actorframe.RoleSpec;
import org.coos.actorframe.SuspendedCS;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.CompositeState;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.StateMachineCS;
import org.coos.javaframe.TraceConstants;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class ActorCS
extends StateMachineCS
implements AFConstants {
    protected State waitConfirmPorts = new State("waitConfirmPorts", this);
    protected State actorSuspended = new SuspendedCS("actorSuspended", this);

    public ActorCS(String sn, CompositeState cs) {
        super(sn, cs);
    }

    public ActorCS() {
        super("ActorCS");
    }

    public ActorCS(String sn) {
        super(sn);
    }

    @Override
    public void outofInnerCompositeState(CompositeState cs, int exNo, StateMachine curfsm) {
        switch (exNo) {
            case 0: {
                this.performExit(curfsm);
                this.nextState(this.init, curfsm);
                break;
            }
            case 1: {
                this.performExit(curfsm);
                this.nextState(this.findCurrentState(curfsm.context.getHistoryStateId()), curfsm);
                break;
            }
            case 2: {
                this.performExit(curfsm);
                if (curfsm.scheduler.isTraceOn()) {
                    curfsm.trace.traceError("Suspended state not supported");
                }
                this.nextState(this.init, curfsm);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execTrans(ActorMsg sig, State st, StateMachine curfsm) {
        Object res;
        ActorSM asm = (ActorSM)curfsm;
        if (sig.equals("ReportRequestMsg")) {
            super.execTrans(sig, st, curfsm);
            return;
        }
        if (sig.equals("ReportResponsMsg")) {
            super.execTrans(sig, st, curfsm);
            return;
        }
        if (sig.equals("ActorReportTimerMsg")) {
            super.execTrans(sig, st, curfsm);
            return;
        }
        if (st == this.init) {
            if (sig.equals("RolePlayMsg")) {
                AFPropertyMsg rrm = (AFPropertyMsg)sig.getProperty("rrm");
                curfsm.context.setRootPlayMsg(sig);
                curfsm.context.setMyParentAddress(sig.getSenderRole());
                curfsm.context.setMyAddress(sig.getReceiverRole());
                if (rrm.getSenderRole() != null && rrm.getSenderRole().getActorID() != null) {
                    curfsm.context.addRequestorRole(rrm.getSenderRole().getActorID(), rrm.getSenderRole());
                }
                Vector connectors = (Vector)sig.getProperty("connectors");
                Vector ports = asm.getActorSpec().getPortNames();
                curfsm.context.setTmpPorts(ports, connectors);
                curfsm.createPorts(connectors);
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayAckMsg", true), sig.getSenderRole());
                asm.startLevel = 0;
                if (ports != null && !ports.isEmpty() && connectors != null && !connectors.isEmpty()) {
                    this.performExit(curfsm);
                    asm.startTimer(15000L, "CreationTimer");
                    asm.setNoOfTrialsLeft(2);
                    asm.context.setHistoryStateId(this.idle.stateName());
                    this.nextState(this.waitConfirmPorts, curfsm);
                    return;
                }
                if (asm.createParts(asm.actorSpec, asm.startLevel)) {
                    this.performExit(curfsm);
                    asm.startTimer(15000L, "CreationTimer");
                    asm.setNoOfTrialsLeft(2);
                    asm.context.setHistoryStateId(this.idle.stateName());
                    this.nextState(this.waitCreateAck, curfsm);
                    return;
                }
                this.finishedPartCreation(sig, asm);
                return;
            }
            if (sig.equals("RoleCreateMsg")) {
                curfsm.context.setRootPlayMsg(null);
                curfsm.setPersistent(true);
                curfsm.context.setMyParentAddress(sig.getSenderRole());
                curfsm.context.setMyAddress(sig.getReceiverRole());
                Vector connectors = (Vector)sig.getProperty("connectors");
                Vector ports = asm.getActorSpec().getPortNames();
                curfsm.context.setTmpPorts(ports, connectors);
                ActorAddress aa = sig.getSenderRole();
                if (aa.getActorDomain() == null && curfsm.getContainer() != null) {
                    aa.setActorDomain(curfsm.getScheduler().getSchedulerData().getActorDomainName());
                }
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateAckMsg", true), aa);
                curfsm.createPorts(connectors);
                asm.startLevel = 0;
                if (ports != null && !ports.isEmpty() && connectors != null && !connectors.isEmpty()) {
                    this.performExit(curfsm);
                    asm.startTimer(15000L, "CreationTimer");
                    asm.setNoOfTrialsLeft(2);
                    this.nextState(this.waitConfirmPorts, curfsm);
                    return;
                }
                if (asm.createParts(asm.actorSpec, asm.startLevel)) {
                    asm.getScheduler().upDateVisibleActors(asm);
                    this.performExit(curfsm);
                    this.nextState(this.waitCreateAck, curfsm);
                    return;
                }
                this.finishedPartCreation(sig, asm);
            } else if (sig.equals("TimerMsg") && sig.getString("timerId").equals("StartLevelTimer")) {
                this.traceTask("Start parts on level " + asm.startLevel);
                if (asm.createParts(asm.actorSpec, asm.startLevel)) {
                    asm.getScheduler().upDateVisibleActors(asm);
                    this.performExit(curfsm);
                    this.nextState(this.waitCreateAck, curfsm);
                    return;
                }
                if (asm.startLevel < 4) {
                    ++asm.startLevel;
                    AFPropertyMsg timer = new AFPropertyMsg("TimerMsg");
                    timer.setProperty("timerId", "StartLevelTimer");
                    this.sendMessage((ActorMsg)timer, this.getMyActorAddress());
                    this.sameState();
                    return;
                }
                this.finishedPartCreation(sig, asm);
                return;
            }
        } else if (st == this.waitCreateAck) {
            if (sig.equals("RoleCreateAckMsg")) {
                asm.context.removeCreationChild(sig.getSenderRole());
                Vector v = asm.context.getCreationOfChildren();
                asm.context.addPersistentChildrenRole(sig.getSenderRole());
                if (!v.isEmpty()) {
                    this.sameState(curfsm);
                    return;
                }
                if (asm.startLevel < 4) {
                    this.performExit();
                    ++asm.startLevel;
                    this.startTimer(1000L, "StartLevelTimer");
                    this.nextState(this.init);
                    return;
                }
                if (asm.context.getRootPlayMsg() != null) {
                    asm.stopTimer("CreationTimer");
                }
                this.finishedPartCreation(sig, asm);
                return;
            }
            if (sig.equals("RoleCreateNackMsg")) {
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Inner part rejected request -- creation of inner parts aborted");
                }
                if (asm.context.getParentAddress().getActorID() != null) {
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayNackMsg", true), curfsm.context.getActorAddress());
                }
                this.sendRolePlayNackMsg(curfsm);
                asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), asm.context.getActorAddress());
                this.sameState(curfsm);
                return;
            }
            super.execTrans(sig, st, curfsm);
        } else if (st == this.waitConfirmPorts) {
            if (sig.equals("PortCreateAckMsg")) {
                if (!asm.context.allPortsAcked(sig.getSenderRole().getActorPort())) {
                    this.sameState(curfsm);
                    return;
                }
                asm.stopTimer("CreationTimer");
                if (!asm.createParts(asm.actorSpec, asm.startLevel)) {
                    this.performExit();
                    AFPropertyMsg timer = new AFPropertyMsg("TimerMsg");
                    timer.setProperty("timerId", "StartLevelTimer");
                    this.sendMessage((ActorMsg)timer, this.getMyActorAddress());
                    ++asm.startLevel;
                    this.nextState(this.init);
                    return;
                }
                ActorMsg rpm = asm.context.getRootPlayMsg();
                if (rpm != null) {
                    asm.startTimer(15000L, "CreationTimer");
                    asm.setNoOfTrialsLeft(2);
                }
                this.performExit(curfsm);
                this.nextState(this.waitCreateAck, curfsm);
                return;
            }
            if (sig.equals("PortCreateNackMsg")) {
                this.performExit(curfsm);
                asm.stopTimer("CreationTimer");
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Port creation failed, creation of ports aborted");
                }
                if (asm.context.getParentAddress().getActorID() != null) {
                    asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), curfsm.context.getParentAddress());
                }
                this.sendRolePlayNackMsg(curfsm);
                asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), asm.context.getActorAddress());
                if (asm.isVisible()) {
                    asm.stopTimer(ActorSM.ROUTER_UPDATE_INTERVAL_ID);
                }
                this.nextState(this.idle, curfsm);
                return;
            }
            if (sig.equals("TimerMsg") && sig.getProperty("timerId").equals("CreationTimer")) {
                if (asm.getNoOfTrialsLeft() > 0) {
                    asm.setNoOfTrialsLeft(asm.getNoOfTrialsLeft() - 1);
                    Enumeration enumer = asm.context.getTmpPorts().elements();
                    while (true) {
                        if (!enumer.hasMoreElements()) {
                            asm.startTimer(15000L, "CreationTimer");
                            this.sameState(curfsm);
                            return;
                        }
                        asm.sendMessage((ActorMsg)new AFPropertyMsg("PortTimeOutMsg", true), (String)enumer.nextElement());
                    }
                }
                this.performExit(curfsm);
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Port creation timed out, creation of ports aborted");
                }
                if (asm.context.getParentAddress().getActorID() != null) {
                    asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), asm.context.getParentAddress());
                }
                this.sendRolePlayNackMsg(curfsm);
                asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), asm.context.getActorAddress());
                if (asm.isVisible()) {
                    asm.stopTimer(ActorSM.ROUTER_UPDATE_INTERVAL_ID);
                }
                this.nextState(this.idle, curfsm);
                return;
            }
        }
        if (!(st != this.waitCreateAck && !(st == this.waitConfirmPorts | st == this.actorSuspended) || sig.equals("RoleRemoveMsg") || sig.equals("RoleReleaseMsg") || sig.equals("RolePlayEndedMsg") || sig.equals("SetActorTraceMsg") || sig.equals("ReportRequestMsg") || sig.equals("ReportResponsMsg") || sig.equals("ActorReportTimerMsg"))) {
            this.save(sig, curfsm);
            this.sameState(curfsm);
            return;
        }
        if (st != this.init) {
            String result;
            AFPropertyMsg rsm;
            if (sig.equals("RequestStatusMsg")) {
                rsm = (AFPropertyMsg)sig;
                if (rsm.getString("requestType").equals("partspec")) {
                    result = "<?xml version=\"1.0\"?>\n<partspec>" + asm.myActorId + "@" + asm.myActorType + "</partspec>\n";
                    AFPropertyMsg resp = new AFPropertyMsg("ResponsStatusMsg", true);
                    resp.setProperty("resultType", sig.getString("requestType"));
                    resp.setProperty("result", result);
                    resp.setProperty("javaObject", asm.getPartSpecs());
                    asm.sendMessage((ActorMsg)resp, rsm.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
            } else {
                AFPropertyMsg rrm;
                if (sig.equals("PartSpecRequestMsg")) {
                    rsm = (AFPropertyMsg)sig;
                    String visible = asm.isVisible() ? "true" : "false";
                    result = "<?xml version=\"1.0\"?>\n<partspec>" + asm.myActorId + "@" + asm.myActorType + "</partspec>\n";
                    AFPropertyMsg msg = new AFPropertyMsg("PartSpecResponseMsg", true);
                    msg.setProperty("actorType", result);
                    msg.setProperty("visible", visible);
                    msg.setProperty("partSpecs", asm.getApplicationSpec());
                    asm.sendMessage((ActorMsg)msg, rsm.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RoleRequestMsg")) {
                    rrm = (AFPropertyMsg)sig;
                    String roleType = (String)rrm.getProperty("roleType");
                    RoleSpec roleSpec = asm.getActorSpec().getRoleSpec(roleType);
                    if (roleSpec != null) {
                        AFPropertyMsg msg = new AFPropertyMsg("RolePlayMsg", true);
                        msg.setProperty("rrm", rrm);
                        msg.setProperty("ports", null);
                        msg.setProperty("connectors", null);
                        String roleId = rrm.getString("roleId");
                        String id = asm.makeRoleName(roleId);
                        asm.sendMessage((ActorMsg)msg, new ActorAddress(id, roleType));
                        return;
                    }
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RoleConfirmMsg")) {
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RolePlayAckMsg")) {
                    asm.createConnectors(sig.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RolePlayNackMsg")) {
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RoleReleaseMsg")) {
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RolePlayEndedMsg")) {
                    super.execTrans(sig, st, curfsm);
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RoleDeniedMsg")) {
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RolePlayMsg")) {
                    rrm = (AFPropertyMsg)sig.getProperty("rrm");
                    ActorAddress requestor = rrm.getSenderRole();
                    asm.context.addRequestorRole(requestor.getActorID(), requestor);
                    AFPropertyMsg msg = new AFPropertyMsg("RoleConfirmMsg", true);
                    msg.setProperty("rrm", rrm);
                    asm.sendMessage((ActorMsg)msg, rrm.getSenderRole());
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayAckMsg", true), sig.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RoleResetMsg")) {
                    super.execTrans(sig, st, curfsm);
                    return;
                }
                if (sig.equals("RoleRemoveMsg")) {
                    Enumeration ports = asm.ports.keys();
                    while (true) {
                        if (!ports.hasMoreElements()) {
                            super.execTrans(sig, st, curfsm);
                            return;
                        }
                        String pname = (String)ports.nextElement();
                        asm.sendMessage((ActorMsg)new AFPropertyMsg("PortRemoveMsg", true), pname);
                    }
                }
                if (sig.equals("LookUpMsg")) {
                    res = asm.searchForActors(sig.getString("actorId"), sig.getString("actorType"));
                    AFPropertyMsg msg = new AFPropertyMsg("LookUpResultMsg", true);
                    msg.setProperty("res", res);
                    asm.sendMessage((ActorMsg)msg, sig.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RoleCreateMsg")) {
                    if (asm.scheduler.isTraceOn()) {
                        asm.trace.traceError("ActorCS: Instance already created");
                    }
                    asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), sig.getSenderRole());
                    this.sameState(asm);
                    return;
                }
                if (sig.equals("SetActorTraceMsg")) {
                    AFPropertyMsg satm = (AFPropertyMsg)sig;
                    asm.setTraceLevel(satm.getInt("traceLevel"));
                    asm.sendMessage(sig, asm.context.getChildrenRoles());
                    if (asm.scheduler.isTraceOn()) {
                        asm.trace.traceTask("Trace level: " + TraceConstants.getTraceLevel(satm.getInt("traceLevel")));
                    }
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("StartPlayingMsg")) {
                    asm.routerUpdate();
                    return;
                }
                if (sig.equals("DeleteActorMsg")) {
                    ActorAddress aa = asm.context.getChildrenRole(sig.getString("actorId"));
                    if (aa != null) {
                        asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), aa);
                        asm.sendMessage((ActorMsg)new AFPropertyMsg("ManagementRequestConfirmMsg", true).setProperty("info", aa + " deleted"), sig.getSenderRole());
                    }
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RequestStatusMsg")) {
                    rsm = (AFPropertyMsg)sig;
                    String res2 = "Children: ";
                    Vector v = asm.context.getChildrenRoles();
                    int i = 0;
                    while (true) {
                        if (i >= v.size()) {
                            AFPropertyMsg resp = new AFPropertyMsg("ResponsStatusMsg", true);
                            resp.setProperty("resultType", "text");
                            resp.setProperty("result", res2);
                            asm.sendMessage((ActorMsg)resp, rsm.getSenderRole());
                            this.sameState(curfsm);
                            return;
                        }
                        ActorAddress actorAddress = (ActorAddress)v.elementAt(i);
                        res2 = res2 + actorAddress + ", ";
                        ++i;
                    }
                }
            }
        }
        if (st != this.init && st != this.actorSuspended) {
            if (sig.equals("RoleCreateAckMsg")) {
                super.execTrans(sig, st, curfsm);
                return;
            }
            if (sig.equals("RoleCreateNackMsg")) {
                super.execTrans(sig, st, curfsm);
                return;
            }
        }
        if (st != this.init && st != this.waitConfirmPorts && st != this.actorSuspended && st != this.waitCreateAck) {
            if (sig.equals("RequestStatusMsg")) {
                res = "Children: ";
                Vector v = asm.context.getChildrenRoles();
                int i = 0;
                while (true) {
                    if (i >= v.size()) {
                        AFPropertyMsg resp = new AFPropertyMsg("ResponsStatusMsg", true);
                        resp.setProperty("resultType", "text");
                        resp.setProperty("result", res);
                        asm.sendMessage((ActorMsg)resp, sig.getSenderRole());
                        this.sameState(curfsm);
                        return;
                    }
                    ActorAddress actorAddress = (ActorAddress)v.elementAt(i);
                    res = (String)res + actorAddress + ", ";
                    ++i;
                }
            }
            if (!sig.equals("SuspendMsg")) return;
            this.performExit(curfsm);
            asm.suspendActor = sig.getSenderRole();
            asm.setHistoryState(st);
            this.nextState(this.actorSuspended, curfsm);
            return;
        } else {
            if (sig.equals("RequestStatusMsg")) {
                this.save(sig, curfsm);
            }
            if (sig.equals("DeleteActorMsg")) {
                this.save(sig, curfsm);
            }
            if (!sig.equals("AddActorMsg")) return;
            this.save(sig, curfsm);
        }
    }

    private void finishedPartCreation(ActorMsg sig, ActorSM asm) {
        asm.createConnectors();
        asm.getScheduler().upDateVisibleActors(asm);
        ActorAddress aa = sig.getSenderRole();
        if (aa.getActorDomain() == null && asm.getContainer() != null) {
            aa.setActorDomain(asm.getScheduler().getSchedulerData().getActorDomainName());
        }
        this.transStartPlaying(asm, this.idle);
    }

    @Override
    protected boolean isStateIsInSuper(State st) {
        return st == this.init || st == this.waitConfirmPorts || st == this.waitCreateAck || st == this.actorSuspended;
    }
}

