/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.coos.actorframe.application.Application;

public class ActorSpecFileMonitor {
    private Application application;
    private File applicationSpecFile;
    private long timerDelay = 1000L;
    private Timer timer;
    private long lastModyfied;

    public ActorSpecFileMonitor(Application application, File applicationSpecFile) {
        this.application = application;
        this.applicationSpecFile = applicationSpecFile;
        this.lastModyfied = applicationSpecFile.lastModified();
    }

    public void setTimerDelay(long timerDelay) {
        this.timerDelay = timerDelay;
    }

    public void startMonitoring() {
        this.application.applictionActive();
        this.startTimer();
    }

    private void waitState(int state) {
        try {
            while (this.application.getState() != state) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.timer.schedule((TimerTask)new J2SETimerTask(), this.timerDelay);
    }

    private class J2SETimerTask
    extends TimerTask {
        private J2SETimerTask() {
        }

        @Override
        public void run() {
            if (ActorSpecFileMonitor.this.application.getState() != 3) {
                ActorSpecFileMonitor.this.startTimer();
                return;
            }
            long modified = ActorSpecFileMonitor.this.applicationSpecFile.lastModified();
            if (modified > ActorSpecFileMonitor.this.lastModyfied) {
                ActorSpecFileMonitor.this.lastModyfied = modified;
                ActorSpecFileMonitor.this.application.getLogger().log(2, "File changed: " + ActorSpecFileMonitor.this.applicationSpecFile.getName());
                ActorSpecFileMonitor.this.application.suspend();
                ActorSpecFileMonitor.this.waitState(5);
                ActorSpecFileMonitor.this.application.getLogger().log(2, "Application suspended. State: " + ActorSpecFileMonitor.this.application.getState());
                ActorSpecFileMonitor.this.application.updateApplication();
                ActorSpecFileMonitor.this.waitState(9);
                ActorSpecFileMonitor.this.application.resume();
                ActorSpecFileMonitor.this.waitState(3);
            }
            ActorSpecFileMonitor.this.startTimer();
        }
    }
}

