/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.Session;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.ActorRouterRegMsg;
import org.coos.javaframe.messages.ActorRouterUnRegMsg;
import org.coos.javaframe.messages.Message;
import org.coos.javaframe.messages.RouterMsg;
import org.coos.util.serialize.AFClassLoader;

public class SchedulerImpl
implements Scheduler,
Runnable,
AFConstants,
AFClassLoader {
    private SchedulerData schedulerData;
    boolean traceOn = true;
    boolean traceError = true;
    public Hashtable mySchedulables;
    protected static Logger logger = LoggerFactory.getLogger("org.coos.javaframe");
    private TraceObject trace = new TraceObject();
    public static Object semafor = new Object();
    private boolean running = true;
    private int threads = 1;
    private String name = "default";
    private Thread thread;
    protected AFClassLoader classLoader;
    static final String title = "ActorStateMachine creation: ";

    public SchedulerImpl() {
        this.mySchedulables = new Hashtable();
    }

    public SchedulerImpl(String name) {
        this.mySchedulables = new Hashtable();
    }

    public SchedulerImpl(SchedulerData schedulerData) {
        this.schedulerData = schedulerData;
        if (schedulerData.getDefaultScheduler() == null) {
            schedulerData.setDefaultScheduler(this);
        }
        this.mySchedulables = new Hashtable();
    }

    public SchedulerImpl(String name, SchedulerData schedulerData) {
        this.schedulerData = schedulerData;
        if (schedulerData.getDefaultScheduler() == null) {
            schedulerData.setDefaultScheduler(this);
        }
        this.mySchedulables = new Hashtable();
    }

    @Override
    public SchedulerData getSchedulerData() {
        return this.schedulerData;
    }

    @Override
    public void setSchedulerData(SchedulerData schedulerData) {
        this.schedulerData = schedulerData;
        if (schedulerData.getDefaultScheduler() == null) {
            schedulerData.setDefaultScheduler(this);
        }
    }

    @Override
    public void addSchedulable(Schedulable sm, ActorAddress aa) {
        this.schedulerData.getMySystem().put(aa.keyWithOutPortAndRole(), sm);
        this.mySchedulables.put(aa.keyWithOutPortAndRole(), sm);
        sm.setScheduler(this);
        if (aa.key().indexOf(".") == -1) {
            sm.init();
        }
    }

    @Override
    public void remove(ActorAddress aa) {
        this.schedulerData.getMySystem().remove(aa.keyWithOutPortAndRole());
        this.mySchedulables.remove(aa.keyWithOutPortAndRole());
    }

    @Override
    public void addRouter(Session session) {
        this.schedulerData.setTheRouterSession(session);
        session.setScheduler(this);
    }

    @Override
    public void removeRouter() {
        this.schedulerData.setTheRouterSession(null);
    }

    @Override
    public void configure(String objectType) {
        this.schedulerData.getSchedulerConfig().put(objectType, this);
    }

    @Override
    public void start() {
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.start();
    }

    @Override
    public void run() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        Schedulable sm = null;
        ActorMsg msg = null;
        while (this.running) {
            Enumeration en = this.mySchedulables.elements();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (!(o instanceof Schedulable) || (msg = (ActorMsg)(sm = (Schedulable)o).getMailbox().removeFirst()) == null) continue;
                if (msg.getReceiverRole().isValied()) {
                    this.processMessage(msg, sm);
                    continue;
                }
                if (!this.isTraceOn()) continue;
                this.trace.traceError("execute: Error in receiver role, message dropped!" + msg.getReceiverRole());
            }
            SchedulerImpl schedulerImpl = this;
            synchronized (schedulerImpl) {
                block10: {
                    boolean emptyqueues = true;
                    Enumeration enum1 = this.mySchedulables.elements();
                    while (enum1.hasMoreElements()) {
                        Object ob = enum1.nextElement();
                        if (!(ob instanceof Schedulable) || (sm = (Schedulable)ob).getMailbox().isEmpty()) continue;
                        emptyqueues = false;
                    }
                    if (emptyqueues) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            if (!this.isTraceOn()) break block10;
                            this.trace.traceError("execute: wait() interruptexception" + e.getMessage());
                        }
                    }
                }
            }
        }
    }

    protected void processMessage(ActorMsg msg, Schedulable sm) {
        sm.processMessage(msg);
        if (sm.isReadyToBeDeleted()) {
            this.remove(sm.getMyActorAddress());
            if (this.isTraceOn()) {
                logger.log(2, "execute: ActorStateMachine deleted: " + sm);
            }
        }
    }

    private boolean isActorCreated(ActorAddress aa) {
        return this.schedulerData.getMySystem().get(aa.keyWithOutPortAndRole()) != null;
    }

    @Override
    public void postMessageToScheduler(Message rm, Schedulable curfsm) throws IOException {
        ActorMsg msg = rm instanceof RouterMsg ? ((RouterMsg)rm).deSerializeMessage(this.classLoader) : (ActorMsg)rm;
        this.schedulerData.setLastMsgFromRouter(msg);
        if (msg.equals("RoleRestartMsg") && msg.getReceiverRole() == null) {
            Enumeration en = this.getSchedulerData().getMySystem().elements();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (!(o instanceof StateMachine)) continue;
                StateMachine sm = (StateMachine)o;
                ActorAddress address = sm.getMyActorAddress();
                ActorMsg am = msg.getCopy(this.getClassLoader());
                am.setReceiverRole(address);
                this.out(am, curfsm);
            }
            return;
        }
        this.out(msg, curfsm);
    }

    @Override
    public boolean output(ActorMsg sig, Schedulable curfsm) {
        boolean ok = this.out(sig, curfsm);
        if (ok && curfsm != null && this.isTraceOn() && !sig.getMsgId().equals("timerId")) {
            curfsm.getScheduler().getTraceObject().traceOutput(sig);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean out(ActorMsg sig, Schedulable curfsm) {
        ActorAddress receiver = sig.getReceiverRole();
        if (receiver == null || !receiver.isValied()) {
            if (this.isTraceOn()) {
                this.trace.traceError("Scheduler.out: Illegal receiver address: " + receiver);
            }
            return false;
        }
        boolean created = this.isActorCreated(receiver);
        if (!created && SchedulerImpl.isCreateMsg(sig) && sig.getProperty("targetActor") == null) {
            StateMachine sm;
            Scheduler sched = (Scheduler)this.schedulerData.getSchedulerConfig().get(sig.getReceiverRole().getActorType());
            if (sched == null) {
                sched = this.schedulerData.getDefaultScheduler();
            }
            if ((sm = sched.createActor(sig, curfsm)) != null) {
                sched.notifyScheduler();
                return true;
            }
            if (this.isTraceOn()) {
                this.trace.traceError("Scheduler.out: ERROR Creation of actor Failed: " + receiver.getActorType());
            }
            return false;
        }
        Object o = this.schedulerData.getMySystem().get(sig.getReceiverRole().keyWithOutPortAndRole());
        if (o != null) {
            Schedulable sm = (Schedulable)o;
            if (sm != null) {
                sm.getMailbox().addMessage(sig);
                sm.getScheduler().notifyScheduler();
                return true;
            }
        } else {
            if (!this.schedulerData.getContainer().isRouterRunning() && this.schedulerData.getTheRouterSession() == null) {
                if (curfsm != null && this.isTraceOn()) {
                    this.trace.traceError("Scheduler.out: Router is not available, theRouterSession = null");
                }
                return false;
            }
            Scheduler scheduler = this.schedulerData.getTheRouterSession().getScheduler();
            synchronized (scheduler) {
                if (this.schedulerData.getLastMsgFromRouter() == null || this.schedulerData.getLastMsgFromRouter() != sig) {
                    if (sig.getReceiverRole().getProxyAddress() != null) {
                        ActorAddress aa = sig.getReceiverRole().getProxyAddress();
                        ActorAddress target = sig.getReceiverRole();
                        sig.setReceiverRole(aa);
                        sig.getReceiverRole().setProxyAddress(target);
                    }
                    this.schedulerData.getTheRouterSession().processMessage(sig);
                    return true;
                }
                if (this.isTraceOn()) {
                    this.trace.traceError("Scheduler.out: circulating message is skipped:" + sig);
                }
            }
        }
        return false;
    }

    protected static boolean isCreateMsg(ActorMsg msg) {
        if (msg instanceof AFPropertyMsg) {
            AFPropertyMsg am = (AFPropertyMsg)msg;
            return am.equals("RoleCreateMsg") || am.equals("RolePlayMsg");
        }
        return false;
    }

    @Override
    public StateMachine createActor(ActorMsg rsm, Schedulable curfsm) {
        StateMachine sm;
        block11: {
            String className = null;
            ActorSpec as = this.getSchedulerData().getApplicationSpec().getActorSpec(rsm.getReceiverRole().getActorType());
            if (as != null && rsm instanceof AFPropertyMsg) {
                className = as.getActorClassName();
            }
            if (className == null || className.equals("")) {
                if (this.isTraceOn()) {
                    this.trace.traceError("ActorStateMachine creation: failed,  Class name: " + className);
                }
                return null;
            }
            sm = null;
            try {
                sm = this.createClass(className);
                if (sm != null) {
                    String actorType = rsm.getReceiverRole().getActorType();
                    sm.setMyActorId(rsm.getReceiverRole().getActorID());
                    sm.setMyActorType(actorType);
                    sm.setMyActorDomain(this.schedulerData.getActorDomainName());
                    sm.setCurrentMessage(rsm);
                    sm.trace = this.trace;
                    sm.setVisible(rsm.getBoolean("visible"));
                    sm.setTraceLevel(rsm.getInt("traceLevel"));
                    if (this.isTraceOn()) {
                        logger.log(2, "ActorStateMachine creation: Success: ActorStateMachine: " + sm + " Scheduler: " + this.getName() + " Class: " + className);
                    }
                    this.addSchedulable(sm, rsm.getReceiverRole());
                    sm.mailbox.addMessage(rsm);
                }
            }
            catch (InstantiationException e) {
                if (this.isTraceOn() && this.isTraceOn()) {
                    this.trace.traceError("ActorStateMachine creation: failed, InstantiationException occurred Class: " + className);
                }
            }
            catch (IllegalAccessException e) {
                if (this.isTraceOn()) {
                    this.trace.traceError("failed, IllegalAccessException occurred Class: " + className);
                }
            }
            catch (ClassNotFoundException e) {
                if (!this.isTraceOn()) break block11;
                this.trace.traceError("ActorStateMachine creation: failed, class name: " + className + " not found");
            }
        }
        return sm;
    }

    protected StateMachine createClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class clazz = this.classLoader.loadClass(className);
        if (clazz != null) {
            return (StateMachine)clazz.newInstance();
        }
        return null;
    }

    public Vector getVisibleStateMachines() {
        Vector<ActorAddress> v = new Vector<ActorAddress>();
        Enumeration en = this.schedulerData.getMySystem().elements();
        while (en.hasMoreElements()) {
            StateMachine sm;
            Object o = en.nextElement();
            if (!(o instanceof StateMachine) || !(sm = (StateMachine)o).isVisible()) continue;
            v.addElement(sm.getMyActorAddress());
        }
        return v;
    }

    @Override
    public void upDateVisibleActors(StateMachine sm) {
        ActorRouterRegMsg arrm = new ActorRouterRegMsg(this.getVisibleStateMachines(), 0);
        arrm.setReceiverRole(this.schedulerData.getApplicationSpec().getRouterAddress());
        if (sm != null) {
            arrm.setSenderRole(new ActorAddress(sm.myActorId, sm.myActorType));
        } else {
            arrm.setSenderRole(new ActorAddress("null", "null"));
        }
        Session rs = this.schedulerData.getTheRouterSession();
        if (rs != null && this.schedulerData.getContainer().isRouterRunning()) {
            this.schedulerData.getTheRouterSession().processMessage(arrm);
        }
    }

    @Override
    public void unRegVisibleActor(ActorAddress aa) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(aa.clone());
        ActorRouterUnRegMsg arrm = new ActorRouterUnRegMsg(v, 0);
        arrm.setReceiverRole(this.schedulerData.getApplicationSpec().getRouterAddress());
        arrm.setSenderRole(aa);
        Session rs = this.schedulerData.getTheRouterSession();
        if (rs != null && this.schedulerData.getContainer().isRouterRunning()) {
            rs.processMessage(arrm);
        }
    }

    public boolean containsStateMachine(ActorAddress aa) {
        return this.schedulerData.getMySystem().containsKey(aa.key());
    }

    @Override
    public void destroyApp() {
        Enumeration en = this.schedulerData.getMySystem().elements();
        while (en.hasMoreElements()) {
            Schedulable sched = (Schedulable)en.nextElement();
            sched.destroy();
            sched.getScheduler().setStopFlag();
            sched.getScheduler().interrupt();
        }
        this.schedulerData.getMySystem().clear();
        this.schedulerData.getSchedulerConfig().clear();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public void setStopFlag() {
        this.running = false;
    }

    public void pauseApp() {
        Enumeration en = this.schedulerData.getMySystem().elements();
        while (en.hasMoreElements()) {
            Schedulable sched = (Schedulable)en.nextElement();
            sched.pause();
        }
    }

    @Override
    public void addStateMachine(StateMachine sm, String type) {
    }

    @Override
    public TraceObject getTraceObject() {
        return this.trace;
    }

    @Override
    public void clearLastMsgFromRouter() {
        this.schedulerData.setLastMsgFromRouter(null);
    }

    public int getThreads() {
        return this.threads;
    }

    @Override
    public void setThreads(int threads) {
        this.threads = threads;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setClassLoader(Container classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public AFClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    @Override
    public boolean isTraceOn() {
        return this.traceOn;
    }

    @Override
    public void setTrace(boolean on) {
        this.traceOn = on;
    }

    @Override
    public boolean isTraceError() {
        return this.traceError;
    }

    @Override
    public void setTraceError(boolean on) {
        this.traceError = on;
    }

    @Override
    public synchronized void notifyScheduler() {
        this.notify();
    }
}

