/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.IOException;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.Session;
import org.coos.actorframe.threadpool.ThreadPool;
import org.coos.actorframe.threadpool.ThreadPoolRunnable;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.Message;
import org.coos.util.serialize.AFClassLoader;

public class ThreadPooledScheduler
extends SchedulerImpl {
    private ThreadPool tp = null;

    @Override
    protected void processMessage(ActorMsg msg, Schedulable sm) {
        Worker worker = new Worker(sm, msg);
        this.tp.runRunnable(worker);
    }

    @Override
    public void setThreads(int threads) {
        super.setThreads(threads);
    }

    @Override
    public synchronized void start() {
        this.tp = new ThreadPool(this.getName(), this.getThreads());
        super.start();
    }

    private class Worker
    implements Scheduler,
    ThreadPoolRunnable {
        private Schedulable sm;
        private ActorMsg msg;
        private TraceObject trace;

        public Worker(Schedulable sm, ActorMsg msg) {
            this.sm = sm;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Schedulable schedulable = this.sm;
            synchronized (schedulable) {
                this.sm.setScheduler(this);
                this.sm.processMessage(this.msg);
                if (this.sm.isReadyToBeDeleted()) {
                    this.remove(this.sm.getMyActorAddress());
                    if (this.isTraceOn()) {
                        SchedulerImpl.logger.log(2, "execute: ActorStateMachine deleted: " + this.sm);
                    }
                }
            }
        }

        @Override
        public TraceObject getTraceObject() {
            return this.trace;
        }

        @Override
        public void addRouter(Session domainSession) {
            ThreadPooledScheduler.this.addRouter(domainSession);
        }

        @Override
        public void addSchedulable(Schedulable schedulable, ActorAddress adr) {
            ThreadPooledScheduler.this.addSchedulable(schedulable, adr);
        }

        @Override
        public void addStateMachine(StateMachine sm, String type) {
            ThreadPooledScheduler.this.addStateMachine(sm, type);
        }

        @Override
        public void clearLastMsgFromRouter() {
            ThreadPooledScheduler.this.clearLastMsgFromRouter();
        }

        @Override
        public StateMachine createActor(ActorMsg sig, Schedulable curfsm) {
            return ThreadPooledScheduler.this.createActor(sig, curfsm);
        }

        @Override
        public void destroyApp() {
            ThreadPooledScheduler.this.destroyApp();
        }

        @Override
        public AFClassLoader getClassLoader() {
            return ThreadPooledScheduler.this.getClassLoader();
        }

        @Override
        public String getName() {
            return ThreadPooledScheduler.this.getName();
        }

        @Override
        public SchedulerData getSchedulerData() {
            return ThreadPooledScheduler.this.getSchedulerData();
        }

        @Override
        public void interrupt() {
            ThreadPooledScheduler.this.interrupt();
        }

        @Override
        public boolean output(ActorMsg sig, Schedulable schedulable) {
            return ThreadPooledScheduler.this.output(sig, schedulable);
        }

        @Override
        public void postMessageToScheduler(Message message, Schedulable schedulable) throws IOException {
            ThreadPooledScheduler.this.postMessageToScheduler(message, schedulable);
        }

        @Override
        public void remove(ActorAddress actorAddress) {
            ThreadPooledScheduler.this.remove(actorAddress);
        }

        @Override
        public void removeRouter() {
            ThreadPooledScheduler.this.removeRouter();
        }

        @Override
        public void setStopFlag() {
            ThreadPooledScheduler.this.setStopFlag();
        }

        @Override
        public void unRegVisibleActor(ActorAddress address) {
            ThreadPooledScheduler.this.unRegVisibleActor(address);
        }

        @Override
        public void upDateVisibleActors(StateMachine curfsm) {
            ThreadPooledScheduler.this.upDateVisibleActors(curfsm);
        }

        @Override
        public boolean isTraceError() {
            return ThreadPooledScheduler.this.isTraceError();
        }

        @Override
        public boolean isTraceOn() {
            return ThreadPooledScheduler.this.isTraceOn();
        }

        @Override
        public void setTrace(boolean on) {
            ThreadPooledScheduler.this.setTrace(on);
        }

        @Override
        public void setTraceError(boolean on) {
            ThreadPooledScheduler.this.setTraceError(on);
        }

        @Override
        public void configure(String s) {
            ThreadPooledScheduler.this.configure(s);
        }

        @Override
        public void setClassLoader(Container container) {
            ThreadPooledScheduler.this.setClassLoader(container);
        }

        @Override
        public void setName(String id) {
            ThreadPooledScheduler.this.setName(id);
        }

        @Override
        public void setSchedulerData(SchedulerData schedulerData) {
            ThreadPooledScheduler.this.setSchedulerData(schedulerData);
        }

        @Override
        public void setThreads(int threads) {
            ThreadPooledScheduler.this.setThreads(threads);
        }

        @Override
        public void start() {
            ThreadPooledScheduler.this.start();
        }

        @Override
        public void setTraceObject(TraceObject trace) {
            this.trace = trace;
        }

        @Override
        public void notifyScheduler() {
            ThreadPooledScheduler.this.notifyScheduler();
        }
    }
}

