/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.Session;

/**
 * @author Geir Melby, Tellu AS
 */
public class J2SEContainerImpl implements Container {
	private Application application;

	/**
	 * Constructor.
	 * <p/>
	 * Sets container context to be <code>this</code> as the interface
	 * <code>Container</code> is implemented here.
	 * 
	 * @param application
	 *            is the application to start
	 */
	public J2SEContainerImpl(Application application) {
		this.application = application;
		application.setContainerContext(this);
	}

	protected J2SEContainerImpl() {
	}

	public Object getObject(String name) {
		return null;
	}

	public void setApplication(Application application) {
		this.application = application;
	}

	public Application getApplication() {
		return application;
	}

	public void stop() {
		application.deleteApplication();
	}

	public void start() {
		if ((application.getState() != Application.STATE_INITIALIZED)
				&& (application.getState() != Application.STATE_INITIALIZING)) {
			init();
		}

		application.startApplication();
	}

	public void init() {
		if (application == null) {
			throw new ApplicationException("application not set");
		}

		if ((application.getState() == Application.STATE_INITIALIZED)
				|| (application.getState() == Application.STATE_INITIALIZING)) {
			return;
		}

		application.setContainerContext(this);
		application.initApplication();
	}

	public void suspend() {
		application.suspend();
	}

	public void resume() {
		application.resume();
	}

	public boolean startRouter() {
        return false;
	}

	public boolean stopRouter() {
        return false;
	}

	public boolean isRouterRunning() {
		return false;
	}

	public boolean isRouterConnected() {
		return false;
	}

	public void displayError(Exception e) {
	}

    public byte[] getMacAddress() {
        return "**********".getBytes();
    }

    public Class loadClass(String className) {
		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}

		return null;
	}

	public Session createMessageBusAdapter(String name) {
		return null;
	}

	public void exit() {
		System.exit(0);
	}
}
