/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.javaframe.messages.RouterMsg;
import org.coos.actorframe.application.Session;

/**
 * These interfaces are used to provide the different SessionManagers with
 * reachable methods for posting messages
 * 
 * @author Geir Melby, Tellu AS
 */
public interface SessionManager {

	public static final String GATEWAY_TCP_SESSION = "GatewayTCPSession";
	public static final String TCP_SESSION = "TCPSession";
	public static final String UDP_SESSION = "udp";
	public static final String TCP = "tcp";
	public static final String BT_SESSION = "BTSession";
	public static final String J2SE_SESSION = "J2SESession";
	public static final String CDLC_SESSION = "CDLCSession";
	public static final String OSGI_SESSION = "OSGISession";
	public static final String ACTOR_ROUTER = "ActorRouter";

	public boolean processMessageFromRouter(RouterMsg rm, String sessionName);

	public Session createSession(String sessionName);

	public Session getSession(String sessionId);

	public void stopSession(String sessionName);

	public void haltSession(String sessionName);

	public void setReceivingRoutingInfo(boolean receivingRoutingInfo);

	public boolean checkYourSessions();

	public void startSessionManager();

	public void stopAllSessions();

	public void sessionError(String sessionName, String reason);
}
