/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Vector;
import org.coos.actorframe.application.Application;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.messages.ActorMsg;

public class ApplicationTester
extends Application {
    Vector receivedMessages = new Vector();

    ApplicationTester(ApplicationSpec appSpec) {
        super(appSpec);
    }

    public void messageHandler(ActorMsg sig) {
        this.receivedMessages.addElement(sig);
    }

    public boolean containsMessage(String messageId) {
        for (int i = 0; i < this.receivedMessages.size(); ++i) {
            ActorMsg msg = (ActorMsg)this.receivedMessages.elementAt(i);
            if (!msg.getMsgId().equals(messageId)) continue;
            return true;
        }
        return false;
    }

    public ActorMsg getMessage(String messageId) {
        for (int i = 0; i < this.receivedMessages.size(); ++i) {
            ActorMsg msg = (ActorMsg)this.receivedMessages.elementAt(i);
            if (!msg.getMsgId().equals(messageId)) continue;
            return msg;
        }
        return null;
    }

    public ActorMsg waitForMessage(String messageId, long timeout) {
        long timeAtStart = System.currentTimeMillis();
        ActorMsg sig = this.getMessage(messageId);
        while (sig == null || !sig.equals(messageId)) {
            long waitTime = System.currentTimeMillis() - timeAtStart;
            if (timeout > 0L && waitTime > timeout) {
                return sig;
            }
            this.sleep(10);
            sig = this.getMessage(messageId);
        }
        if (sig != null) {
            this.receivedMessages.remove(sig);
        }
        return sig;
    }

    public void clearMessages() {
        this.receivedMessages.clear();
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(ActorMsg msg, ActorAddress receiver, String sender) {
        msg.setSenderRole(sender);
        this.sendMessage(msg, receiver);
    }
}

