/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import junit.framework.TestCase;
import org.coos.actorframe.XmlBuilder;
import org.coos.javaframe.CompositeState;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.StateMachineCS;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XmlBuilderTest
extends TestCase {
    @Test
    public void testQuotedInt() {
        XmlBuilderTest.assertEquals((String)"\"1\"", (String)XmlBuilder.quoted((int)1));
    }

    @Test
    public void testQuotedInteger() {
        XmlBuilderTest.assertEquals((String)"\"1\"", (String)XmlBuilder.quoted((Object)new Integer(1)));
    }

    @Test
    public void testToXmlStringEmptyTraceObject() {
        TraceObject to = new TraceObject();
        String s = XmlBuilder.toXML((TraceObject)to);
        XmlBuilderTest.assertNotNull((Object)s);
    }

    @Test
    public void testToXmlStringTraceObjectActorMsg() {
        TraceObject to = new TraceObject();
        MyCS cs = new MyCS();
        MySM curfsm = new MySM(cs);
        AFPropertyMsg msg = new AFPropertyMsg("InpMsg");
        msg.setSenderRole("s@sender");
        msg.setReceiverRole("r@receiver");
        to.traceInit((StateMachine)curfsm);
        to.setCurrentState("currentState");
        to.setNewState("nextState");
        to.setInputSignal((ActorMsg)msg);
        to.traceError("error 1");
        to.traceError("error 2");
        to.traceWarning("warning 1");
        to.traceTask("testing");
        AFPropertyMsg omsg = new AFPropertyMsg("OutMsg");
        to.traceOutput((ActorMsg)omsg);
        String s = XmlBuilder.toXML((TraceObject)to);
        XmlBuilderTest.assertNotNull((Object)s);
        XmlBuilderTest.assertTrue((String)"Errors", (boolean)s.contains("errors"));
        XmlBuilderTest.assertTrue((String)"Warnings", (boolean)s.contains("warnings"));
        XmlBuilderTest.assertTrue((String)"Task", (boolean)s.contains("task"));
    }

    private class MyCS
    extends StateMachineCS {
        private MyCS() {
        }
    }

    private class MySM
    extends StateMachine {
        public MySM(MyCS cs) {
            super((CompositeState)cs);
            this.setMyActorId("actorId");
            this.setMyActorType("actorType");
        }
    }
}

