/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class XmlBuilder {
    private static String QUOTE = "\"";

    public static String toXML(TraceObject to) {
        int i;
        Vector v;
        boolean includeContent = to.getLogger() == null ? false : to.getLogger().isTraceEnabled();
        StringBuffer sb = new StringBuffer();
        sb.append("<transition id=");
        sb.append(XmlBuilder.quoted(to.getTransitionId()));
        sb.append(" actor=");
        sb.append(XmlBuilder.quoted(to.getCurrentStateMachine()));
        sb.append(" currentState=");
        sb.append(XmlBuilder.quoted(to.filterStateName(to.getCurrentState())));
        sb.append(" nextState=");
        sb.append(XmlBuilder.quoted(to.filterStateName(to.getNewState())));
        sb.append(" >");
        if (to.getInputSignal() != null) {
            sb.append("<input>");
            sb.append(XmlBuilder.toXML(to.getInputSignal(), includeContent));
            sb.append("</input>");
        }
        if (to.getOutputSignals() != null && to.getOutputSignals().size() > 0) {
            v = to.getOutputSignals();
            sb.append("<output>");
            for (i = 0; i < v.size(); ++i) {
                sb.append(XmlBuilder.toXML((ActorMsg)v.elementAt(i), includeContent));
            }
            sb.append("</output>");
        }
        if (to.getTraceTask() != null && to.getTraceTask().length() > 0) {
            sb.append("<task>");
            sb.append(XmlBuilder.toXmlString(to.getTraceTask()));
            sb.append("</task>");
        }
        if (to.getErrors() != null && to.getErrors().size() > 0) {
            v = to.getErrors();
            sb.append("<errors>");
            for (i = 0; i < v.size(); ++i) {
                sb.append("<error>");
                sb.append(XmlBuilder.toXmlString((String)v.elementAt(i)));
                sb.append("</error>");
            }
            sb.append("</errors>");
        }
        if (to.getWarnings() != null && to.getWarnings().size() > 0) {
            v = to.getWarnings();
            sb.append("<warnings>");
            for (i = 0; i < v.size(); ++i) {
                sb.append("<warning>");
                sb.append(XmlBuilder.toXmlString((String)v.elementAt(i)));
                sb.append("</warning>");
            }
            sb.append("</warnings>");
        }
        sb.append("</transition>");
        return sb.toString();
    }

    public static String toXML(ActorMsg msg, boolean includeContent) {
        StringBuffer sb = new StringBuffer();
        sb.append("<message");
        sb.append(" id=");
        sb.append(XmlBuilder.quoted(msg.getMsgRef()));
        sb.append(" name=");
        sb.append(XmlBuilder.quoted(msg.getSignalName()));
        sb.append(" receiver=");
        ActorAddress a = msg.getReceiverRole();
        if (a != null && a.hasActorPort()) {
            sb.append(XmlBuilder.quoted(a + ":" + a.getActorPort()));
        } else {
            sb.append(XmlBuilder.quoted(a));
        }
        sb.append(" sender=");
        a = msg.getSenderRole();
        if (a != null && a.hasActorPort()) {
            sb.append(XmlBuilder.quoted(a + ":" + a.getActorPort()));
        } else {
            sb.append(XmlBuilder.quoted(a));
        }
        sb.append(" >");
        if (msg instanceof AFPropertyMsg) {
            AFPropertyMsg afMsg = (AFPropertyMsg)msg;
            sb.append("<properties>");
            if (afMsg.getProperty() != null) {
                sb.append(XmlBuilder.toXmlString(afMsg.getProperty().toString()));
            }
            sb.append("</properties>");
        }
        sb.append("</message>");
        return sb.toString();
    }

    static String quoted(int integer) {
        return QUOTE + integer + QUOTE;
    }

    static String quoted(Object o) {
        if (o == null) {
            return QUOTE + QUOTE;
        }
        return QUOTE + XmlBuilder.toXmlString(o.toString()) + QUOTE;
    }

    static String toXmlString(String s) {
        String t = s.replace('&', '-').replace('<', '[').replace('>', ']');
        return t;
    }
}

