/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe.threadpool;

import org.coos.actorframe.threadpool.ThreadPool;
import org.coos.actorframe.threadpool.ThreadPoolRunnable;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.TraceObject;

public class ThreadPoolThread
implements Runnable {
    private ThreadPool tp;
    private boolean active = false;
    private TraceObject trace = new TraceObject();
    private static Logger logger = LoggerFactory.getLogger("org.coos.actorframe.threadpool.ThreadPoolThread");
    private String workerName;

    ThreadPoolThread(ThreadPool tp, int num) {
        this.tp = tp;
        this.workerName = tp.name + "_" + num;
        Thread t = new Thread((Runnable)this, this.workerName);
        t.start();
    }

    @Override
    public void run() {
        if (logger != null) {
            logger.log(1, "Worker " + this.workerName + " is started");
        }
        while (true) {
            try {
                ThreadPoolRunnable r;
                while ((r = this.tp.getRunnable()) != null) {
                    r.setTraceObject(this.trace);
                    this.active = true;
                    r.run();
                    this.active = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        if (logger != null) {
            logger.log(1, "Worker " + this.workerName + " is stopped");
        }
    }

    public boolean active() {
        return this.active;
    }
}

