/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Knut Eilif Husa, Tellu AS
 * 
 * 
 * 
 */
public class Standalone {
	public static void main(String[] args) {
		if (args.length > 0) {
			System.out.println("WARNING All input arguments are skipped, use configuration file standalone.xml");
		}

		Properties properties = AFProperties.getAFProperties();

		String configDir = properties.getProperty(AFProperties.CONFIG_LOCATION);
		String xmlFileName = configDir + "standalone.xml";

		URL url = null;

		try {
			url = new URL(xmlFileName);
		} catch (IOException e) {
			e.printStackTrace(); // To change body of catch statement use File |
			// Settings | File Templates.
		}

		File file = null;
		file = new File(url.getFile());

		Document doc = null;

		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setIgnoringElementContentWhitespace(true);
			dbf.setValidating(true);

			DocumentBuilder builder = dbf.newDocumentBuilder();
			doc = builder.parse(file);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("This actordescriptor is invalid according to standalone.dtd: "
					+ "\n ActorDescriptor Error:\n" + e.getMessage());

			return;
		}

		Element system = doc.getDocumentElement();

		NodeList schedulerList = system.getElementsByTagName("scheduler");

		for (int x = 0; x < schedulerList.getLength(); x++) {
			Element sched = (Element) schedulerList.item(x);

			String name = sched.getElementsByTagName("name").item(0).getNodeValue();
			String noThreads = sched.getElementsByTagName("threads").item(0).getNodeValue();

			if (noThreads == null) {
				noThreads = "1";
			}

			// todo check this : Scheduler schedInstance = new Scheduler(name,
			// Integer.parseInt(noThreads));
			// todo Geir check this creating new SchedulerData
			Scheduler schedInstance = new SchedulerImpl(new org.coos.javaframe.SchedulerData());
			NodeList smlist = sched.getElementsByTagName("statemachine");

			for (int i = 0; i < smlist.getLength(); i++) {
				Element sm = (Element) smlist.item(i);
				String classname = sm.getElementsByTagName("class").item(0).getNodeValue();
				String actortype = sm.getElementsByTagName("actortype").item(0).getNodeValue();

				try {
					schedInstance.addStateMachine((StateMachine) Class.forName(classname).newInstance(), actortype);
				} catch (InstantiationException e) {
					e.printStackTrace(); // To change body of catch statement
					// use File | Settings | File
					// Templates.
				} catch (IllegalAccessException e) {
					e.printStackTrace(); // To change body of catch statement
					// use File | Settings | File
					// Templates.
				} catch (ClassNotFoundException e) {
					e.printStackTrace(); // To change body of catch statement
					// use File | Settings | File
					// Templates.
				}
			}
		}

		String strDisplayConsole = system.getElementsByTagName("displayconsole").item(0).getNodeValue();
		startConsole(((strDisplayConsole != null) && strDisplayConsole.equalsIgnoreCase("true")));

		String strWebConsolePort = system.getElementsByTagName("webconsoleport").item(0).getNodeValue();
		startWebConsole(strWebConsolePort);

		String strRoutingEnabled = system.getElementsByTagName("routingenabled").item(0).getNodeValue();
		startRouting(((strRoutingEnabled != null) && strRoutingEnabled.equalsIgnoreCase("true")));

		String actorid = properties.getProperty("ACTOR_DOMAIN");

		AFPropertyMsg msg = new AFPropertyMsg(AFConstants.ROLE_CREATE_MSG, true);
		msg.setReceiverRole(new ActorAddress(actorid, "ActorDomain"));
		msg.setSenderRole(new ActorAddress(null, null));
		msg.getReceiverRole().setProtocol("udp");
	}

	private static void startRouting(boolean startRouting) {
		if (startRouting) {
			Runnable router = new Runnable() {
				public void run() {
					// todo this main method does not exists
					// actorRouter.main(new String[0]);
				}
			};

			new Thread(router).start();
		}
	}

	private static void startWebConsole(String strWebConsolePort) {
		/*
		 * if (strWebConsolePort != null && Integer.parseInt(strWebConsolePort)
		 * > 0) { try { // The code snipplet below shows how to create a server
		 * capable of serving webapplications // Comment if a server is not
		 * wanted Server server = new Server(); SocketListener listener = new
		 * SocketListener();
		 * listener.setPort(Integer.parseInt(strWebConsolePort));
		 * server.addListener(listener); server.addWebApplications(null,
		 * "./webapps"); ServletHttpContext context = (ServletHttpContext)
		 * server.getContext("/actordeploy"); context.addServlet("Default", "/",
		 * "org.mortbay.jetty.servlet.Default");
		 * context.setResourceBase("/tmp/actordeploy");
		 * //server.addWebApplication("/axis/*", "./webapps/axis");
		 * server.start(); } catch (Exception e) { e.printStackTrace(); //To
		 * change body of catch statement use File | Settings | File Templates.
		 * } }
		 */
	}

	private static void startConsole(boolean startConsole) {
		if (startConsole) {
			Runnable r = new Runnable() {
				public void run() {
					// MgtConsole.main(null);
				}
			};

			new Thread(r).start();
		}
	}
}
