/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe.application;

import org.coos.actorframe.application.Application;
import org.coos.actorframe.application.ApplicationException;
import org.coos.actorframe.application.Container;
import org.coos.actorframe.application.Session;

public class J2SEContainerImpl
implements Container {
    private Application application;

    public J2SEContainerImpl(Application application) {
        this.application = application;
        application.setContainerContext(this);
    }

    protected J2SEContainerImpl() {
    }

    @Override
    public Object getObject(String name) {
        return null;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public void stop() {
        this.application.deleteApplication();
    }

    @Override
    public void start() {
        if (this.application.getState() != 2 && this.application.getState() != 1) {
            this.init();
        }
        this.application.startApplication();
    }

    @Override
    public void init() {
        if (this.application == null) {
            throw new ApplicationException("application not set");
        }
        if (this.application.getState() == 2 || this.application.getState() == 1) {
            return;
        }
        this.application.setContainerContext(this);
        this.application.initApplication();
    }

    @Override
    public void suspend() {
        this.application.suspend();
    }

    @Override
    public void resume() {
        this.application.resume();
    }

    @Override
    public boolean startRouter() {
        return false;
    }

    @Override
    public boolean stopRouter() {
        return false;
    }

    @Override
    public boolean isRouterRunning() {
        return false;
    }

    @Override
    public boolean isRouterConnected() {
        return false;
    }

    @Override
    public void displayError(Exception e) {
    }

    @Override
    public byte[] getMacAddress() {
        return "**********".getBytes();
    }

    public Class loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Session createMessageBusAdapter(String name) {
        return null;
    }

    @Override
    public void exit() {
        System.exit(0);
    }
}

