/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.application.DomainSpec;
import org.coos.javaframe.ActorFrameException;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.RouterAddress;
import org.coos.javaframe.SchedulerSpec;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.HashtableHelper;
import org.coos.util.serialize.StringHelper;

public class ApplicationSpec
implements AFSerializer {
    public static byte TRACE_FORMAT_TEXT = 0;
    public static byte TRACE_FORMAT_XML = 1;
    private Hashtable actorSpecs;
    private String appName;
    private boolean traceEnabled = true;
    private byte traceFormat = TRACE_FORMAT_TEXT;
    private String description;
    private DomainSpec domainSpec;
    private RouterAddress routerAddress;
    private boolean autoStartRouter = false;
    private String routerType = "S";
    private String schedulerClass;
    private String logFile;
    private boolean error = false;
    private boolean warning = false;
    private boolean validated = false;

    public ApplicationSpec() {
        this.init();
    }

    public ApplicationSpec(String appName) {
        this.appName = appName;
        this.init();
    }

    private void init() {
        this.actorSpecs = new Hashtable();
        this.routerAddress = new RouterAddress(this.appName + "/tellu", "telluRouter");
        if (this.appName == null) {
            this.appName = "Tellu";
        }
        this.logFile = "actorlog.txt";
    }

    public String getRouterType() {
        return this.routerType;
    }

    public void setRouterType(String routerType) {
        this.routerType = routerType;
    }

    public boolean autoStartRouter() {
        return this.autoStartRouter;
    }

    public void setAutoStartRouter(boolean autoStartRouter) {
        this.autoStartRouter = autoStartRouter;
    }

    public RouterAddress getRouterAddress() {
        return this.routerAddress;
    }

    public void setRouterAddress(String name, String type) {
        this.routerAddress = new RouterAddress(name, type);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte getTraceFormat() {
        return this.traceFormat;
    }

    public void setTraceFormat(byte traceFormat) {
        this.traceFormat = traceFormat;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Hashtable getActorSpecs() {
        if (this.actorSpecs == null) {
            return new Hashtable();
        }
        return this.actorSpecs;
    }

    public ActorSpec getActorSpec(String actorType) {
        if (actorType != null) {
            return (ActorSpec)this.actorSpecs.get(actorType);
        }
        return null;
    }

    public ActorSpec getClonedActorSpec(String actorType) {
        if (actorType != null) {
            ActorSpec as = (ActorSpec)this.actorSpecs.get(actorType);
            return (ActorSpec)as.clone();
        }
        return new ActorSpec();
    }

    public void setDomainActor(String domainId, String actorType, String className) {
        DomainSpec ds = new DomainSpec(domainId, actorType);
        SchedulerSpec cs = new SchedulerSpec();
        cs.setId(domainId);
        cs.addActorType(actorType);
        ds.addSchedulerSpec(cs);
        this.addActorSpec(actorType, className);
        this.domainSpec = ds;
    }

    public DomainSpec getDomainSpec() {
        return this.domainSpec;
    }

    public void setDomainSpec(DomainSpec ps) {
        this.domainSpec = ps;
    }

    public void addActorSpec(ActorSpec actorSpec) {
        if (this.actorSpecs == null) {
            this.actorSpecs = new Hashtable();
        }
        if (actorSpec.getActorType() == null) {
            throw new ActorFrameException("ACTOR TYPE in ActorSpec is NULL. ActorSpec: " + actorSpec);
        }
        this.actorSpecs.put(actorSpec.getActorType(), actorSpec);
    }

    public void addActorSpec(String actorType, String classname) {
        this.addActorSpec(new ActorSpec(actorType, classname));
    }

    public void removeActorSpec(String actorType) {
        if (this.actorSpecs.containsKey(actorType)) {
            this.actorSpecs.remove(actorType);
            System.out.println("ApplicationSpec.removeActorSpecs: AppDesc for " + actorType + "removed");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nAPPLICATION SPEC: " + this.appName);
        sb.append("\n\nTRACE: " + this.traceEnabled);
        sb.append("\n\nDESCRITION: " + this.traceEnabled);
        if (this.description != null) {
            sb.append("\n   " + this.description);
        }
        sb.append("\n\nDOMAIN SPEC: " + this.domainSpec.toString());
        sb.append("ACTOR SPECS: ");
        Enumeration en = this.actorSpecs.elements();
        while (en.hasMoreElements()) {
            ActorSpec as = (ActorSpec)en.nextElement();
            sb.append("\n" + as.toString());
        }
        return sb.toString();
    }

    public Enumeration getPartSpecs() {
        return this.actorSpecs.elements();
    }

    public Enumeration getActorTypes() {
        return this.actorSpecs.keys();
    }

    public String getSchedulerClass() {
        return this.schedulerClass;
    }

    public void setSchedulerClass(String schedulerClass) {
        this.schedulerClass = schedulerClass;
    }

    public void removeActorSpecs(String actorDomain) {
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(HashtableHelper.persist((Hashtable)this.actorSpecs));
        dout.write(StringHelper.persist((String)this.appName));
        dout.write(StringHelper.persist((String)this.description));
        dout.write(StringHelper.persist((String)this.schedulerClass));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.actorSpecs = HashtableHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.appName = StringHelper.resurrect((DataInputStream)din);
        this.description = StringHelper.resurrect((DataInputStream)din);
        this.schedulerClass = StringHelper.resurrect((DataInputStream)din);
        return bin;
    }

    public boolean containsError() {
        if (!this.validated) {
            this.validateAppSpec();
        }
        return this.error;
    }

    public boolean containsWarning() {
        if (!this.validated) {
            this.validateAppSpec();
        }
        return this.warning;
    }

    public String validateAppSpec() {
        StringBuffer sb = new StringBuffer("\n\nVALIDATION OF APPLICATION SPEC: \n");
        StringBuffer errors = new StringBuffer();
        StringBuffer warnings = new StringBuffer();
        StringBuffer info = new StringBuffer();
        this.warning = false;
        this.error = false;
        if (this.appName == null || this.appName.length() == 0) {
            warnings.append("\tNo application name\n");
            this.warning = true;
        }
        if (this.getRouterAddress() == null) {
            warnings.append("\tNo router address\n");
            this.warning = true;
        }
        if (this.getDomainSpec() == null) {
            warnings.append("No domain spec defined. Default actor ActorDomain is used\n");
            this.warning = true;
        }
        if (this.getActorSpecs().isEmpty()) {
            warnings.append("\tNo Actors are defined.\n");
            this.warning = true;
        } else {
            Enumeration en = this.actorSpecs.elements();
            while (en.hasMoreElements()) {
                String str;
                ActorSpec as = (ActorSpec)en.nextElement();
                String actor = "\tActor: " + as.getActorType();
                info.append("Actor: " + as.getActorType());
                info.append(" " + as.getActorClassName());
                Vector parts = as.getPartDesc();
                boolean ok = true;
                for (int i = 0; i < parts.size(); ++i) {
                    PartSpec ps = (PartSpec)parts.elementAt(i);
                    String rt = ps.getRoleType();
                    ActorSpec ras = this.getActorSpec(rt);
                    str = actor + "\tPart: " + ps.getRoleType();
                    if (ras == null) {
                        errors.append(str + ":\tIllegal part name\n");
                        ok = false;
                    }
                    if (ps.getHigh() < ps.getLow() || ps.getHigh() == 0) {
                        errors.append(str + ":\tIllegal instance range [" + ps.getLow() + "," + ps.getHigh() + "]\n");
                        ok = false;
                    }
                    this.error = this.error || !ok;
                }
                Vector connectors = as.getConnectorDesc();
                ok = true;
                for (int i = 0; i < connectors.size(); ++i) {
                    PartSpec partSpec;
                    ActorSpec spec;
                    ConnectorSpec cs = (ConnectorSpec)connectors.elementAt(i);
                    String who = "\tfrom";
                    str = actor + "\tConnector name: " + cs.getName() + who;
                    String portName = cs.getFrom().getActorPort();
                    String type = cs.getFrom().getActorType();
                    String instance = cs.getFrom().getActorID();
                    if (type == null || this.getActorSpec(type) == null) {
                        errors.append(str + ":\tIllegal actor type: " + type + "\n");
                        ok = false;
                    } else {
                        if (!(portName == null || (spec = this.getActorSpec(type)) != null && spec.containsPortName(portName))) {
                            errors.append(str + ":\tIllegal port name: " + portName + " for type: " + type + "\n");
                            ok = false;
                        }
                        if (!(instance == null || instance.length() <= 0 || (partSpec = as.getPartSpec(type)) != null && partSpec.containsInstance(instance))) {
                            errors.append(str + ":\tIllegal instance name: " + instance + " for type: " + type + "\n");
                            ok = false;
                        }
                    }
                    who = "\tTo";
                    portName = cs.getTo().getActorPort();
                    type = cs.getTo().getActorType();
                    instance = cs.getTo().getActorID();
                    if (type == null || this.getActorSpec(type) == null) {
                        errors.append(str + ":\tIllegal actor type: " + type + "\n");
                        ok = false;
                    } else {
                        if (!(portName == null || (spec = this.getActorSpec(type)) != null && spec.containsPortName(portName))) {
                            errors.append(str + ":\tIllegal port name: " + portName + " for type: " + type + "\n");
                            ok = false;
                        }
                        if (!(instance == null || instance.length() <= 0 || (partSpec = as.getPartSpec(type)) != null && partSpec.containsInstance(instance))) {
                            errors.append(str + ":\tIllegal instance name: " + instance + " for type: " + type + "\n");
                            ok = false;
                        }
                    }
                    this.error = this.error || !ok;
                }
                info.append(ok ? " OK" : " ERROR");
                info.append("\n");
            }
        }
        if (this.error) {
            sb.append("\nERRORS:\n" + errors);
        }
        if (this.warning) {
            sb.append("\nWARNINGS:\n" + warnings);
        }
        sb.append("INFO:\n" + info);
        this.validated = true;
        return sb.toString();
    }
}

