/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.coos.actorframe.ActorSpecException;
import org.coos.actorframe.ActorSpecParser;
import org.coos.javaframe.ApplicationSpec;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ActorSpecParserTest
extends TestCase {
    ApplicationSpec appSpec;

    @Before
    public void setUp() throws Exception {
        this.appSpec = new ApplicationSpec();
    }

    @After
    public void tearDown() throws Exception {
        this.appSpec = null;
    }

    @Test(expected=ActorSpecException.class)
    public void testCreateApplicationUnknownResourceName() {
        ActorSpecParser.createApplicationSpec((String)"unknownResourceName", (String)"appName");
    }

    @Test
    public void testCreateApplicationTestApp1() {
        this.appSpec = ActorSpecParser.createApplicationSpec((String)"/org/coos/javaframe/appSpec1.xml", (String)"appName");
        ActorSpecParserTest.assertEquals((String)"Application name", (String)"appName", (String)this.appSpec.getAppName());
    }

    @Test
    public void testCreateApplicationTestApp2() {
        this.appSpec = ActorSpecParser.createApplicationSpec((String)"/org/coos/javaframe/appSpec2.xml", (String)"appName");
        ActorSpecParserTest.assertEquals((String)"Application name", (String)"TestApp2", (String)this.appSpec.getAppName());
        ActorSpecParserTest.assertEquals((String)"Trace enabled", (boolean)true, (boolean)this.appSpec.isTraceEnabled());
    }

    @Test
    public void testParseXmlTraceOldFormatIgnored() throws UnsupportedEncodingException {
        ByteArrayInputStream is = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><application name=\"TestApp2\" trace=\"false\"></application>".getBytes("UTF8"));
        ActorSpecParserTest.assertEquals((String)"Trace default", (boolean)true, (boolean)this.appSpec.isTraceEnabled());
        ActorSpecParser.parseXml((InputStream)is, (ApplicationSpec)this.appSpec);
        ActorSpecParserTest.assertEquals((String)"Trace enabled", (boolean)true, (boolean)this.appSpec.isTraceEnabled());
    }

    @Test
    public void testParseXmlTraceDefaults() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<application name=\"TestApp2\" />");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
        ActorSpecParser.parseXml((InputStream)is, (ApplicationSpec)this.appSpec);
        ActorSpecParserTest.assertTrue((String)"Trace enabled", (boolean)this.appSpec.isTraceEnabled());
        ActorSpecParserTest.assertEquals((String)"Trace format", (byte)ApplicationSpec.TRACE_FORMAT_TEXT, (byte)this.appSpec.getTraceFormat());
    }

    @Test
    public void testParseXmlTraceFalseFormatXml() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<application name=\"TestApp2\">");
        sb.append("<trace trace=\"false\" format=\"xml\" />");
        sb.append("</application>");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
        ActorSpecParser.parseXml((InputStream)is, (ApplicationSpec)this.appSpec);
        ActorSpecParserTest.assertFalse((String)"Trace enabled", (boolean)this.appSpec.isTraceEnabled());
        ActorSpecParserTest.assertEquals((String)"Trace format", (byte)ApplicationSpec.TRACE_FORMAT_XML, (byte)this.appSpec.getTraceFormat());
    }

    @Test
    public void testParseXmlTraceTrueFormatText() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<application name=\"TestApp2\" >");
        sb.append("<trace trace=\"true\" format=\"text\" />");
        sb.append("</application>");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
        ActorSpecParser.parseXml((InputStream)is, (ApplicationSpec)this.appSpec);
        ActorSpecParserTest.assertTrue((String)"Trace enabled", (boolean)this.appSpec.isTraceEnabled());
        ActorSpecParserTest.assertEquals((String)"Trace format", (byte)ApplicationSpec.TRACE_FORMAT_TEXT, (byte)this.appSpec.getTraceFormat());
    }
}

