/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe.application;

import java.util.Enumeration;
import java.util.Hashtable;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;

public class AFServiceFactory {
    private static Hashtable afServices = new Hashtable();
    static Logger logger = LoggerFactory.getLogger("org.coos.actorframe");

    public static void addAFService(String serviceName, String serviceClass) {
        if (serviceName != null & serviceClass != null) {
            afServices.put(serviceName, serviceClass);
            logger.log(2, "AFServiceFactory.addAFservice: Property: " + serviceName + " Object: " + serviceClass);
        }
    }

    public static void addAFService(String serviceName, Object serviceObject) {
        if (serviceName != null & serviceObject != null) {
            afServices.put(serviceName, serviceObject);
            logger.log(2, "AFServiceFactory.addAFservice: Property: " + serviceName + " Object: " + serviceObject);
        }
    }

    public static boolean removeAFService(String serviceName) {
        if (afServices.containsKey(serviceName)) {
            afServices.remove(serviceName);
            return true;
        }
        return false;
    }

    public static Object getAFServiceInstance(String serviceName) {
        if (serviceName != null) {
            Object o = afServices.get(serviceName);
            if (o instanceof String) {
                try {
                    Class<?> c = Class.forName((String)o);
                    return c.newInstance();
                }
                catch (Exception e) {
                    logger.log(4, "Failed to instantiate " + serviceName + ". Returning null.");
                    return null;
                }
            }
            return o;
        }
        return null;
    }

    public static boolean isPropertySet(String serviceName) {
        if (serviceName != null) {
            return afServices.get(serviceName) != null;
        }
        return false;
    }

    public static String getAFServiceProperty(String serviceName) {
        if (serviceName != null) {
            return (String)afServices.get(serviceName);
        }
        return null;
    }

    public static Enumeration getAFServiceNames() {
        return afServices.keys();
    }

    public static String printContent() {
        Enumeration en = afServices.keys();
        String res = "AFservices contains: \n";
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            res = res + "Service name: " + s;
            res = res + "Service class: " + afServices.get(s) + "\n";
        }
        return res;
    }
}

