/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;

public class ActorAddress
implements AFSerializer {
    public static final String ROLE_TYPE = "roleType";
    public static final String ROLE_ID = "roleId";
    private String actorDomain;
    private String actorID;
    private String actorType;
    private String actorPort;
    private String actorIP;
    private String actorIPPort;
    private String proxyAddress;
    private byte[] replyStack;
    private String protocol;

    public ActorAddress() {
        this.actorDomain = null;
        this.actorID = null;
        this.actorType = null;
        this.actorPort = null;
        this.actorIP = "localhost";
        this.actorIPPort = null;
        this.protocol = "tcp";
    }

    public ActorAddress(String actorAddress) {
        this.actorDomain = this.getActorDomain(actorAddress);
        int indexType = actorAddress.indexOf(64);
        int indexPort = actorAddress.indexOf(58);
        if (indexType == -1) {
            indexType = 0;
        }
        if (indexPort == -1) {
            indexPort = indexType;
        }
        this.actorID = actorAddress.substring(0, indexPort);
        if (this.actorID.equals("")) {
            this.actorID = null;
        }
        this.actorType = actorAddress.indexOf(64) == -1 ? actorAddress.substring(indexType) : actorAddress.substring(indexType + 1);
        if (this.actorType.equals("")) {
            this.actorType = null;
        }
        if (indexPort < indexType) {
            this.actorPort = actorAddress.substring(indexPort + 1, indexType);
        }
        if (this.actorPort != null && this.actorPort.equals("")) {
            this.actorPort = null;
        }
        this.actorIP = "localhost";
        this.actorIPPort = null;
        this.protocol = "udp";
    }

    private String getActorDomain(String actorId) {
        int i;
        if (!actorId.startsWith("/") && (i = actorId.indexOf("/", 1)) != -1) {
            return actorId.substring(0, i).replace('.', '|');
        }
        return null;
    }

    public ActorAddress(String actorID, String actorType) {
        this.actorDomain = this.getActorDomain(actorID);
        this.actorID = actorID;
        this.actorType = actorType;
        this.actorPort = null;
        this.actorIP = "localhost";
        this.actorIPPort = null;
        this.protocol = "tcp";
    }

    public ActorAddress(String actorID, String actorType, String actorPort) {
        this(actorID, actorType);
        this.actorPort = actorPort;
    }

    public ActorAddress(String actorID, String actorType, String actorIpAddr, String actorIPPort, String protocol) {
        this(actorID, actorType);
        this.actorIPPort = actorIPPort;
        this.protocol = protocol;
        this.actorIP = actorIpAddr == null ? "localhost" : actorIpAddr;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ActorAddress(String actorID, String actorType, String actorPort, String actorIpAddr, String actorIPPort, String protocol) {
        this(actorID, actorType, actorIpAddr, actorIPPort, protocol);
        this.actorPort = actorPort;
    }

    public ActorAddress(DataInputStream din) throws IOException {
        this.readInput(din, null);
    }

    public void setReplyStack(Vector replyStack) throws IOException {
        this.replyStack = VectorHelper.persist((Vector)replyStack);
    }

    public Vector getReplyStack() {
        if (!this.hasReplyStack()) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.replyStack);
        DataInputStream din = new DataInputStream(bin);
        try {
            return VectorHelper.resurrect((DataInputStream)din, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean hasReplyStack() {
        return this.replyStack != null && this.replyStack.length != 0;
    }

    public String getActorDomain() {
        return this.actorDomain;
    }

    public void setActorDomain(String actorDomain) {
        this.actorDomain = actorDomain != null ? actorDomain.replace('.', '|') : null;
    }

    public String getActorID() {
        return this.actorID;
    }

    public void setActorID(String actorID) {
        this.actorID = actorID;
        this.actorDomain = this.getActorDomain(actorID);
    }

    public String getActorType() {
        return this.actorType;
    }

    public void setActorType(String actorType) {
        this.actorType = actorType;
    }

    public String getActorPort() {
        return this.actorPort;
    }

    public void setActorPort(String actorPort) {
        this.actorPort = actorPort;
    }

    public boolean hasActorPort() {
        return this.actorPort != null;
    }

    public String getActorIP() {
        return this.actorIP;
    }

    public void setActorIP(String actorIP) {
        this.actorIP = actorIP;
    }

    public String getActorIPPort() {
        return this.actorIPPort;
    }

    public void setActorIPPort(String actorIPPort) {
        this.actorIPPort = actorIPPort;
    }

    public ActorAddress getProxyAddress() {
        if (this.proxyAddress != null) {
            return new ActorAddress(this.proxyAddress);
        }
        return null;
    }

    public void setProxyAddress(ActorAddress proxyAddress) {
        this.proxyAddress = proxyAddress != null ? proxyAddress.key() : null;
    }

    public boolean isValied() {
        return this.getActorID() != null && this.getActorType() != null && !this.getActorType().equals("");
    }

    public String key() {
        if (this.actorPort == null) {
            return this.actorID + "@" + this.actorType;
        }
        return this.actorID + ":" + this.actorPort + "@" + this.actorType;
    }

    public String keyWithOutPortAndRole() {
        int index = this.actorID.indexOf(".");
        String id = this.actorID;
        if (index != -1) {
            id = this.actorID.substring(0, index);
        }
        return id + "@" + this.actorType;
    }

    public String keyWithOutPort() {
        return this.actorID + "@" + this.actorType;
    }

    public String printActorDomain() {
        return this.toString();
    }

    public String printIpAddress() {
        String s = "";
        if (this.actorIP != null) {
            s = this.actorIP + ":";
        }
        if (this.actorIPPort != null) {
            s = s + this.actorIPPort;
        }
        return s;
    }

    public boolean isIpAddressSet() {
        return this.actorIP != null && !this.actorIP.equals("localhost");
    }

    public boolean isInnerActor(ActorAddress aa) {
        int contextStop = -1;
        contextStop = this.actorPort != null ? this.key().lastIndexOf(58) : this.key().lastIndexOf(64);
        return aa.key().startsWith(this.key().substring(0, contextStop));
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(StringHelper.persist((String)this.actorDomain));
        dout.write(StringHelper.persist((String)this.actorID));
        dout.write(StringHelper.persist((String)this.actorType));
        dout.write(StringHelper.persist((String)this.actorIP));
        dout.write(StringHelper.persist((String)this.actorIPPort));
        dout.write(StringHelper.persist((String)this.actorPort));
        dout.write(StringHelper.persist((String)this.proxyAddress));
        dout.write(StringHelper.persist((String)this.protocol));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.readInput(din, cl);
        return bin;
    }

    private void readInput(DataInputStream din, AFClassLoader cl) throws IOException {
        this.actorDomain = StringHelper.resurrect((DataInputStream)din);
        this.actorID = StringHelper.resurrect((DataInputStream)din);
        this.actorType = StringHelper.resurrect((DataInputStream)din);
        this.actorIP = StringHelper.resurrect((DataInputStream)din);
        this.actorIPPort = StringHelper.resurrect((DataInputStream)din);
        this.actorPort = StringHelper.resurrect((DataInputStream)din);
        this.proxyAddress = StringHelper.resurrect((DataInputStream)din);
        this.protocol = StringHelper.resurrect((DataInputStream)din);
    }

    public boolean equalsIgnoreContext(Object obj) {
        if (obj instanceof ActorAddress) {
            ActorAddress aa = (ActorAddress)obj;
            if (aa.getActorID() == null || aa.getActorType() == null) {
                return false;
            }
            if (this.actorID.endsWith(aa.getActorID()) && aa.getActorType().equals(this.actorType) && aa.getActorIP().equals(this.actorIP)) {
                return this.hasActorPort() && aa.hasActorPort() && this.actorPort.equals(aa.actorPort) || !this.hasActorPort() && !aa.hasActorPort();
            }
            return false;
        }
        if (obj instanceof String) {
            return this.actorID.endsWith((String)obj);
        }
        return super.equals(obj);
    }

    public String toString() {
        String s = "";
        if (this.isIpAddressSet()) {
            s = this.printIpAddress() + "/";
        }
        return s + this.key();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActorAddress) {
            boolean type;
            ActorAddress aa = (ActorAddress)obj;
            boolean id = aa.actorID != null && this.actorID != null && aa.actorID.equals(this.actorID);
            boolean bl = type = aa.actorType != null && this.actorType != null && aa.actorType.equals(this.actorType);
            return id && type && (this.hasActorPort() && aa.hasActorPort() && this.actorPort.equals(aa.actorPort) || !this.hasActorPort() && !aa.hasActorPort() || this.actorPort.equals("defaultInPort") && !aa.hasActorPort() || !this.hasActorPort() && aa.equals("defaultInPort")) && (aa.actorDomain == null || this.actorDomain == null || aa.actorDomain.equals(this.actorDomain));
        }
        if (obj instanceof String) {
            return ((String)obj).equals(this.actorID);
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            ActorAddress clonedAA = new ActorAddress();
            clonedAA.deSerialize(this.serialize(), null);
            return clonedAA;
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        if (this.actorID == null || this.actorType == null) {
            return 0;
        }
        int hash = this.actorID.hashCode() + 31 * this.actorType.hashCode();
        if (this.actorDomain != null) {
            hash += 961 * this.actorDomain.hashCode();
        }
        return hash;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getActorIdWithoutDomain() {
        if (!this.actorID.startsWith("/")) {
            int i;
            int index = this.actorID.indexOf(".");
            String id = this.actorID;
            if (index != -1) {
                id = this.actorID.substring(0, index);
            }
            if ((i = id.indexOf("/", 1)) != -1) {
                return id.substring(i);
            }
        }
        return this.actorID;
    }

    public String getPath() {
        StringBuffer s = new StringBuffer();
        if (this.actorDomain != null) {
            s.append(this.actorDomain);
        }
        if (this.actorID.length() > 0 && this.actorID.charAt(0) == '/') {
            if (this.actorID != null) {
                s.append(this.actorID);
            }
            if (this.actorPort != null) {
                s.append(":" + this.actorPort);
            }
            if (this.actorType != null) {
                s.append("@" + this.actorType);
            }
        }
        return s.toString();
    }

    public static void main(String[] args) {
        ActorAddress aa = new ActorAddress("a/b@B");
        System.out.println("ActorAddress: " + aa.getActorIdWithoutDomain());
        aa = new ActorAddress("/b@B");
        System.out.println("ActorAddress: " + aa.getActorIdWithoutDomain());
        aa = new ActorAddress("a/b.role@B");
        System.out.println("ActorAddress: " + aa.getActorIdWithoutDomain());
    }
}

