/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.ActorReport;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.messages.ActorMsg;

public class ActorContext {
    private ActorAddress myAddress;
    private ActorAddress myParentAddress;
    private String historyStateId = "";
    private Hashtable requestors = new Hashtable();
    private Hashtable requested = new Hashtable();
    private Vector childrenRoles = new Vector();
    private Vector persistentChildren = new Vector();
    private Hashtable actorProperties;
    public ActorReport actorReport;
    ActorAddress senderOfReportRequest;
    private Vector creationOfChildren = new Vector();
    private ActorMsg rootPlayMsg = null;
    Vector tmpPorts = new Vector();

    public ActorContext(ActorAddress myAddress, ActorAddress myParentAddress) {
        this.myAddress = myAddress;
        this.myParentAddress = myParentAddress;
    }

    public ActorContext(ActorAddress myAddress) {
        this.myAddress = myAddress;
    }

    public void addRequestorRole(String key, ActorAddress aa) {
        String tmp = key;
        if (tmp == null) {
            tmp = aa.toString();
        }
        if (this.requestors.containsKey(tmp)) {
            tmp = tmp + aa;
        }
        if (!this.requestors.containsKey(tmp)) {
            this.requestors.put(tmp, aa);
        }
    }

    public Hashtable getActorProperties() {
        return this.actorProperties;
    }

    public void setActorProperties(Hashtable actorProperties) {
        this.actorProperties = actorProperties;
    }

    public Vector getRequestorRoles() {
        return this.getValues(this.requestors);
    }

    public boolean requestorRolesContains(ActorAddress aa) {
        return this.requestors.contains(aa);
    }

    public boolean requestorRolesIsEmpty() {
        return this.requestors.isEmpty();
    }

    public ActorAddress getRequestorRole(String actorID) {
        return ActorContext.getActorIDIgnoreCase(this.requestors.elements(), actorID);
    }

    public Vector getRequestorRoles(String actorType) {
        return ActorContext.getActorTypesIgnoreCase(this.requestors.elements(), actorType);
    }

    public void addRequestedRole(String key, ActorAddress aa) {
        String tmp = key;
        if (tmp == null) {
            tmp = aa.toString();
        }
        if (this.requested.containsKey(tmp)) {
            tmp = tmp + aa;
        }
        if (!this.requested.containsKey(tmp)) {
            this.requested.put(tmp, aa);
        }
    }

    public Vector getRequestedRoles() {
        return this.getValues(this.requested);
    }

    public Vector getRequestedRoles(String actorType) {
        return ActorContext.getActorTypesIgnoreCase(this.requested.elements(), actorType);
    }

    public boolean requestedRolesContains(ActorAddress aa) {
        return this.requested.contains(aa);
    }

    public boolean requestedRolesIsEmpty() {
        return this.requested.isEmpty();
    }

    public ActorAddress getRequestedRole(String actorID) {
        return ActorContext.getActorIDIgnoreCase(this.requested.elements(), actorID);
    }

    public ActorAddress getConnection(Object key) {
        if (this.requested.get(key) != null) {
            return (ActorAddress)this.requested.get(key);
        }
        if (this.requestors.get(key) != null) {
            return (ActorAddress)this.requestors.get(key);
        }
        return null;
    }

    public Hashtable getConnections() {
        return this.requested;
    }

    public void addChildrenRole(ActorAddress aa) {
        if (!this.childrenRoles.contains(aa)) {
            this.childrenRoles.addElement(aa);
        }
    }

    public Vector getChildrenRoles() {
        Vector tmp = new Vector();
        this.addVector(tmp, this.childrenRoles);
        this.addVector(tmp, this.persistentChildren);
        return tmp;
    }

    public Vector getNonPersistentChildrenRoles() {
        Vector tmp = new Vector();
        this.addVector(tmp, this.childrenRoles);
        return tmp;
    }

    public Vector getChildrenRoles(String actorType) {
        Vector res = ActorContext.getActorTypesIgnoreCase(this.childrenRoles.elements(), actorType);
        this.addVector(res, ActorContext.getActorTypesIgnoreCase(this.persistentChildren.elements(), actorType));
        return res;
    }

    public void addPersistentChildrenRole(ActorAddress aa) {
        if (!this.persistentChildren.contains(aa)) {
            this.persistentChildren.addElement(aa);
        }
    }

    public boolean isPersistentChildrenRole(ActorAddress aa) {
        return this.persistentChildren.contains(aa);
    }

    public boolean childrenRolesContains(ActorAddress aa) {
        return this.childrenRoles.contains(aa) || this.persistentChildren.contains(aa);
    }

    public boolean childrenRolesIsEmpty() {
        return this.childrenRoles.isEmpty() && this.persistentChildren.isEmpty();
    }

    public ActorAddress getChildrenRole(String actorID) {
        ActorAddress res = ActorContext.getActorIDIgnoreCase(this.childrenRoles.elements(), actorID);
        if (res != null) {
            return res;
        }
        return ActorContext.getActorIDIgnoreCase(this.persistentChildren.elements(), actorID);
    }

    public ActorAddress getChildrenRoleIgnoreContext(ActorAddress childRole) {
        ActorAddress aa;
        Enumeration e = this.childrenRoles.elements();
        while (e.hasMoreElements()) {
            aa = (ActorAddress)e.nextElement();
            if (!aa.equalsIgnoreContext(childRole)) continue;
            return aa;
        }
        e = this.persistentChildren.elements();
        while (e.hasMoreElements()) {
            aa = (ActorAddress)e.nextElement();
            if (!aa.equalsIgnoreContext(childRole)) continue;
            return aa;
        }
        return null;
    }

    public boolean contains(ActorAddress aa) {
        return this.requestors.contains(aa) || this.requested.contains(aa) || this.childrenRoles.contains(aa) || this.persistentChildren.contains(aa);
    }

    public int size() {
        return this.requestors.size() + this.requested.size() + this.childrenRoles.size() + this.persistentChildren.size();
    }

    public boolean isEmpty() {
        return this.requestors.isEmpty() && this.requested.isEmpty() && this.childrenRoles.isEmpty() && this.persistentChildren.isEmpty();
    }

    public boolean remove(ActorAddress aa) {
        return this.remove(this.requestors, aa) || this.remove(this.requested, aa) || this.childrenRoles.removeElement(aa) || this.persistentChildren.removeElement(aa);
    }

    public boolean removeAll(Vector vaa) {
        boolean removed = false;
        for (int i = 0; i < vaa.size(); ++i) {
            if (!this.remove((ActorAddress)vaa.elementAt(i))) continue;
            removed = true;
        }
        return removed;
    }

    public boolean remove(String actorID) {
        ActorAddress aa = ActorContext.getActorIDIgnoreCase(this.requestors.elements(), actorID);
        if (aa != null) {
            return this.getValues(this.requestors).removeElement(aa);
        }
        aa = ActorContext.getActorIDIgnoreCase(this.requested.elements(), actorID);
        if (aa != null) {
            return this.getValues(this.requested).removeElement(aa);
        }
        aa = ActorContext.getActorIDIgnoreCase(this.childrenRoles.elements(), actorID);
        if (aa != null) {
            return this.childrenRoles.removeElement(aa);
        }
        aa = ActorContext.getActorIDIgnoreCase(this.persistentChildren.elements(), actorID);
        if (aa != null) {
            return this.persistentChildren.removeElement(aa);
        }
        return false;
    }

    public ActorAddress get(String actorID) {
        ActorAddress aa = ActorContext.getActorIDIgnoreCase(this.requestors.elements(), actorID);
        if (aa != null) {
            return aa;
        }
        aa = ActorContext.getActorIDIgnoreCase(this.requested.elements(), actorID);
        if (aa != null) {
            return aa;
        }
        aa = ActorContext.getActorIDIgnoreCase(this.childrenRoles.elements(), actorID);
        if (aa != null) {
            return aa;
        }
        aa = ActorContext.getActorIDIgnoreCase(this.persistentChildren.elements(), actorID);
        if (aa != null) {
            return aa;
        }
        return null;
    }

    public ActorAddress getActorAddress() {
        return this.myAddress;
    }

    public ActorAddress getParentAddress() {
        return this.myParentAddress;
    }

    public void setMyParentAddress(ActorAddress myParentAddress) {
        this.myParentAddress = myParentAddress;
    }

    public void setMyAddress(ActorAddress myAddress) {
        this.myAddress = myAddress;
    }

    public boolean allPortsAcked(String portName) {
        if (this.tmpPorts == null || this.tmpPorts.isEmpty()) {
            return true;
        }
        this.tmpPorts.removeElement(portName);
        return this.tmpPorts.isEmpty();
    }

    public int sizeOfChildrenRoles(String aa) {
        ActorAddress actorAddress;
        int i;
        int count = 0;
        for (i = 0; i < this.childrenRoles.size(); ++i) {
            actorAddress = (ActorAddress)this.childrenRoles.elementAt(i);
            if (!actorAddress.getActorType().equals(aa)) continue;
            ++count;
        }
        for (i = 0; i < this.persistentChildren.size(); ++i) {
            actorAddress = (ActorAddress)this.persistentChildren.elementAt(i);
            if (!actorAddress.getActorType().equals(aa)) continue;
            ++count;
        }
        return count;
    }

    public Vector getCreationOfChildren() {
        return this.creationOfChildren;
    }

    public void removeCreationChild(ActorAddress aa) {
        for (int i = 0; i < this.creationOfChildren.size(); ++i) {
            ActorAddress refAA = (ActorAddress)this.creationOfChildren.elementAt(i);
            if (!refAA.equals(aa)) continue;
            this.creationOfChildren.removeElement(refAA);
            return;
        }
    }

    public ActorMsg getRootPlayMsg() {
        return this.rootPlayMsg;
    }

    public void setRootPlayMsg(ActorMsg rootPlayMsg) {
        this.rootPlayMsg = rootPlayMsg;
    }

    public Vector getTmpPorts() {
        return this.tmpPorts == null ? new Vector() : this.tmpPorts;
    }

    public void setTmpPorts(Vector tmpPorts, Vector connectors) {
        this.tmpPorts = tmpPorts;
    }

    public String getHistoryStateId() {
        return this.historyStateId;
    }

    public void setHistoryStateId(String historyStateId) {
        this.historyStateId = historyStateId;
    }

    private static Vector getActorTypesIgnoreCase(Enumeration searchIn, String actorType) {
        Vector<ActorAddress> res = new Vector<ActorAddress>();
        while (searchIn.hasMoreElements()) {
            ActorAddress aa = (ActorAddress)searchIn.nextElement();
            if (!aa.getActorType().equals(actorType)) continue;
            res.addElement(aa);
        }
        return res;
    }

    private static ActorAddress getActorIDIgnoreCase(Enumeration searchIn, String actorID) {
        while (searchIn.hasMoreElements()) {
            ActorAddress aa = (ActorAddress)searchIn.nextElement();
            if (!aa.getActorID().equals(actorID)) continue;
            return aa;
        }
        return null;
    }

    public boolean equals(Object obj) {
        ActorContext ac = (ActorContext)obj;
        if (!ac.myAddress.equals(this.myAddress)) {
            return false;
        }
        if (!ac.myParentAddress.equals(this.myParentAddress)) {
            return false;
        }
        if (!ac.requestors.equals(this.requestors)) {
            return false;
        }
        if (!ac.requested.equals(this.requested)) {
            return false;
        }
        if (!ac.childrenRoles.equals(this.childrenRoles)) {
            return false;
        }
        if (!ac.persistentChildren.equals(this.persistentChildren)) {
            return false;
        }
        if (!ac.creationOfChildren.equals(this.creationOfChildren)) {
            return false;
        }
        if (!ac.historyStateId.equals(this.historyStateId)) {
            return false;
        }
        if (!ac.senderOfReportRequest.equals(this.senderOfReportRequest)) {
            return false;
        }
        return ac.tmpPorts.equals(this.tmpPorts);
    }

    private Vector getValues(Hashtable h1) {
        Vector v1 = new Vector();
        Enumeration e = h1.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            v1.addElement(o);
        }
        return v1;
    }

    private boolean remove(Hashtable h1, Object o) {
        Enumeration e = h1.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = h1.get(key);
            if (!value.equals(o)) continue;
            h1.remove(key);
            return true;
        }
        return false;
    }

    private void addVector(Vector v1, Vector v2) {
        for (int i = 0; i < v2.size(); ++i) {
            Object o = v2.elementAt(i);
            v1.addElement(o);
        }
    }
}

