/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import org.coos.javaframe.messages.Message;

public class MailBox {
    private Message firstMessage;
    private Message lastMessage;

    public final synchronized void addMessage(Message sig) {
        if (this.firstMessage == null) {
            this.firstMessage = sig;
        } else {
            this.lastMessage.nextMessage = sig;
        }
        this.lastMessage = sig;
        sig.nextMessage = null;
    }

    public final synchronized void addMessageFirst(Message sig) {
        if (this.firstMessage == null) {
            this.lastMessage = sig;
        }
        sig.nextMessage = this.firstMessage;
        this.firstMessage = sig;
    }

    public final void moveMailBox(MailBox mBox) {
        if (mBox.firstMessage == null) {
            return;
        }
        if (this.firstMessage == null) {
            this.lastMessage = mBox.lastMessage;
        } else {
            mBox.lastMessage.nextMessage = this.firstMessage;
        }
        this.firstMessage = mBox.firstMessage;
        mBox.firstMessage = null;
        mBox.lastMessage = null;
    }

    public final synchronized Message removeFirst() {
        if (this.firstMessage == null) {
            return null;
        }
        Message first = this.firstMessage;
        if (this.firstMessage == this.lastMessage) {
            this.firstMessage = null;
            this.lastMessage = null;
        } else {
            this.firstMessage = this.firstMessage.nextMessage;
        }
        first.nextMessage = null;
        return first;
    }

    public final Message getFirst() {
        return this.firstMessage;
    }

    public final boolean isEmpty() {
        return this.lastMessage == null;
    }

    public final synchronized void clearMailBox() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }
}

