/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Vector;

public class SchedulerSpec {
    private Vector actorTypes = new Vector();
    private int threads = 1;
    private String id;
    private String className;

    public SchedulerSpec() {
    }

    public SchedulerSpec(String id) {
        this.id = id;
    }

    public Vector getActorTypes() {
        return this.actorTypes;
    }

    public String getActorType(String actor) {
        for (int i = 0; i < this.actorTypes.size(); ++i) {
            String s = (String)this.actorTypes.elementAt(i);
            if (!s.equals(actor)) continue;
            return s;
        }
        return null;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getId() {
        return this.id;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchedulerSpec)) {
            return false;
        }
        SchedulerSpec that = (SchedulerSpec)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public void addActorType(String actorType) {
        this.actorTypes.addElement(actorType);
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.threads > 1 ? "org.coos.javaframe.ThreadPooledScheduler" : "org.coos.javaframe.SchedulerImpl";
        }
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Scheduler id: <" + this.id + "> Threads: <" + this.threads + "> Class name: <" + this.className + ">");
        sb.append("\n       Actors: ");
        for (int i = 0; i < this.actorTypes.size(); ++i) {
            String s = (String)this.actorTypes.elementAt(i);
            sb.append("<" + s + ">, ");
        }
        return sb.toString();
    }
}

