/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.ActorPartSpec;
import org.coos.actorframe.ActorReport;
import org.coos.actorframe.ActorSM;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.CompositeState;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.RoleCS;
import org.coos.javaframe.RoleError;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.JFConstants;

public class StateMachineCS
extends RoleCS
implements JFConstants {
    protected State waitCreateAck = new State("waitCreateAck", this);
    protected State init = new State("init", this);
    public static final int CREATION_TIMER_SPEC = 15000;
    public static final String CREATION_TIMER_ID = "CreationTimer";
    public static final int NO_OF_RETRIALS = 3;
    public static String ROUTER_UPDATE_INTERVAL_ID = "ROUTER_UPDATE_INTERVAL";

    public StateMachineCS(String sn, CompositeState cs) {
        super(sn, cs);
    }

    public StateMachineCS() {
        super("StateMachineCS");
    }

    public StateMachineCS(String sn) {
        super(sn);
    }

    @Override
    public void enterState(StateMachine curfsm) {
        curfsm.setInitialState(this.init);
        this.init.enterState(curfsm);
    }

    protected void startPlaying(StateMachine curfsm) {
        if (curfsm.isVisible()) {
            curfsm.getScheduler().upDateVisibleActors(curfsm);
        }
    }

    protected void stopPlaying(StateMachine curfsm) {
        if (curfsm.isVisible()) {
            curfsm.getScheduler().unRegVisibleActor(curfsm.getMyActorAddress());
        }
    }

    @Override
    public void execTrans(ActorMsg sig, State st, StateMachine curfsm) {
        if (st == this.init) {
            if (sig.equals("RolePlayMsg")) {
                Vector connectors;
                AFPropertyMsg rrm = (AFPropertyMsg)sig.getProperty("rrm");
                curfsm.context.setRootPlayMsg(sig);
                curfsm.context.setMyParentAddress(sig.getSenderRole());
                curfsm.context.setMyAddress(sig.getReceiverRole());
                curfsm.context.addRequestorRole(rrm.getSenderRole().getActorID(), rrm.getSenderRole());
                Vector ports = (Vector)sig.getProperty("ports");
                if (ports != null && !ports.isEmpty() && (connectors = (Vector)sig.getProperty("connectors")) != null) {
                    curfsm.createPorts(connectors);
                }
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayAckMsg", true), sig.getSenderRole());
                connectors = (Vector)sig.getProperty("connectors");
                if (connectors != null && !ports.isEmpty()) {
                    curfsm.createPorts(connectors);
                }
                if (curfsm.createParts()) {
                    this.performExit(curfsm);
                    curfsm.startTimer(15000L, CREATION_TIMER_ID);
                    curfsm.setNoOfTrialsLeft(2);
                    curfsm.context.setHistoryStateId(this.idle.stateName());
                    this.nextState(this.waitCreateAck, curfsm);
                } else {
                    this.transStartPlaying(curfsm, this.idle);
                }
                return;
            }
            if (sig.equals("RoleCreateMsg")) {
                ActorAddress aa;
                Vector connectors;
                curfsm.context.setRootPlayMsg(null);
                curfsm.setPersistent(true);
                curfsm.context.setMyParentAddress(sig.getSenderRole());
                curfsm.context.setMyAddress(sig.getReceiverRole());
                Vector ports = (Vector)sig.getProperty("ports");
                if (ports != null && !ports.isEmpty() && (connectors = (Vector)sig.getProperty("connectors")) != null) {
                    curfsm.createPorts(connectors);
                }
                if ((aa = sig.getSenderRole()).getActorDomain() == null && curfsm.getContainer() != null) {
                    aa.setActorDomain(curfsm.getScheduler().getSchedulerData().getActorDomainName());
                }
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateAckMsg", true), aa);
                if (curfsm.createParts()) {
                    this.performExit(curfsm);
                    this.nextState(this.waitCreateAck, curfsm);
                    return;
                }
                this.transStartPlaying(curfsm, this.idle);
                return;
            }
        } else if (st == this.waitCreateAck) {
            if (sig.equals("RoleCreateAckMsg")) {
                curfsm.context.removeCreationChild(sig.getSenderRole());
                curfsm.context.addPersistentChildrenRole(sig.getSenderRole());
                Vector v = curfsm.context.getCreationOfChildren();
                if (v.isEmpty()) {
                    if (curfsm.context.getRootPlayMsg() != null) {
                        curfsm.stopTimer(CREATION_TIMER_ID);
                    }
                    this.transStartPlaying(curfsm, this.idle);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateNackMsg")) {
                AFPropertyMsg rpm;
                curfsm.trace.traceError("ActorCS: Inner part rejected request -- creation of inner parts aborted");
                if (curfsm.context.getParentAddress().getActorID() != null) {
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), curfsm.context.getParentAddress());
                }
                if ((rpm = (AFPropertyMsg)curfsm.context.getRootPlayMsg()) != null) {
                    curfsm.stopTimer(CREATION_TIMER_ID);
                    AFPropertyMsg rrm = (AFPropertyMsg)rpm.getProperty("rrm");
                    AFPropertyMsg m = new AFPropertyMsg("RoleRequestMsg", true);
                    m.setProperty("rrm", rrm);
                    curfsm.sendMessage((ActorMsg)m, rpm.getSenderRole());
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayNackMsg", true), curfsm.context.getActorAddress());
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateMsg")) {
                Vector v = curfsm.context.getCreationOfChildren();
                if (!v.isEmpty()) {
                    if (curfsm.createParts(v)) {
                        curfsm.trace.traceError("ActorCS: Creation Timeout, new creation message received");
                    } else {
                        curfsm.trace.traceError("ActorCS: Creation Timeout, new creation message received, but no RoleCreateMsg is sent out");
                    }
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("TimerMsg") && ((AFPropertyMsg)sig).getProperty("timerId").equals(CREATION_TIMER_ID)) {
                Vector v = curfsm.context.getCreationOfChildren();
                if (!v.isEmpty()) {
                    if (curfsm.getNoOfTrialsLeft() > 0) {
                        curfsm.setNoOfTrialsLeft(curfsm.getNoOfTrialsLeft() - 1);
                        if (curfsm.createParts(v)) {
                            curfsm.startTimer(15000L, CREATION_TIMER_ID);
                        }
                        this.sameState(curfsm);
                        return;
                    }
                    curfsm.trace.traceError("ActorCS: Creation timeout, creation of inner parts aborted");
                    this.sendResponsToRequestor(curfsm, "RolePlayNackMsg");
                    this.sameState(curfsm);
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), curfsm.context.getActorAddress());
                    return;
                }
                this.sameState(curfsm);
                return;
            }
        }
        if (!(st != this.waitCreateAck || sig.equals("RoleRemoveMsg") || sig.equals("RoleReleaseMsg") || sig.equals("RolePlayEndedMsg") || sig.equals("SetActorTraceMsg") || sig.equals("ReportRequestMsg") || sig.equals("ReportResponsMsg") || sig.equals("ActorReportTimerMsg"))) {
            this.save(sig, curfsm);
            this.sameState(curfsm);
            return;
        }
        if (st != this.init) {
            if (sig.equals("RoleRequestMsg")) {
                AFPropertyMsg rrm = (AFPropertyMsg)sig;
                String roleType = (String)rrm.getProperty("roleType");
                String roleId = (String)rrm.getProperty("roleId");
                PartSpec partSpec = curfsm.findRoleSpec(roleType, curfsm.actorSpec.getPartDesc());
                if (partSpec == null) {
                    this.sendRoleDeniedMsg(rrm, curfsm, RoleError.ROLE_TYPE_NOT_CONTAINABLE);
                    this.sameState(curfsm);
                    return;
                }
                if (partSpec.isCredentialsRequired() && !curfsm.validateCredentials(rrm)) {
                    this.sendRoleDeniedMsg(rrm, curfsm, RoleError.NOT_AUTHORIZED);
                    this.sameState(curfsm);
                    return;
                }
                AFPropertyMsg msg = this.createRolePlayMsg(rrm, partSpec, curfsm);
                Vector v = curfsm.context.getChildrenRoles((String)rrm.getProperty("roleType"));
                if (roleId != null && !roleId.equals("") || v.isEmpty()) {
                    String contextId = curfsm.getContextString();
                    if (roleId != null && !roleId.equals("")) {
                        contextId = contextId + roleId;
                    } else {
                        String id = roleType.substring(0, 1).toLowerCase() + roleType.substring(1);
                        contextId = contextId + id + StateMachine.UNIQ_ID++ + "Set" + partSpec.getSetNo();
                    }
                    ActorAddress aa = curfsm.context.getChildrenRole(contextId);
                    if (aa != null) {
                        curfsm.sendMessage((ActorMsg)msg, aa);
                    } else if (curfsm.checkMaxLimit(partSpec)) {
                        ActorAddress newaa = new ActorAddress(contextId, roleType);
                        if (curfsm.getContainer() != null) {
                            newaa.setActorDomain(curfsm.getScheduler().getSchedulerData().getActorDomainName());
                        }
                        curfsm.sendMessage((ActorMsg)msg, newaa);
                        curfsm.context.addChildrenRole(newaa);
                    } else {
                        this.sendRoleDeniedMsg(rrm, curfsm, RoleError.ACTOR_CONTAINING_CARDINALITY_EXCEEDED);
                    }
                    this.sameState(curfsm);
                    return;
                }
                curfsm.sendMessage((ActorMsg)msg, (ActorAddress)v.firstElement());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleConfirmMsg")) {
                AFPropertyMsg rrm = (AFPropertyMsg)sig.getProperty("rrm");
                curfsm.context.addRequestedRole(rrm.getSenderRole().getActorID(), sig.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateMsg")) {
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RolePlayNackMsg")) {
                curfsm.context.remove(sig.getSenderRole());
                if (curfsm.removeIfPossible()) {
                    this.performExit(curfsm);
                    curfsm.setReadyToBeDeleted();
                    this.stopPlaying(curfsm);
                    if (curfsm.isVisible()) {
                        curfsm.stopTimer(ROUTER_UPDATE_INTERVAL_ID);
                    }
                    this.nextState(this.init, curfsm);
                    return;
                }
                AFPropertyMsg rrm = (AFPropertyMsg)sig.getProperty("RoleRequestMsg");
                AFPropertyMsg m = new AFPropertyMsg("RoleDeniedMsg", true);
                m.setProperty("RoleRequestMsg", rrm);
                m.setInt("reasonCode", RoleError.ROLE_TYPE_CREATION_ERROR);
                curfsm.sendMessage((ActorMsg)m, rrm.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateAckMsg")) {
                curfsm.context.addChildrenRole(sig.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateNackMsg")) {
                curfsm.trace.traceError("Actor creation error: " + sig.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleReleaseMsg")) {
                curfsm.context.remove(sig.getSenderRole());
                if (curfsm.removeIfPossible()) {
                    this.performExit(curfsm);
                    curfsm.setReadyToBeDeleted();
                    this.stopPlaying(curfsm);
                    if (curfsm.isVisible()) {
                        curfsm.stopTimer(ROUTER_UPDATE_INTERVAL_ID);
                    }
                    this.nextState(this.init, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RolePlayEndedMsg")) {
                curfsm.context.remove(sig.getSenderRole());
                if (curfsm.removeIfPossible()) {
                    this.performExit(curfsm);
                    curfsm.setReadyToBeDeleted();
                    this.stopPlaying(curfsm);
                    if (curfsm.isVisible()) {
                        curfsm.stopTimer(ROUTER_UPDATE_INTERVAL_ID);
                    }
                    this.nextState(this.init, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleDeniedMsg")) {
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RolePlayMsg")) {
                ActorAddress requestorId = this.sendResponsToRequestor(curfsm, "RoleConfirmMsg");
                curfsm.context.addRequestorRole(requestorId.getActorID(), requestorId);
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayAckMsg", true), sig.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleResetMsg")) {
                curfsm.releaseAllAssociations();
                curfsm.releaseChildren();
                if (curfsm.context.isEmpty()) {
                    this.performExit(curfsm);
                    if (curfsm.isVisible()) {
                        curfsm.stopTimer(ROUTER_UPDATE_INTERVAL_ID);
                    }
                    this.nextState(this.init, curfsm);
                } else {
                    this.sameState(curfsm);
                }
                return;
            }
            if (sig.equals("RoleRemoveMsg")) {
                curfsm.releaseAllAssociations();
                curfsm.setPersistent(false);
                curfsm.context.removeAll(curfsm.context.getRequestedRoles());
                curfsm.context.removeAll(curfsm.context.getRequestorRoles());
                Vector v = curfsm.context.getChildrenRoles();
                if (v != null) {
                    curfsm.sendMessage(sig.getCopy(curfsm.getScheduler().getClassLoader()), curfsm.context.getChildrenRoles());
                }
                if (curfsm.removeIfPossible()) {
                    this.performExit(curfsm);
                    curfsm.setReadyToBeDeleted();
                    this.stopPlaying(curfsm);
                    if (curfsm.isVisible()) {
                        curfsm.scheduler.unRegVisibleActor(curfsm.getMyActorAddress());
                        curfsm.stopTimer(ROUTER_UPDATE_INTERVAL_ID);
                    }
                    this.nextState(this.init, curfsm);
                } else {
                    this.sameState(curfsm);
                }
                return;
            }
            if (sig.equals("RoleCreateMsg")) {
                curfsm.trace.traceError("ActorCS: Instance already created");
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), sig.getSenderRole());
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("StartPlayingMsg")) {
                curfsm.routerUpdate();
                return;
            }
            if (sig.equals("RouterUpdateTimerMsg")) {
                curfsm.routerUpdate();
                return;
            }
        }
        if (st == this.init && st == this.waitCreateAck && (sig.equals("DeleteActorMsg") || sig.equals("AddActorMsg"))) {
            this.save(sig, curfsm);
            return;
        }
        if (sig.equals("RoleRestartMsg")) {
            this.performExit();
            this.sendMessage("RoleRestartMsg", curfsm.getContext().getChildrenRoles());
            this.traceTask("Role is reset");
            this.sendMessage("StartPlayingMsg", this.getMyActorAddress());
            this.nextState(this.idle);
            return;
        }
        if (sig.equals("ARE_YOU_THERE")) {
            this.sendMessage("YES_I_AM", sig.getSenderRole());
            this.sameState();
            return;
        }
        if (sig.equals("ReportRequestMsg")) {
            this.transReportRequest(curfsm, sig);
            this.sameState(curfsm);
            return;
        }
        if (sig.equals("ReportResponsMsg")) {
            this.transReportRespond(curfsm, sig);
            this.sameState(curfsm);
            return;
        }
        if (sig.equals("ActorReportTimerMsg")) {
            if (curfsm.noOfRRMessages > 0) {
                curfsm.context.actorReport.status = this.writeStatus(curfsm);
                curfsm.trace.traceWarning(curfsm.context.actorReport.status);
                curfsm.sendMessage((ActorMsg)new AFPropertyMsg("ReportResponsMsg", true).setProperty("actorReport", curfsm.context.actorReport), curfsm.senderOfReportRequest);
            }
            this.sameState(curfsm);
            return;
        }
    }

    private String writeStatus(StateMachine asm) {
        String s = null;
        if (asm.noOfRRMessages > 0) {
            s = "\nActor: " + asm.getMyActorAddress() + " - " + asm.noOfRRMessages + " - children of actor: " + asm.getMyActorAddress() + " has not responded";
        }
        return s;
    }

    protected AFPropertyMsg createRolePlayMsg(AFPropertyMsg rrm, PartSpec p, StateMachine curfsm) {
        AFPropertyMsg msg = new AFPropertyMsg("RolePlayMsg", true);
        msg.setProperty("rrm", rrm);
        msg.setProperty("ports", curfsm.getApplicationSpec().getActorSpec(p.getRoleType()).getPortNames());
        msg.setProperty("targetActor", p.getActorDomain());
        msg.setProperty("connectors", curfsm.actorSpec.getConnectorDesc(p.getRoleType(), null));
        msg.setBoolean("visible", p.isVisible());
        msg.setInt("traceLevel", p.getTraceLev());
        return msg;
    }

    protected void sendRoleDeniedMsg(AFPropertyMsg rrm, StateMachine curfsm, int reasonCode) {
        AFPropertyMsg m = new AFPropertyMsg("RoleDeniedMsg", true);
        m.setInt("reasonCode", reasonCode);
        m.setProperty("rrm", rrm);
        curfsm.sendMessage((ActorMsg)m, rrm.getSenderRole());
    }

    protected ActorAddress sendResponsToRequestor(StateMachine curfsm, String msgType) {
        AFPropertyMsg rpm = (AFPropertyMsg)curfsm.context.getRootPlayMsg();
        if (rpm != null) {
            AFPropertyMsg rrm = (AFPropertyMsg)rpm.getProperty("rrm");
            AFPropertyMsg m = new AFPropertyMsg(msgType, true);
            m.setProperty("rrm", rrm);
            curfsm.sendMessage((ActorMsg)m, rrm.getSenderRole());
            return rrm.getSenderRole();
        }
        return null;
    }

    protected void transStartPlaying(StateMachine curfsm, State nxtState) {
        CompositeState cs;
        String actorId;
        PartSpec spec;
        this.performExit(curfsm);
        this.sendResponsToRequestor(curfsm, "RoleConfirmMsg");
        AFPropertyMsg msg = new AFPropertyMsg("StartPlayingMsg", true);
        ActorSpec aspec = curfsm.getApplicationSpec().getActorSpec(curfsm.context.getParentAddress().getActorType());
        if (aspec != null && (spec = aspec.getPartSpec(curfsm.myActorType)) instanceof ActorPartSpec) {
            ActorPartSpec apspec = (ActorPartSpec)spec;
            String myRoleName = curfsm.myActorId.substring(curfsm.myActorId.lastIndexOf(47) + 1);
            String[] roleNames = spec.getRoleNames();
            Hashtable properties = null;
            if (apspec.getActorProperties() != null && (properties = (Hashtable)apspec.getActorProperties().get("default")) != null) {
                msg.setProperties(properties);
            }
            for (int i = 0; i < roleNames.length; ++i) {
                if (!roleNames[i].equals(myRoleName) || apspec.getActorProperties() == null) continue;
                Hashtable props = (Hashtable)apspec.getActorProperties().get(myRoleName);
                if (props != null) {
                    if (properties != null) {
                        Enumeration en = properties.keys();
                        while (en.hasMoreElements()) {
                            Object o = en.nextElement();
                            if (props.get(o) != null) continue;
                            props.put(o, properties.get(o));
                        }
                    }
                    msg.setProperties(props);
                    continue;
                }
                if (properties == null) continue;
                msg.setProperties(properties);
            }
        }
        ActorAddress reciever = curfsm.getMyActorAddress();
        Enumeration en = curfsm.getStateMachines().keys();
        while (en.hasMoreElements()) {
            actorId = (String)en.nextElement();
            cs = (CompositeState)curfsm.getCurrentStates().get(actorId);
            if (cs == null) continue;
            curfsm.sendMessage((ActorMsg)msg, reciever);
            this.nextState(nxtState, curfsm);
        }
        en = curfsm.getStateMachines().keys();
        while (en.hasMoreElements()) {
            actorId = (String)en.nextElement();
            cs = (CompositeState)curfsm.getCurrentStates().get(actorId);
            if (cs != null) continue;
            actorId = curfsm.getMyActorAddress().getActorID() + "." + actorId;
            reciever.setActorID(actorId);
            curfsm.sendMessage((ActorMsg)msg.cloneAFPropertyMsg(curfsm.getContainer()), reciever);
        }
        this.startPlaying(curfsm);
        curfsm.context.setRootPlayMsg(null);
    }

    protected boolean isStateIsInSuper(State st) {
        return st == this.init || st == this.waitCreateAck;
    }

    protected void sendRolePlayNackMsg(StateMachine curfsm) {
        AFPropertyMsg rpm = (AFPropertyMsg)curfsm.context.getRootPlayMsg();
        if (rpm != null) {
            AFPropertyMsg msg = new AFPropertyMsg("RolePlayNackMsg", true);
            msg.setProperty("RoleRequestMsg", rpm.getProperty("RoleRequestMsg"));
            curfsm.sendMessage((ActorMsg)msg, rpm.getSenderRole());
        }
    }

    protected void transReportRequest(StateMachine asm, ActorMsg sig) {
        AFPropertyMsg rrmsg = (AFPropertyMsg)sig;
        asm.senderOfReportRequest = rrmsg.getSenderRole();
        asm.noOfRRMessages = asm.context.getChildrenRoles().size();
        asm.context.actorReport = new ActorReport();
        asm.context.actorReport.myId = asm.context.getActorAddress();
        asm.context.actorReport.myParrentId = asm.context.getParentAddress();
        asm.context.actorReport.myState = asm.getCurrentState().getFullStateName();
        asm.context.actorReport.RequestType = rrmsg.getString("requestType");
        asm.context.actorReport.myStateData = asm.printStateData();
        asm.context.actorReport.myRequestedRoles = asm.context.getRequestedRoles();
        asm.context.actorReport.yourRequestedRoles = asm.context.getRequestorRoles();
        asm.context.actorReport.active = asm.isPersistent();
        asm.context.actorReport.traceLevel = asm.getTraceLevel();
        asm.context.actorReport.myRoles = null;
        asm.context.actorReport.status = null;
        asm.context.actorReport.ports = asm.ports;
        if (asm.context.getActorProperties() != null) {
            asm.context.actorReport.setMyProperties(asm.context.getActorProperties());
        }
        if (asm.noOfRRMessages == 0 || rrmsg.getString("requestType").equals("this")) {
            asm.sendMessage((ActorMsg)new AFPropertyMsg("ReportResponsMsg", true).setProperty("actorReport", asm.context.actorReport), asm.senderOfReportRequest);
            asm.context.actorReport = null;
        } else if (rrmsg.getString("requestType").equals("all")) {
            asm.sendMessage((ActorMsg)new AFPropertyMsg("ReportRequestMsg", true).setProperty("requestType", rrmsg.getString("requestType")), asm.context.getChildrenRoles());
            asm.startTimer(ActorSM.ACTOR_REPORT_TIMEOUT, "ACTOR_REPORT_TIMER");
        } else if (rrmsg.getString("requestType").equals("this")) {
            asm.sendMessage((ActorMsg)new AFPropertyMsg("ReportResponsMsg", true).setProperty("actorReport", asm.context.actorReport), asm.senderOfReportRequest);
            asm.context.actorReport = null;
        }
    }

    private void transReportRespond(StateMachine asm, ActorMsg sig) {
        AFPropertyMsg rrmsg = (AFPropertyMsg)sig;
        asm.context.actorReport.myChildren.addElement(rrmsg.getProperty("actorReport"));
        --asm.noOfRRMessages;
        if (asm.noOfRRMessages <= 0) {
            asm.sendMessage((ActorMsg)new AFPropertyMsg("ReportResponsMsg", true).setProperty("actorReport", asm.context.actorReport), asm.senderOfReportRequest);
            asm.stopTimer("ACTOR_REPORT_TIMER");
        }
    }

    public AFPropertyMsg createRoleRequestMsg(String actorid, String actorType) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleRequestMsg", true);
        pm.setProperty("roleId", actorid);
        pm.setProperty("roleType", actorType);
        return pm;
    }
}

