/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.XmlBuilder;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.ActorMsg;

public class TraceObject
implements AFConstants {
    private static int counter = 0;
    private int transitionId = 0;
    protected ActorMsg inputSignal;
    protected String currentState;
    protected String newState;
    String task;
    protected Vector outputSignals;
    protected Hashtable timers;
    Vector errors;
    Vector warnings;
    Hashtable portOutSignals;
    Hashtable portInSignals;
    String portTask;
    boolean traceFlag = true;
    int traceCategories;
    int traceLevel;
    Calendar timeFormatter;
    private Logger logger;
    private StateMachine curfsm = null;
    private boolean outputDisabled = false;

    public TraceObject() {
        this.initTrace("org.coos.actorframe");
    }

    public TraceObject(StateMachine curfsm) {
        this.initTrace(curfsm.getClass().toString());
        this.curfsm = curfsm;
    }

    public TraceObject(ActorAddress actor) {
        String ac = actor.getActorID();
        this.initTrace(ac.replace('/', '.'));
    }

    public TraceObject(ActorAddress actor, ActorMsg inputSignal, String currentState) {
        this.initTrace(actor.getActorID().replace('/', '.'));
    }

    private void initTrace(String loggerName) {
        this.outputSignals = new Vector();
        this.portOutSignals = new Hashtable();
        this.portInSignals = new Hashtable();
        this.timeFormatter = Calendar.getInstance();
        this.logger = LoggerFactory.getLogger(loggerName);
    }

    public void traceInit(int traceCategories, int traceLevel, String loggerName) {
        this.task = "";
        this.outputSignals.removeAllElements();
        if (this.warnings != null) {
            this.warnings.removeAllElements();
        }
        if (this.errors != null) {
            this.errors.removeAllElements();
        }
        this.transitionId = counter++;
        this.traceCategories = traceCategories;
        this.traceLevel = traceLevel;
        this.logger = LoggerFactory.getLogger(loggerName);
    }

    public void traceInit(StateMachine curfsm) {
        this.task = "";
        this.outputSignals.removeAllElements();
        this.inputSignal = null;
        this.portTask = "";
        this.portOutSignals.clear();
        this.portInSignals.clear();
        if (this.warnings != null) {
            this.warnings.removeAllElements();
        }
        if (this.errors != null) {
            this.errors.removeAllElements();
        }
        this.transitionId = counter++;
        this.curfsm = curfsm;
        this.traceLevel = curfsm.getTraceLevel();
    }

    public StateMachine getCurrentStateMachine() {
        return this.curfsm;
    }

    public int getTransitionId() {
        return this.transitionId;
    }

    protected int getTraceFormat() {
        if (this.curfsm == null) {
            return ApplicationSpec.TRACE_FORMAT_TEXT;
        }
        return this.curfsm.getApplicationSpec().getTraceFormat();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setOutputDisabled(boolean outputDisabled) {
        this.outputDisabled = outputDisabled;
    }

    public ActorAddress getActor() {
        if (this.inputSignal == null) {
            return null;
        }
        return this.inputSignal.getReceiverRole();
    }

    public ActorMsg getInputSignal() {
        return this.inputSignal;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getNewState() {
        return this.newState;
    }

    public Vector getOutputSignals() {
        return this.outputSignals;
    }

    public Vector getWarnings() {
        return this.warnings != null ? this.warnings : new Vector();
    }

    public Vector getErrors() {
        return this.errors;
    }

    public Hashtable getPortOutSignals() {
        return this.portOutSignals;
    }

    public Hashtable getPortInSignals() {
        return this.portInSignals;
    }

    public void traceSetLevel(int level) {
        this.traceLevel = level;
    }

    public void traceTask(String str) {
        if (this.traceLevel > 1) {
            return;
        }
        this.task = this.task.equals("") ? str : this.task + "; " + str;
    }

    public String getTraceTask() {
        return this.task;
    }

    public void traceSystem(String str) {
        if (!this.outputDisabled) {
            this.traceOut(2, 2, this.getTraceHeader() + str);
        }
    }

    public String getTraceHeader() {
        try {
            if (this.inputSignal != null) {
                StringBuffer str = new StringBuffer();
                str.append("ACTOR: " + this.inputSignal.getReceiverRole());
                str.append(" TRIGGER: " + this.inputSignal.getMsgId());
                str.append(" STATE: " + this.currentState);
                str.append(" MESSAGE: ");
                return str.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "method getTraceHeader failed, actor is null ";
    }

    public void setTrace(boolean trace) {
        this.traceFlag = trace;
    }

    public void traceOutput(ActorMsg am) {
        this.outputSignals.addElement(am);
    }

    public void traceWarning(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.log(3, this.getTraceHeader() + s);
        }
        if (this.traceLevel > 3) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new Vector();
        }
        this.warnings.addElement(s);
    }

    public void traceError(String s) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(4, this.getTraceHeader() + s);
        }
        if (this.traceLevel > 4) {
            return;
        }
        if (this.errors == null) {
            this.errors = new Vector();
        }
        this.errors.addElement(s);
    }

    public void traceOut(int level, String value) {
        this.traceOut(level, 1, value);
    }

    public void traceOut(int level, int categories, String value) {
        if (!this.outputDisabled && level >= this.traceLevel) {
            this.logger.setTraceLevel(this.traceLevel);
            this.logger.log(level, categories, value);
        }
    }

    public String getPortString(ActorMsg inp) {
        String s = "";
        if (this.portOutSignals.isEmpty() && this.portInSignals.isEmpty()) {
            return s;
        }
        Enumeration portNames = this.portInSignals.keys();
        while (portNames.hasMoreElements()) {
            Vector out;
            Vector in;
            String name = (String)portNames.nextElement();
            if (inp != null) {
                s = s + "  PORT NAME: " + name + "\n";
            }
            if ((in = (Vector)this.portInSignals.get(name)) != null) {
                Enumeration ein = in.elements();
                while (ein.hasMoreElements()) {
                    if (inp != null) {
                        s = s + "  ";
                    }
                    s = s + "  INPUT:  " + (String)ein.nextElement() + "\n";
                }
            }
            if ((out = (Vector)this.portOutSignals.get(name)) == null) continue;
            Enumeration eout = out.elements();
            while (eout.hasMoreElements()) {
                if (inp != null) {
                    s = s + "  ";
                }
                s = s + "  OUTPUT: " + (String)eout.nextElement() + "\n";
            }
        }
        return s;
    }

    public String toString() {
        String str;
        int i;
        if (this.inputSignal.messageName() != null && this.inputSignal.messageName().equals("RouterUpdateTimerMsg")) {
            return "";
        }
        if (this.getTraceFormat() == ApplicationSpec.TRACE_FORMAT_XML) {
            return XmlBuilder.toXML(this);
        }
        StringBuffer sb = new StringBuffer("\n");
        sb.append("START TRANSITION NO: " + this.transitionId);
        if (this.inputSignal != null) {
            sb.append(" ACTOR: " + this.inputSignal.getReceiverRole());
            if (this.inputSignal.getReceiverRole().hasActorPort()) {
                sb.append(" PORT: " + this.inputSignal.getReceiverRole().getActorPort() + "\n");
            }
            sb.append(" TRIGGER: " + this.inputSignal.messageName());
            sb.append(" CURRENT STATE: " + this.filterStateName(this.currentState));
            sb.append(" NEXT STATE: " + this.filterStateName(this.newState) + "\n");
            sb.append("  INPUT:  " + this.inputSignal.messageContent() + "\n");
        }
        if (this.warnings != null) {
            for (i = 0; i < this.warnings.size(); ++i) {
                str = (String)this.warnings.elementAt(i);
                sb.append("  WARNING: " + str + "\n");
            }
        }
        if (this.errors != null) {
            for (i = 0; i < this.errors.size(); ++i) {
                str = (String)this.errors.elementAt(i);
                sb.append("  ERROR:   " + str + "\n");
            }
        }
        for (i = 0; i < this.outputSignals.size(); ++i) {
            ActorMsg msg = (ActorMsg)this.outputSignals.elementAt(i);
            sb.append("  OUTPUT: " + msg.messageContent() + "\n");
        }
        if (!this.task.equals("")) {
            sb.append("  TASK:    " + this.task + "\n");
        }
        sb.append(this.getPortString(this.inputSignal));
        if (!this.inputSignal.getReceiverRole().hasActorPort()) {
            sb.append("END TRANSITION ACTOR: \n");
        } else {
            sb.append("END TRANSITION PORT: \n");
        }
        sb.append("-------------------------------------------------------------------->");
        return sb.toString();
    }

    public void setActor(ActorAddress actor) {
    }

    public void addPortOutputSignal(String portname, ActorMsg outsig) {
        if (this.portOutSignals.containsKey(portname)) {
            Vector out = (Vector)this.portOutSignals.get(portname);
            out.addElement(outsig.messageContent());
        } else {
            Vector<String> tmp = new Vector<String>();
            tmp.addElement(outsig.messageContent());
            this.portOutSignals.put(portname, tmp);
        }
    }

    public void addPortInputSignal(String portname, ActorMsg insig) {
        if (this.portInSignals.containsKey(portname)) {
            Vector out = (Vector)this.portInSignals.get(portname);
            out.addElement(insig.messageContent());
        } else {
            Vector<String> tmp = new Vector<String>();
            tmp.addElement(insig.messageContent());
            this.portInSignals.put(portname, tmp);
        }
    }

    public void setInputSignal(ActorMsg inputSignal) {
        this.inputSignal = inputSignal;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public void setNewState(String newState) {
        this.newState = newState;
    }

    public String filterStateName(String name) {
        if (name == null) {
            return null;
        }
        while (name.indexOf(58) != -1) {
            StringBuffer buf = new StringBuffer();
            int first = name.indexOf(58);
            int last = name.indexOf(58, first + 1);
            buf.append(name.substring(0, first));
            buf.append(name.substring(last + 1, name.length()));
            name = buf.toString();
        }
        return name;
    }
}

