/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.TraceConstants;

/**
 * @author Knut Eilif Husa, Tellu AS
 */
public class J2SELoggerImpl implements Logger {
	private org.slf4j.Logger logger = null;

	public J2SELoggerImpl() {
		logger = org.slf4j.LoggerFactory.getLogger(org.slf4j.Logger.ROOT_LOGGER_NAME);
	}

	public void setLoggerName(String loggerName) {
		logger = org.slf4j.LoggerFactory.getLogger(loggerName);
	}

	public String getLoggerName() {
		return logger.getName();
	}

	public void log(int level, int categories, String value) {
		switch (level) {
		case TraceConstants.tlError:
			logger.error(value);

			break;

		case TraceConstants.tlFatal:
			logger.error(value);

			break;

		case TraceConstants.tlWarn:
			logger.warn(value);

			break;

		case TraceConstants.tlInfo:
			logger.info(value);

			break;

		case TraceConstants.tlDebug:
			logger.debug(value);

			break;
		}
	}

	public void log(int level, String value) {
		log(level, TraceConstants.tcOff, value);
	}

	public void setTraceLevel(int traceLevel) {
	}

	public boolean isDebugEnabled() {
		return LoggerFactory.isTraceOn() && logger.isDebugEnabled();
	}

	public boolean isErrorEnabled() {
		return LoggerFactory.isTraceOn() && logger.isErrorEnabled();
	}

	public boolean isInfoEnabled() {
		return LoggerFactory.isTraceOn() && logger.isInfoEnabled();
	}

	public boolean isTraceEnabled() {
		return LoggerFactory.isTraceOn() && logger.isDebugEnabled(); // We are
		// using
		// Debug
		// for
		// our
		// trace...
	}

	public boolean isWarnEnabled() {
		return LoggerFactory.isTraceOn() && logger.isWarnEnabled();
	}
}
