/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.ActorPartSpec;
import org.coos.actorframe.ActorPortSpec;
import org.coos.actorframe.RoleSpec;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.PortSpec;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;

public class ActorSpec
implements AFSerializer {
    private Vector connectorDesc;
    private Vector partDesc;
    private Vector portDesc;
    private Vector roleDesc;
    private String actorType;
    private String actorClassName;
    public static String DELETED_CONNECTORS = "removedConnectors";
    public static String ADDED_CONNECTOR = "addedConnectors";
    public static String DELETED_PARTS = "removedParts";
    public static String ADDED_PARTS = "addedParts";
    public static String ADDED_PORTS = "addedPorts";
    public static String DELETED_PORTS = "deletedPorts";

    public ActorSpec() {
    }

    public ActorSpec(String actorType, String actorClassName) {
        this.actorType = actorType;
        this.actorClassName = actorClassName;
    }

    public PartSpec getPartSpec(String partName) {
        if (partName == null) {
            throw new NullPointerException("Part Name is null");
        }
        if (this.partDesc != null) {
            for (int i = 0; i < this.partDesc.size(); ++i) {
                PartSpec spec = (PartSpec)this.partDesc.elementAt(i);
                if (!spec.getRoleType().endsWith(partName)) continue;
                return spec;
            }
        }
        return null;
    }

    public PortSpec getPortSpec(String portName) {
        if (this.portDesc != null) {
            for (int i = 0; i < this.portDesc.size(); ++i) {
                PortSpec spec = (PortSpec)this.portDesc.elementAt(i);
                if (!spec.getPortName().endsWith(portName)) continue;
                return spec;
            }
        }
        return null;
    }

    public RoleSpec getRoleSpec(String roleType) {
        if (this.roleDesc != null) {
            for (int i = 0; i < this.roleDesc.size(); ++i) {
                RoleSpec spec = (RoleSpec)this.roleDesc.elementAt(i);
                if (!spec.getType().endsWith(roleType)) continue;
                return spec;
            }
        }
        return null;
    }

    public void addPartSpec(PartSpec partSpec) {
        if (this.partDesc == null) {
            this.partDesc = new Vector();
        }
        this.partDesc.addElement(partSpec);
    }

    public void addPartSpec(String instance, String actorType, boolean visible) {
        ActorPartSpec ps = new ActorPartSpec(instance, actorType);
        ps.setVisible(visible);
        this.addPartSpec(ps);
    }

    public void addConnectorSpec(String from, String to, boolean bidirctional) {
        this.addConnectorSpec(new ConnectorSpec(new ActorAddress(from), new ActorAddress(to), bidirctional));
    }

    public void addConnectorSpec(ActorAddress from, ActorAddress to, boolean bidirctional) {
        this.addConnectorSpec(new ConnectorSpec(from, to, bidirctional));
    }

    public void addConnectorSpec(ConnectorSpec cs) {
        if (this.connectorDesc == null) {
            this.connectorDesc = new Vector();
        }
        this.connectorDesc.addElement(cs);
    }

    private ConnectorSpec checkConnectorSpec(ConnectorSpec cs) {
        if (cs.getFrom().getActorPort() == null) {
            cs.getFrom().setActorPort("defaultInPort");
        }
        if (cs.getTo().getActorPort() == null) {
            cs.getTo().setActorPort("defaultInPort");
        }
        return cs;
    }

    public Vector getPortNames() {
        Vector<String> v = new Vector<String>();
        if (this.portDesc != null) {
            Enumeration e = this.portDesc.elements();
            while (e.hasMoreElements()) {
                PortSpec ps = (PortSpec)e.nextElement();
                v.addElement(ps.getPortName());
            }
        }
        return v;
    }

    public boolean containsPortName(String portName) {
        if (this.portDesc != null) {
            Enumeration e = this.portDesc.elements();
            while (e.hasMoreElements()) {
                PortSpec ps = (PortSpec)e.nextElement();
                if (!ps.getPortName().equals(portName)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPortSpec(PortSpec portSpec) {
        if (this.portDesc == null) {
            this.portDesc = new Vector();
        }
        this.deletePortSpec(portSpec);
        this.portDesc.addElement(portSpec);
    }

    public void addPortSpec(String portName) {
        if (this.portDesc == null) {
            this.portDesc = new Vector();
        }
        this.portDesc.addElement(new ActorPortSpec(portName));
    }

    public void addRoleSpec(RoleSpec roleSpec) {
        if (roleSpec == null) {
            return;
        }
        if (this.roleDesc == null) {
            this.roleDesc = new Vector();
        }
        this.deleteRoleSpec(roleSpec);
        this.roleDesc.addElement(roleSpec);
    }

    public Vector getPartDesc() {
        return this.partDesc == null ? new Vector() : this.partDesc;
    }

    public void setPartDesc(Vector partDesc) {
        this.partDesc = partDesc;
    }

    public Vector getPortDesc() {
        return this.portDesc == null ? new Vector() : this.portDesc;
    }

    public void setPortDesc(Vector portDesc) {
        this.portDesc = portDesc;
    }

    public Vector getRoleDesc() {
        return this.roleDesc == null ? new Vector() : this.roleDesc;
    }

    public void setRoleDesc(Vector roleDesc) {
        this.roleDesc = roleDesc;
    }

    public String getActorType() {
        return this.actorType;
    }

    public void setActorType(String actorType) {
        this.actorType = actorType;
    }

    public String getActorClassName() {
        return this.actorClassName;
    }

    public void setActorClassName(String actorClassName) {
        this.actorClassName = actorClassName;
    }

    public void setConnectorDesc(Vector connectorDesc) {
        for (int i = 0; i < connectorDesc.size(); ++i) {
            ConnectorSpec connectorSpec = (ConnectorSpec)connectorDesc.elementAt(i);
        }
        this.connectorDesc = connectorDesc;
    }

    public ConnectorSpec getConnectorDesc(String name) {
        if (this.connectorDesc != null) {
            Enumeration e = this.connectorDesc.elements();
            while (e.hasMoreElements()) {
                ConnectorSpec cs = (ConnectorSpec)e.nextElement();
                if (!cs.getName().equals(name)) continue;
                return cs;
            }
        }
        return null;
    }

    public Vector getConnectorDesc(String actorType, String portName) {
        Vector<ConnectorSpec> v = new Vector<ConnectorSpec>();
        if (this.connectorDesc != null) {
            Enumeration e = this.connectorDesc.elements();
            while (e.hasMoreElements()) {
                ConnectorSpec cs = (ConnectorSpec)e.nextElement();
                ActorAddress aa = cs.getFrom();
                if (aa.getActorType() == null || aa.getActorPort() == null || actorType == null) {
                    System.out.println("ActorSpec.getConnectorDesc: ERROR: " + cs);
                    continue;
                }
                if (!aa.getActorType().equals(actorType) || portName != null && !aa.getActorPort().equals(portName)) continue;
                v.addElement(cs);
            }
        }
        return v;
    }

    public boolean hasPartSpecs() {
        return this.getPartDesc() != null && !this.getPartDesc().isEmpty();
    }

    private Vector compareSpecs(Vector from, Vector to, boolean equal) {
        Vector res = new Vector();
        for (int i = 0; i < from.size(); ++i) {
            Object oldcs = from.elementAt(i);
            boolean found = false;
            for (int j = 0; j < to.size(); ++j) {
                Object newcs = to.elementAt(j);
                if (!oldcs.equals(newcs)) continue;
                found = true;
                break;
            }
            if (equal && found) {
                res.addElement(oldcs);
                continue;
            }
            if (equal || found) continue;
            res.addElement(oldcs);
        }
        return res;
    }

    public Hashtable analyseDifference(ActorSpec newActorSpec) {
        Hashtable<String, Vector> res = new Hashtable<String, Vector>();
        Vector removed = this.compareSpecs(this.connectorDesc, newActorSpec.getConnectorDesc(), false);
        res.put(DELETED_CONNECTORS, removed);
        Vector added = this.compareSpecs(newActorSpec.getConnectorDesc(), this.connectorDesc, false);
        res.put(ADDED_CONNECTOR, added);
        Vector equal = this.compareSpecs(newActorSpec.getConnectorDesc(), this.connectorDesc, true);
        res.put("equalConnectors", equal);
        removed = this.compareSpecs(this.partDesc, newActorSpec.getPartDesc(), false);
        res.put(DELETED_PARTS, removed);
        added = this.compareSpecs(newActorSpec.getPartDesc(), this.partDesc, false);
        res.put(ADDED_PARTS, added);
        removed = this.compareSpecs(this.portDesc, newActorSpec.getPortDesc(), false);
        res.put(DELETED_PORTS, removed);
        added = this.compareSpecs(newActorSpec.getPortDesc(), this.portDesc, false);
        res.put(ADDED_PORTS, added);
        return res;
    }

    public static void main(String[] args) {
        ActorSpec oldAS = new ActorSpec();
        oldAS.addConnectorSpec("a1:p1@A", "b:P2@B", false);
        oldAS.addConnectorSpec("a1:p1@A", "c:P3@C", false);
        oldAS.addPartSpec("a1", "A", true);
        ActorSpec newAS = new ActorSpec();
        newAS.addConnectorSpec("a1:p1@A", "b:P2@B", false);
        newAS.addConnectorSpec("a1:p1@A", "c:P3@C", false);
        newAS.addConnectorSpec("a2:p1@A", "c:P3@C", false);
        newAS.addConnectorSpec("a1:p2@A", "b:P2@B", false);
        newAS.addPartSpec("a2", "B", true);
        Hashtable res = oldAS.analyseDifference(newAS);
        System.out.println("RES: " + res);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActorSpec)) {
            return false;
        }
        ActorSpec actorSpec = (ActorSpec)o;
        if (this.actorClassName != null ? !this.actorClassName.equals(actorSpec.actorClassName) : actorSpec.actorClassName != null) {
            return false;
        }
        if (this.actorType != null ? !this.actorType.equals(actorSpec.actorType) : actorSpec.actorType != null) {
            return false;
        }
        if (this.connectorDesc != null ? !this.connectorDesc.equals(actorSpec.connectorDesc) : actorSpec.connectorDesc != null) {
            return false;
        }
        if (this.partDesc != null ? !this.partDesc.equals(actorSpec.partDesc) : actorSpec.partDesc != null) {
            return false;
        }
        return !(this.portDesc != null ? !this.portDesc.equals(actorSpec.portDesc) : actorSpec.portDesc != null);
    }

    public int hashCode() {
        return 0;
    }

    public Vector getConnectorDesc() {
        if (this.connectorDesc != null) {
            return this.connectorDesc;
        }
        return new Vector();
    }

    protected Object clone() {
        try {
            ActorSpec as = new ActorSpec();
            as.deSerialize(this.serialize(), null);
            return as;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass().getName()).log(4, "IOException clone(). Returning null.");
            return null;
        }
    }

    public String toString() {
        String parts = this.partDesc != null && !this.partDesc.isEmpty() ? "\n  Parts      :" + this.partDesc.toString() : "";
        String roles = this.roleDesc != null && !this.roleDesc.isEmpty() ? "\n  Roles      :" + this.roleDesc.toString() : "";
        String ports = this.portDesc != null && !this.portDesc.isEmpty() ? "\n  Ports      :" + this.portDesc.toString() : "";
        String connectors = this.connectorDesc != null && !this.connectorDesc.isEmpty() ? "\n  Connectors :" + this.connectorDesc.toString() : "";
        return "\nACTOR: " + this.actorType + "  ClassName: " + this.actorClassName + parts + roles + ports + connectors;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(VectorHelper.persist((Vector)this.partDesc));
        dout.write(VectorHelper.persist((Vector)this.portDesc));
        dout.write(VectorHelper.persist((Vector)this.roleDesc));
        dout.write(VectorHelper.persist((Vector)this.connectorDesc));
        dout.write(StringHelper.persist((String)this.actorType));
        dout.write(StringHelper.persist((String)this.actorClassName));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.partDesc = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.portDesc = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.roleDesc = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.connectorDesc = VectorHelper.resurrect((DataInputStream)din, (AFClassLoader)cl);
        this.actorType = StringHelper.resurrect((DataInputStream)din);
        this.actorClassName = StringHelper.resurrect((DataInputStream)din);
        return bin;
    }

    public void deleteConnectorSpec(ConnectorSpec connectorSpec) {
        if (connectorSpec == null || this.connectorDesc == null) {
            return;
        }
        for (int i = 0; i < this.connectorDesc.size(); ++i) {
            ConnectorSpec spec = (ConnectorSpec)this.connectorDesc.elementAt(i);
            if (!spec.equals(connectorSpec)) continue;
            this.connectorDesc.removeElementAt(i);
        }
    }

    public boolean deletePartSpec(String partSpecType) {
        for (int i = 0; i < this.partDesc.size(); ++i) {
            PartSpec partSpec = (PartSpec)this.partDesc.elementAt(i);
            if (!partSpec.getRoleType().equals(partSpecType)) continue;
            this.partDesc.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean deletePortSpec(PortSpec portSpec) {
        if (portSpec == null || portSpec == null) {
            return true;
        }
        for (int i = 0; i < this.portDesc.size(); ++i) {
            PortSpec ps = (PortSpec)this.portDesc.elementAt(i);
            if (!portSpec.getPortName().equals(ps.getPortName())) continue;
            this.portDesc.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean deleteRoleSpec(RoleSpec roleSpec) {
        if (roleSpec == null || roleSpec == null) {
            return true;
        }
        for (int i = 0; i < this.roleDesc.size(); ++i) {
            RoleSpec spec = (RoleSpec)this.roleDesc.elementAt(i);
            if (!roleSpec.getInstance().equals(spec.getInstance())) continue;
            this.roleDesc.removeElementAt(i);
            return true;
        }
        return false;
    }
}

