/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;

public class ConnectorSpec
implements AFSerializer {
    private boolean isBidirectional;
    private ActorAddress to;
    private ActorAddress from;
    private String name;

    public ConnectorSpec() {
        this.isBidirectional = true;
        this.to = null;
    }

    public ConnectorSpec(ActorAddress from, ActorAddress to) {
        this.isBidirectional = false;
        this.from = from;
        this.to = to;
    }

    public ConnectorSpec(DataInputStream din) throws IOException {
        this.isBidirectional = din.readBoolean();
        this.from = ActorAddressHelper.resurrect(din);
        this.to = ActorAddressHelper.resurrect(din);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnectorSpec(ActorAddress from, ActorAddress to, boolean isBidirectional) {
        this.isBidirectional = isBidirectional;
        this.from = from;
        this.to = to;
        this.name = "c1";
    }

    public ConnectorSpec(String from, String to, boolean isBidirectional) {
        this.isBidirectional = isBidirectional;
        this.from = new ActorAddress(from);
        this.to = new ActorAddress(to);
        this.name = "c1";
    }

    public ActorAddress getFrom() {
        return this.from;
    }

    public void setFrom(ActorAddress from) {
        this.from = from;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.isBidirectional = bidirectional;
    }

    public void setTo(ActorAddress aa) {
        this.to = aa;
    }

    public ActorAddress getTo() {
        return this.to;
    }

    public void setIsBidirectional(boolean isBidirectional) {
        this.isBidirectional = isBidirectional;
    }

    public boolean getIsBidirectional() {
        return this.isBidirectional;
    }

    public static Vector getAddresses(Vector connectorSpecs) {
        Vector<ActorAddress> v = new Vector<ActorAddress>();
        for (int i = 0; i < connectorSpecs.size(); ++i) {
            ConnectorSpec cs = (ConnectorSpec)connectorSpecs.elementAt(i);
            v.addElement(cs.getTo());
        }
        return v;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof ConnectorSpec)) {
            return false;
        }
        ConnectorSpec cs = (ConnectorSpec)obj;
        return cs.isBidirectional == this.isBidirectional && cs.getTo().equals(this.to) && cs.getFrom().equals(this.from);
    }

    public Object clone() {
        return new ConnectorSpec((ActorAddress)this.from.clone(), (ActorAddress)this.to.clone(), this.isBidirectional);
    }

    public String toString() {
        return "From: " + this.from + " To: " + this.to + " Bidirectional: " + this.isBidirectional;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeBoolean(this.isBidirectional);
        dout.write(ActorAddressHelper.persist(this.from));
        dout.write(ActorAddressHelper.persist(this.to));
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.isBidirectional = din.readBoolean();
        this.from = ActorAddressHelper.resurrect(din);
        this.to = ActorAddressHelper.resurrect(din);
        return bin;
    }
}

