/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.coos.actorframe.application.Container;
import org.coos.javaframe.Actor;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorContext;
import org.coos.javaframe.ActorFrameException;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.CompositeState;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.MailBox;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.RoleCS;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.Scheduler;
import org.coos.javaframe.State;
import org.coos.javaframe.TraceObject;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;
import org.coos.javaframe.messages.JFConstants;

public class StateMachine
implements Schedulable,
Actor,
JFConstants {
    public int noOfRRMessages = 3;
    public ActorAddress senderOfReportRequest;
    public String myActorId;
    public String myActorType;
    public String myActorDomain;
    public MailBox saveQueue;
    protected String currentStateId = null;
    public Hashtable activeTimers;
    protected State nextState;
    protected ActorMsg currentMessage = null;
    protected State initialState;
    public TraceObject trace;
    public Scheduler scheduler;
    boolean readyToBeDeleted = false;
    public boolean performExitIsDone = false;
    public boolean sameStateIsDone = false;
    public boolean exitStateIsDone = false;
    public boolean saveDone = false;
    public int entryNo = 0;
    protected CompositeState myCompositeState;
    public MailBox mailbox;
    private static Timer jfTimer;
    public ActorSpec actorSpec;
    public Hashtable ports = new Hashtable();
    public static int UNIQ_ID;
    public ActorContext context;
    private boolean isPersistent = false;
    private int noOfTrialsLeft = 3;
    private boolean visible;
    private int traceLevel;
    private boolean traceParts;
    private Hashtable stateMachines;
    private Hashtable currentStates = new Hashtable();
    private boolean testing = false;
    private static ActorAddress proxyAddress;

    public StateMachine() {
        this.stateMachines = new Hashtable();
        this.saveQueue = new MailBox();
        this.mailbox = new MailBox();
        this.activeTimers = new Hashtable();
    }

    public StateMachine(CompositeState compositeState) {
        this();
        this.setBehaviorClass(compositeState);
    }

    public boolean useProxy() {
        return proxyAddress != null;
    }

    public void setProxyAddress(ActorAddress proxyAddress) {
        StateMachine.proxyAddress = proxyAddress;
    }

    public ActorAddress getProxyAddress() {
        return proxyAddress;
    }

    public void setBehaviorClass(CompositeState myCompositeState) {
        this.myCompositeState = myCompositeState;
    }

    public CompositeState getBehaviorClass() {
        return this.myCompositeState;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public ActorSpec getActorSpec() {
        return this.actorSpec;
    }

    public void setActorSpec(ActorSpec actorSpec) {
        this.actorSpec = actorSpec;
    }

    @Override
    public ActorAddress getMyActorAddress() {
        ActorAddress adr = new ActorAddress(this.myActorId, this.myActorType);
        if (adr.getActorDomain() == null) {
            adr.setActorDomain(this.myActorDomain);
        }
        return adr;
    }

    protected static Timer createTimer() {
        if (jfTimer == null) {
            jfTimer = new Timer();
        }
        return jfTimer;
    }

    protected String getStateMachineId(String actorId) {
        int index = actorId.indexOf(".");
        if (index == -1) {
            return actorId;
        }
        return actorId.substring(index + 1);
    }

    public boolean containsStateMachine(String id) {
        return this.stateMachines.containsKey(id);
    }

    protected boolean isRole(String actorId) {
        return actorId.indexOf(".") != -1;
    }

    public CompositeState getStateMachine() {
        String str = this.getStateMachineId(this.myActorId);
        CompositeState cs = (CompositeState)this.stateMachines.get(str);
        if (cs == null) {
            throw new RuntimeException("CompositeState (behaviour class) not set. ActorId = " + this.myActorId);
        }
        return (CompositeState)this.stateMachines.get(str);
    }

    public CompositeState getStateMachine(String stateMachineId) {
        return (CompositeState)this.stateMachines.get(stateMachineId);
    }

    public void addStateMachine(String stateMachineId, RoleCS stateMachine) {
        if (!this.stateMachines.containsKey(stateMachineId)) {
            stateMachine.setParentAddress(this.getMyActorAddress());
            this.stateMachines.put(stateMachineId, stateMachine);
        }
    }

    public String getMyActorDomain() {
        return this.myActorDomain;
    }

    public void setMyActorDomain(String myActorDomain) {
        this.myActorDomain = myActorDomain;
    }

    public void setMyActorId(String myActorId) {
        this.myActorId = myActorId;
    }

    public void setMyActorType(String myActorType) {
        this.myActorType = myActorType;
    }

    public TraceObject getTrace() {
        return this.trace;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setNextState(State state) {
        this.currentStates.put(this.getStateMachineId(this.myActorId), state);
    }

    public void setCurrentState(CompositeState state) {
        this.currentStates.put(this.getStateMachineId(this.myActorId), state);
    }

    public Hashtable getStateMachines() {
        return this.stateMachines;
    }

    public Container getContainer() {
        return this.scheduler.getSchedulerData().getContainer();
    }

    public ApplicationSpec getApplicationSpec() {
        return this.scheduler.getSchedulerData().getApplicationSpec();
    }

    public String getContextString() {
        if (this.context.getActorAddress() != null) {
            return this.myActorId + "/";
        }
        return "/";
    }

    protected boolean isCreateMsg(ActorMsg msg) {
        return msg instanceof AFPropertyMsg && msg.equals("RoleCreateMsg") || msg.equals("RolePlayMsg");
    }

    public ActorContext getContext() {
        return this.context;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.trace = scheduler.getTraceObject();
    }

    @Override
    public MailBox getMailbox() {
        return this.mailbox;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isSaveDone() {
        return this.saveDone;
    }

    @Override
    public boolean isReadyToBeDeleted() {
        return this.readyToBeDeleted;
    }

    @Override
    public void init() {
        ApplicationSpec appSpec = this.scheduler.getSchedulerData().getApplicationSpec();
        this.actorSpec = appSpec.getClonedActorSpec(this.getType());
        this.scheduler.setTrace(appSpec.isTraceEnabled());
        if (this.myCompositeState != null && this.myCompositeState instanceof RoleCS) {
            this.addStateMachine(this.myActorId, (RoleCS)this.myCompositeState);
        }
        this.initStateMachine();
        this.execStartTransition();
        this.initNewInstance();
    }

    @Override
    public void destroy() {
        this.stopAllTimers();
    }

    @Override
    public void pause() {
    }

    public CompositeState getCompositeState() {
        return this.getStateMachine();
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public String toString() {
        return this.myActorId + "@" + this.myActorType;
    }

    public void startTimer(long duration, String timerId, ActorAddress receiver) {
        AFPropertyMsg tm = new AFPropertyMsg("TimerMsg", true);
        tm.setProperty("timerId", timerId);
        tm.setReceiverRole(receiver);
        tm.setLong("duration", duration);
        this.startTimer(tm, duration, timerId);
    }

    public void startTimer(AFPropertyMsg tm, long duration, String timerId) {
        if (timerId == null || timerId.equals("")) {
            timerId = tm.toString();
        }
        tm.setReceiverRole(this.getMyActorAddress());
        tm.setProperty("timerId", timerId);
        if (this.activeTimers.containsKey(timerId)) {
            this.stopTimer(timerId);
        }
        JFTimerTask jfTT = new JFTimerTask(tm);
        this.activeTimers.put(timerId, jfTT);
        Timer timer = StateMachine.createTimer();
        timer.schedule((TimerTask)jfTT, duration);
        this.trace.traceTask("Timer: " + timerId + " Duration: " + duration / 1000L + " seconds");
    }

    public void startTimer(long duration, String timerId) {
        this.startTimer(new AFPropertyMsg("TimerMsg", true), duration, timerId);
    }

    public boolean stopTimer(String timerId) {
        boolean returnValue = false;
        if (timerId == null || timerId.equals("")) {
            this.trace.traceWarning("Scheduler.JFTimerTask.stopTimer: Timer: " + timerId + " illegal timerId, timer not removed");
        } else {
            JFTimerTask t = (JFTimerTask)this.activeTimers.remove(timerId);
            if (t == null) {
                this.trace.traceTask("Scheduler.JFTimerTask.stopTimer: Timer: " + timerId + " timer does exist");
            } else if (t.cancel()) {
                this.trace.traceTask("Timer: " + timerId.trim() + " removed");
                returnValue = true;
            } else {
                this.trace.traceTask("Scheduler.JFTimerTask.stopTimer: Timer: " + timerId.trim() + " not removed");
            }
        }
        return returnValue;
    }

    public Hashtable getActiveTimers() {
        return this.activeTimers;
    }

    void runSaveQueue() {
        if (this.nextState != null) {
            MailBox tmp = new MailBox();
            if (this.saveQueue != null) {
                tmp.moveMailBox(this.saveQueue);
            }
            ActorMsg am = (ActorMsg)tmp.removeFirst();
            while (am != null) {
                this.processMessage(am);
                am = (ActorMsg)tmp.removeFirst();
            }
        }
    }

    protected boolean processPortMessage(ActorMsg msg) {
        boolean ok = false;
        this.myActorId = msg.getReceiverRole().getActorID();
        this.myActorType = msg.getReceiverRole().getActorType();
        String portName = msg.getReceiverRole().getActorPort();
        ActorAddress receiverAddress = (ActorAddress)this.ports.get(portName);
        if (receiverAddress != null) {
            msg.setReceiverRole(receiverAddress);
            ok = this.output(msg);
        } else {
            this.trace.traceOut(4, this.trace.getTraceHeader() + "The port " + portName + " does not exists");
        }
        return ok;
    }

    @Override
    public boolean processMessage(ActorMsg msg) {
        this.currentMessage = msg;
        this.myActorId = msg.getReceiverRole().getActorID();
        this.myActorType = msg.getReceiverRole().getActorType();
        this.readyToBeDeleted = false;
        this.trace.traceInit(this);
        this.trace.setInputSignal(msg);
        State ps = this.getCurrentState();
        if (ps == null) {
            CompositeState cs = this.getStateMachine(this.getStateMachineId(this.myActorId));
            if (cs != null) {
                cs.enterState(this);
            } else {
                if (this.scheduler.isTraceOn()) {
                    this.trace.traceError("No state machine found for id: <" + this.myActorId + ">");
                }
                return false;
            }
        }
        if ((ps = this.getCurrentState()) != null) {
            try {
                this.exec(msg, this);
            }
            catch (Exception e) {
                if (this.scheduler.isTraceOn()) {
                    this.trace.traceError("Something went seriously wrong during execution. Performing Rollback: " + e.toString() + " " + e.getMessage());
                }
                this.getContainer().displayError(e);
                if (this.performExitIsDone) {
                    this.setNextState(ps);
                }
                return false;
            }
            if (this.scheduler.isTraceOn() && this.trace.traceLevel <= 1) {
                this.trace.traceOut(1, this.trace.toString());
            }
        } else {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError(" Current state is not set");
            }
            return false;
        }
        this.currentMessage = null;
        this.runSaveQueue();
        return true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void initInstance() {
    }

    protected void destroyInstance() {
    }

    private void initNewInstance() {
        this.context = new ActorContext(new ActorAddress(this.myActorId, this.myActorType));
        this.context.setMyParentAddress(new ActorAddress(this.myActorId, this.myActorType));
        this.initInstance();
    }

    @Override
    public String getType() {
        return this.myActorType;
    }

    @Override
    public String getID() {
        return this.myActorId;
    }

    public String printStateData() {
        return "";
    }

    protected void initStateMachine() {
    }

    public final State getCurrentState() {
        return (State)this.currentStates.get(this.getStateMachineId(this.myActorId));
    }

    protected Hashtable getCurrentStates() {
        return this.currentStates;
    }

    protected final void setInitialState(State state) {
        this.currentStates.put(this.getStateMachineId(this.myActorId), state);
    }

    public void setCurrentMessage(ActorMsg currentMessage) {
        this.currentMessage = currentMessage;
    }

    public final ActorMsg getCurrentMessage() {
        return this.currentMessage;
    }

    public void setPartSpecs(Vector partSpecs) {
        this.actorSpec.setPartDesc(partSpecs);
    }

    public void setPortSpecs(Vector portSpecs) {
        this.actorSpec.setPortDesc(portSpecs);
    }

    protected void execStartTransition() {
        this.getStateMachine().enterState(this);
        this.initialState = this.getCurrentState();
        this.currentStateId = this.initialState.stateName();
    }

    public void restart() {
        do {
            this.getCurrentState().exit(this);
            this.setNextState(this.getCurrentState().enclosingState);
        } while (null != this.getCurrentState());
    }

    protected void exec(ActorMsg sig, StateMachine curfsm) {
        State currState;
        this.nextState = null;
        this.entryNo = 0;
        State st = currState = this.getCurrentState();
        this.trace.setCurrentState(currState.stateName());
        CompositeState enclSt = currState.enclosingState;
        if (enclSt == null) {
            if (this.scheduler.isTraceError()) {
                this.trace.traceOut(4, this.trace.getTraceHeader() + "State is null!");
            }
            return;
        }
        this.saveDone = false;
        do {
            this.performExitIsDone = false;
            this.sameStateIsDone = false;
            this.exitStateIsDone = false;
            enclSt.curfsm = this;
            enclSt.execTrans(sig, currState, curfsm);
            if (this.exitStateIsDone) {
                if (this.performExitIsDone) {
                    currState.exit(curfsm);
                } else {
                    throw new ActorFrameException("CurState: " + currState.getFullStateName() + " PerformExit() is not called before exitState() is called in execTrans()");
                }
            }
            if (this.nextState != null && this.performExitIsDone) {
                if (this.nextState instanceof CompositeState && this.entryNo != 0) {
                    ((CompositeState)this.nextState).enterState(this.entryNo, this);
                } else {
                    this.nextState.enterState(this);
                }
                if ((currState == null || currState instanceof CompositeState) && this.scheduler.isTraceOn()) {
                    throw new ActorFrameException("Inconsisent current state of state machine id: " + sig.getReceiverRole().toString() + " Probably a mismatch of performExit() and enterState()");
                }
                if (this.scheduler.isTraceOn()) {
                    this.trace.setNewState(this.nextState.stateName());
                }
                if (this.isPersistent()) {
                    try {
                        this.storePersistentData();
                    }
                    catch (IOException e) {
                        this.trace.traceOut(4, "IOException while storing persistent data");
                    }
                }
                return;
            }
            if (this.nextState == null && this.performExitIsDone) {
                this.trace.setNewState(currState.stateName());
                throw new ActorFrameException("CurState: " + currState.getFullStateName() + " NextState != null, but performExit is not run");
            }
            if (this.nextState != null && !this.performExitIsDone) {
                String str = "CurState: " + currState.getFullStateName() + " NextState != null, but performExit is not run";
                if (this.scheduler.isTraceOn()) {
                    this.trace.traceOut(2, this.trace.getTraceHeader() + str);
                }
                this.trace.setNewState(currState.stateName());
                throw new ActorFrameException(str);
            }
            if (this.sameStateIsDone) {
                this.trace.setNewState(currState.stateName());
                return;
            }
            st = enclSt;
        } while ((enclSt = st.enclosingState) != null && !this.saveDone);
        this.trace.setNewState(currState.stateName());
    }

    public final boolean output(ActorMsg sig) {
        if (sig.getReceiverRole() != null && sig.getReceiverRole().getActorType() != null) {
            if (sig.getSenderRole() == null) {
                sig.setSenderRole(this.getMyActorAddress());
            }
            if (this.useProxy()) {
                sig.getReceiverRole().setProxyAddress(this.getProxyAddress());
            }
            this.scheduler.clearLastMsgFromRouter();
            return this.scheduler.output(sig, this);
        }
        this.trace.traceWarning("Illegal Receiver: " + sig.messageContent());
        this.scheduler.output(sig, this);
        return false;
    }

    public boolean sendMessage(ActorMsg sig) {
        return this.output(sig);
    }

    public boolean sendMessage(ActorMsg sig, ActorAddress aa) {
        if (aa == null) {
            throw new RuntimeException("ActorAddress is null");
        }
        sig.setReceiverRole((ActorAddress)aa.clone());
        sig.setSenderRole(this.getMyActorAddress());
        return this.output(sig);
    }

    public boolean sendMessage(String signaName, ActorAddress aa) {
        AFPropertyMsg sig = new AFPropertyMsg(signaName);
        sig.setReceiverRole((ActorAddress)aa.clone());
        sig.setSenderRole(this.getMyActorAddress());
        return this.output(sig);
    }

    public boolean sendMessage(ActorMsg sig, ActorAddress aa, String protocol) {
        sig.setReceiverRole((ActorAddress)aa.clone());
        sig.getReceiverRole().setProtocol(protocol);
        sig.setSenderRole(this.getMyActorAddress());
        sig.getSenderRole().setProtocol(protocol);
        return this.output(sig);
    }

    public boolean sendMessage(String sigName, String receiver) {
        if (receiver.indexOf("@") != -1) {
            return this.sendMessage((ActorMsg)new AFPropertyMsg(sigName), new ActorAddress(receiver));
        }
        return this.sendMessage((ActorMsg)new AFPropertyMsg(sigName), receiver);
    }

    public boolean sendMessage(String sigName, Vector v) {
        return this.sendMessage((ActorMsg)new AFPropertyMsg(sigName), v);
    }

    public boolean sendMessage(ActorMsg sig, Vector v) {
        boolean res = true;
        if (v != null && v.size() > 0) {
            if (v.size() == 1) {
                ActorAddress aa = (ActorAddress)v.firstElement();
                sig.setReceiverRole(aa);
                res = this.output(sig);
            } else {
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    ActorAddress aa = (ActorAddress)e.nextElement();
                    ActorMsg msg = sig.getCopy(this.scheduler.getClassLoader());
                    msg.setReceiverRole(aa);
                    boolean ok = this.output(msg);
                    res = res || ok;
                }
            }
        }
        return res;
    }

    public boolean sendMessage(ActorMsg sig, ActorAddress[] actorAddresses) {
        boolean res = true;
        if (actorAddresses != null) {
            if (actorAddresses.length == 1) {
                ActorAddress aa = actorAddresses[0];
                sig.setReceiverRole(aa);
                res = this.output(sig);
            } else {
                for (int i = 0; i < actorAddresses.length; ++i) {
                    ActorAddress address = actorAddresses[i];
                    ActorMsg msg = sig.getCopy(this.scheduler.getClassLoader());
                    msg.setReceiverRole(address);
                    boolean ok = this.output(msg);
                    res = res || ok;
                }
            }
        } else {
            res = false;
        }
        return res;
    }

    public boolean sendMessage(ActorMsg sig, Object[] actorAddresses) {
        boolean res = true;
        try {
            for (int i = 0; i < actorAddresses.length; ++i) {
                ActorAddress actorAddress = (ActorAddress)actorAddresses[i];
                boolean ok = this.sendMessage(sig.getCopy(this.getScheduler().getClassLoader()), actorAddress);
                res = res || ok;
            }
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Array of objects is not Actor addresses" + e.getMessage());
        }
        return res;
    }

    public boolean sendMessage(String name, Object[] actorAddresses) {
        return this.sendMessage((ActorMsg)new AFPropertyMsg(name), actorAddresses);
    }

    public boolean sendMessage(ActorMsg am, String portName) {
        ActorAddress portAddress = this.getPortAddress(portName);
        if (portAddress == null) {
            if (this.scheduler.isTraceOn()) {
                this.trace.traceError("Illegal port name: " + portName + " Message: " + am.getMsgId());
            }
            return false;
        }
        if (portAddress.getActorID() == null) {
            Enumeration en = this.scheduler.getSchedulerData().getMySystem().elements();
            while (en.hasMoreElements()) {
                Schedulable sm = (Schedulable)en.nextElement();
                String type = sm.getMyActorAddress().getActorType();
                if (!type.equals(portAddress.getActorType())) continue;
                portAddress.setActorID(sm.getMyActorAddress().getActorID());
                break;
            }
        }
        if (portAddress.isValied()) {
            am.setSenderRole(this.getMyActorAddress());
            return this.sendMessage(am, portAddress);
        }
        return false;
    }

    public void setReadyToBeDeleted() {
        this.readyToBeDeleted = true;
    }

    public ActorSpec readActorDescription() {
        if (this.getType() != null) {
            return this.scheduler.getSchedulerData().getApplicationSpec().getActorSpec(this.getType());
        }
        return null;
    }

    public PartSpec findRoleSpec(String roleType, Vector roleSpecs) {
        for (int i = 0; i < roleSpecs.size(); ++i) {
            PartSpec parttemp = (PartSpec)roleSpecs.elementAt(i);
            String tmp = parttemp.getRoleType();
            if (!roleType.equals(tmp)) continue;
            return parttemp;
        }
        return null;
    }

    public Vector getPartSpecs() {
        return this.actorSpec.getPartDesc();
    }

    public Vector getPortSpecs() {
        return this.actorSpec.getPortDesc();
    }

    public boolean createParts() {
        boolean childrenCreated = false;
        String s = "INNER PARTS: ";
        Vector partSpecs = this.actorSpec.getPartDesc();
        for (int i = 0; i < partSpecs.size(); ++i) {
            PartSpec ps = (PartSpec)partSpecs.elementAt(i);
            s = s + ", " + ps.toString();
            ActorSpec spec = this.getApplicationSpec().getActorSpec(ps.getRoleType());
            if (spec == null) {
                if (!this.scheduler.isTraceOn()) continue;
                this.trace.traceOut(4, " Scheduler.createParts: ActorStateMachine spec" + ps.getRoleType() + " does not exists");
                continue;
            }
            if (ps.getBind() != null) {
                if (!this.scheduler.isTraceOn()) continue;
                this.trace.traceOut(2, " Scheduler.createParts: ActorStateMachine spec: " + ps.getRoleType() + " is bind to: " + ps.getBind());
                continue;
            }
            int noOfExistingRoles = this.context.getChildrenRoles(ps.getRoleType()).size();
            if (ps.getLow() - noOfExistingRoles <= 0) continue;
            for (int j = noOfExistingRoles; j < ps.getLow(); ++j) {
                Vector ports = this.getApplicationSpec().getActorSpec(ps.getRoleType()).getPortNames();
                AFPropertyMsg pm = this.createRoleCreateMsg(ps, ports);
                ActorAddress aa = ps.getRoleNames() == null || ps.getRoleNames().length <= j ? new ActorAddress(this.getContextString() + ps.getRoleType() + UNIQ_ID++ + "Set" + ps.getSetNo(), ps.getRoleType()) : new ActorAddress(this.getContextString() + ps.getRoleNames()[j], ps.getRoleType());
                if (ps.getActorDomain() != null) {
                    aa = ps.getActorDomain();
                    String id = this.getContextString() + ps.getRoleNames()[j];
                    ActorAddress targetActor = new ActorAddress(id, ps.getRoleType());
                    pm.setProperty("targetActor", targetActor);
                    this.context.getCreationOfChildren().addElement(targetActor);
                } else {
                    this.context.getCreationOfChildren().addElement(aa);
                }
                Vector v = this.actorSpec.getConnectorDesc(ps.getRoleType(), null);
                v = this.rewriteContextualConnectors(v);
                pm.setProperty("connectors", v);
                this.sendMessage((ActorMsg)pm, aa);
                childrenCreated = true;
            }
        }
        if (this.scheduler.isTraceOn()) {
            this.trace.traceOut(2, this.trace.getTraceHeader() + s);
        }
        return childrenCreated;
    }

    public boolean createParts(Vector v) {
        boolean childrenCreated = false;
        for (int i = 0; i < this.actorSpec.getPartDesc().size(); ++i) {
            PartSpec ps = (PartSpec)this.actorSpec.getPartDesc().elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                Vector ports = this.getApplicationSpec().getActorSpec(ps.getRoleType()).getPortNames();
                AFPropertyMsg pm = this.createRoleCreateMsg(ps, ports);
                ActorAddress aa = (ActorAddress)v.elementAt(j);
                String s = aa.key();
                if (!s.endsWith(ps.getRoleType())) continue;
                String actorId = s.substring(0, s.indexOf("@"));
                aa = new ActorAddress(actorId, ps.getRoleType());
                if (ps.getActorDomain() != null) {
                    aa = ps.getActorDomain();
                    String id = this.getContextString() + ps.getRoleNames()[j];
                    ActorAddress targetActor = new ActorAddress(id, ps.getRoleType());
                    pm.setProperty("targetActor", targetActor);
                }
                Vector con = this.actorSpec.getConnectorDesc(ps.getRoleType(), null);
                v = this.rewriteContextualConnectors(con);
                pm.setProperty("connectors", con);
                this.sendMessage((ActorMsg)pm, aa);
                childrenCreated = true;
            }
        }
        return childrenCreated;
    }

    protected AFPropertyMsg createRoleCreateMsg(PartSpec ps, Vector ports) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleCreateMsg", true);
        pm.setProperty("ports", ports);
        pm.setProperty("connectors", this.actorSpec.getConnectorDesc(ps.getRoleType(), null));
        pm.setBoolean("visible", ps.isVisible());
        pm.setInt("traceLevel", ps.getTraceLev());
        return pm;
    }

    public boolean createPorts(Vector connectors) {
        if (this.ports == null) {
            this.ports = new Hashtable();
        }
        boolean createdPorts = false;
        Enumeration enumer = connectors.elements();
        while (enumer.hasMoreElements()) {
            ConnectorSpec connectorSpec = (ConnectorSpec)enumer.nextElement();
            if (this.ports.containsKey(connectorSpec.getFrom()) || connectorSpec.getFrom().getActorPort() == null) continue;
            this.ports.put(connectorSpec.getFrom().getActorPort(), connectorSpec.getTo());
            createdPorts = true;
        }
        return createdPorts;
    }

    protected ActorAddress getContextAddress(ActorAddress connAddr, Vector childrenAddrs) {
        ActorAddress res = (ActorAddress)connAddr.clone();
        if (res.getActorID() == null) {
            if (connAddr.getActorType().equals(this.myActorType)) {
                res.setActorID(this.myActorId);
            } else {
                Enumeration children = childrenAddrs.elements();
                while (children.hasMoreElements()) {
                    ActorAddress child = (ActorAddress)children.nextElement();
                    if (!child.getActorType().equals(connAddr.getActorType())) continue;
                    res.setActorID(child.getActorID());
                    break;
                }
            }
        } else {
            res.setActorID(this.getContextString() + connAddr.getActorID());
        }
        if (res.getActorPort() == null || res.getActorPort().equals("")) {
            res.setActorPort(null);
        }
        return res;
    }

    public Vector rewriteContextualConnectors(Vector connectors) {
        Vector childrenAddrs = this.getAllChildrenOfThisType(this.myActorType);
        Vector<ConnectorSpec> res = new Vector<ConnectorSpec>();
        for (int i = 0; i < connectors.size(); ++i) {
            ConnectorSpec cs = (ConnectorSpec)connectors.elementAt(i);
            ActorAddress to = cs.getTo();
            PartSpec toPart = this.actorSpec.getPartSpec(to.getActorType());
            if (toPart != null && toPart.getBind() != null) {
                to.setActorID(toPart.getBind());
            } else {
                to = this.getContextAddress(cs.getTo(), childrenAddrs);
            }
            ActorAddress from = this.getContextAddress(cs.getFrom(), childrenAddrs);
            ConnectorSpec newSpec = new ConnectorSpec(from, to, cs.isBidirectional());
            res.addElement(newSpec);
        }
        return res;
    }

    private Vector getAllChildrenOfThisType(String actorType) {
        Vector all = this.context.getChildrenRoles();
        Enumeration enumer = this.context.getCreationOfChildren().elements();
        while (enumer.hasMoreElements()) {
            all.addElement(enumer.nextElement());
        }
        return all;
    }

    public boolean checkMaxLimit(PartSpec p) {
        return this.context.sizeOfChildrenRoles(p.getRoleType()) < p.getHigh();
    }

    public void releaseAllAssociations() {
        ActorAddress aa;
        Vector req = this.context.getRequestorRoles();
        Enumeration e = req.elements();
        while (e.hasMoreElements()) {
            aa = (ActorAddress)e.nextElement();
            this.sendMessage((ActorMsg)new AFPropertyMsg("RoleReleaseMsg", true), aa);
        }
        req = this.context.getRequestedRoles();
        e = req.elements();
        while (e.hasMoreElements()) {
            aa = (ActorAddress)e.nextElement();
            this.sendMessage((ActorMsg)new AFPropertyMsg("RoleReleaseMsg", true), aa);
        }
        this.context.getRequestedRoles().removeAllElements();
    }

    public void releaseChildren() {
        Vector children = this.context.getChildrenRoles();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            AFPropertyMsg pm;
            ActorAddress childAA = (ActorAddress)e.nextElement();
            if (this.context.isPersistentChildrenRole(childAA)) {
                pm = new AFPropertyMsg("RoleResetMsg", true);
                pm.setSenderRole(new ActorAddress(this.myActorId, this.myActorType));
                this.sendMessage((ActorMsg)pm, childAA);
                continue;
            }
            pm = new AFPropertyMsg("RoleRemoveMsg", true);
            this.sendMessage((ActorMsg)pm, childAA);
            pm.setSenderRole(new ActorAddress(this.myActorId, this.myActorType));
            this.sendMessage((ActorMsg)pm, childAA);
            this.context.remove(childAA);
        }
    }

    public void sendRoleRequest(ActorAddress aa, String roleId, String roleType) throws Exception {
        AFPropertyMsg rrm = new AFPropertyMsg("RoleRequestMsg", true);
        rrm.setProperty("roleId", roleId);
        rrm.setProperty("roleType", roleType);
        this.sendMessage((ActorMsg)rrm, aa);
    }

    public boolean removeIfPossible() {
        if (this.context.isEmpty() && !this.isPersistent()) {
            this.destroyInstance();
            this.sendMessage((ActorMsg)new AFPropertyMsg("RolePlayEndedMsg", true), this.context.getParentAddress());
            this.stopAllTimers();
            return true;
        }
        return false;
    }

    public void stopAllTimers() {
        if (!this.activeTimers.isEmpty()) {
            Enumeration tmp = this.activeTimers.keys();
            while (tmp.hasMoreElements()) {
                String s = (String)tmp.nextElement();
                this.stopTimer(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTheEvent(ActorMsg am) {
        am.setReceiverRole(this.context.getActorAddress());
        if (am.getSenderRole() == null) {
            am.setSenderRole(this.context.getActorAddress());
        }
        Scheduler scheduler = this.getScheduler();
        synchronized (scheduler) {
            this.getMailbox().addMessage(am);
            this.getScheduler().notifyScheduler();
        }
    }

    public void executeTheEvent(String msgName) {
        this.executeTheEvent(new AFPropertyMsg(msgName));
    }

    public State getHistoryState(CompositeState cs) {
        return cs.findCurrentState(this.context.getHistoryStateId());
    }

    public void setHistoryState(State st) {
        if (st == null) {
            this.context.setHistoryStateId(null);
        } else {
            this.context.setHistoryStateId(st.stateName());
        }
    }

    public String stripContext(String s) {
        return s.substring(s.lastIndexOf(47) + 1);
    }

    public boolean validateCredentials(AFPropertyMsg rrm) {
        return false;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean persistent) {
        this.isPersistent = persistent;
    }

    private ActorAddress getPortAddress(String portName) {
        return (ActorAddress)this.ports.get(portName);
    }

    public int getNoOfTrialsLeft() {
        return this.noOfTrialsLeft;
    }

    public void setNoOfTrialsLeft(int noOfTrialsLeft) {
        this.noOfTrialsLeft = noOfTrialsLeft;
    }

    public void routerUpdate() {
    }

    public boolean isTraceParts() {
        return this.traceParts;
    }

    public void setTraceParts(boolean traceParts) {
        this.traceParts = traceParts;
    }

    protected byte[] storePersistentData() throws IOException {
        return new byte[0];
    }

    protected ByteArrayInputStream restorePersistentData(byte[] data) throws IOException {
        return new ByteArrayInputStream(data);
    }

    public boolean isTraceOn() {
        return this.scheduler.isTraceOn();
    }

    public boolean isTraceError() {
        return this.scheduler.isTraceError();
    }

    public boolean sendToChild(ActorMsg am, ActorAddress child) {
        ActorAddress aa = this.context.getChildrenRoleIgnoreContext(child);
        if (aa != null) {
            this.sendMessage(am, aa);
            return true;
        }
        return false;
    }

    public boolean sendToChildren(ActorMsg am) {
        if (!this.context.getChildrenRoles().isEmpty()) {
            return this.sendMessage(am, this.context.getChildrenRoles());
        }
        return false;
    }

    public boolean sendToChild(ActorMsg am, String childType) {
        Vector v = this.context.getChildrenRoles(childType);
        if (v.size() == 1) {
            this.sendMessage(am, (ActorAddress)v.elementAt(0));
            return true;
        }
        return false;
    }

    public ActorMsg getCopyMsg(ActorMsg msg) {
        return msg.getCopy(this.getScheduler().getClassLoader());
    }

    public AFPropertyMsg createRoleRequestMsg(String actorid, String actorType) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleRequestMsg", true);
        pm.setProperty("roleId", actorid);
        pm.setProperty("roleType", actorType);
        return pm;
    }

    static {
        UNIQ_ID = 0;
        proxyAddress = null;
    }

    public class JFTimerTask
    extends TimerTask {
        AFPropertyMsg thisMsg;

        public JFTimerTask(AFPropertyMsg thisMsg) {
            this.thisMsg = thisMsg;
        }

        @Override
        public void run() {
            StateMachine.this.sendMessage(this.thisMsg);
            if (this.thisMsg instanceof AFPropertyMsg) {
                StateMachine.this.activeTimers.remove(this.thisMsg.getString("timerId"));
            }
        }
    }
}

