/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

import org.coos.javaframe.Logger;
import org.coos.javaframe.LoggerFactory;
import org.coos.javaframe.TraceConstants;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class AFServiceFactory {
	private static Hashtable afServices = new Hashtable();
	static Logger logger = LoggerFactory.getLogger("org.coos.actorframe");

	public static void addAFService(String serviceName, String serviceClass) {
		if ((serviceName != null) & (serviceClass != null)) {
			afServices.put(serviceName, serviceClass);
			logger.log(TraceConstants.tlInfo, "AFServiceFactory.addAFservice: Property: " + serviceName + " Object: "
					+ serviceClass);
		}
	}

	public static void addAFService(String serviceName, Object serviceObject) {
		if ((serviceName != null) & (serviceObject != null)) {
			afServices.put(serviceName, serviceObject);

			logger.log(TraceConstants.tlInfo, "AFServiceFactory.addAFservice: Property: " + serviceName + " Object: "
					+ serviceObject);
		}
	}

	public static boolean removeAFService(String serviceName) {
		if (afServices.containsKey(serviceName)) {
			afServices.remove(serviceName);

			return true;
		} else {
			return false;
		}
	}

	public static Object getAFServiceInstance(String serviceName) {
		if (serviceName != null) {
			Object o = afServices.get(serviceName);

			if (o instanceof String) {
				try {
					Class c = Class.forName((String) o);

					return c.newInstance();
				} catch (Exception e) {
					logger.log(TraceConstants.tlError, "Failed to instantiate " + serviceName + ". Returning null.");
				}

				return null;
			} else {
				// return with the stored instance
				return o;
			}
		} else {
			return null;
		}
	}

	public static boolean isPropertySet(String serviceName) {
		if (serviceName != null) {
			return afServices.get(serviceName) != null;
		} else {
			return false;
		}
	}

	public static String getAFServiceProperty(String serviceName) {
		if (serviceName != null) {
			return (String) afServices.get(serviceName);
		} else {
			return null;
		}
	}

	public static Enumeration getAFServiceNames() {
		return afServices.keys();
	}

	public static String printContent() {
		Enumeration en = afServices.keys();
		String res = "AFservices contains: \n";

		while (en.hasMoreElements()) {
			String s = (String) en.nextElement();
			res = res + "Service name: " + s;
			res = res + "Service class: " + afServices.get(s) + "\n";
		}

		return res;
	}
}
