/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.PortSpec;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;

public class ActorPortSpec
extends PortSpec
implements AFSerializer {
    boolean isBehavior = false;
    boolean sessionEnabled = false;
    boolean hideInner = false;
    ActorAddress actorDomain = null;

    public ActorPortSpec() {
    }

    public ActorPortSpec(String portName, String portType, boolean isBehavior) {
        super(portName, portType, null);
        this.isBehavior = isBehavior;
    }

    public ActorPortSpec(String portName) {
        super(portName, null, null);
        this.isBehavior = false;
    }

    public ActorAddress getActorDomain() {
        return this.actorDomain;
    }

    public void setActorDomain(ActorAddress actorDomain) {
        this.actorDomain = actorDomain;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setPortType(String portType) {
        this.portType = portType;
    }

    public void setIsBehavior(boolean isBehavior) {
        this.isBehavior = isBehavior;
    }

    public boolean getIsBehavior() {
        return this.isBehavior;
    }

    public boolean isHideInner() {
        return this.hideInner;
    }

    public void setHideInner(boolean hideInner) {
        this.hideInner = hideInner;
    }

    public boolean isBehavior() {
        return this.isBehavior;
    }

    public void setBehavior(boolean behavior) {
        this.isBehavior = behavior;
    }

    public boolean isSessionEnabled() {
        return this.sessionEnabled;
    }

    public void setSessionEnabled(boolean sessionEnabled) {
        this.sessionEnabled = sessionEnabled;
    }

    @Override
    public Object clone() {
        ActorPortSpec actorPortSpec = new ActorPortSpec(this.portName, this.portType, this.isBehavior);
        actorPortSpec.hideInner = this.hideInner;
        actorPortSpec.sessionEnabled = this.sessionEnabled;
        if (this.actorDomain != null) {
            actorPortSpec.setActorDomain((ActorAddress)this.actorDomain.clone());
        }
        return actorPortSpec;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActorPortSpec that = (ActorPortSpec)o;
        if (this.hideInner != that.hideInner) {
            return false;
        }
        if (this.isBehavior != that.isBehavior) {
            return false;
        }
        if (this.sessionEnabled != that.sessionEnabled) {
            return false;
        }
        if (this.actorDomain != null ? !this.actorDomain.equals(that.actorDomain) : that.actorDomain != null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return super.toString() + " isBeaviour: " + this.isBehavior + " sessionEnabled: " + this.sessionEnabled + " hideInner: " + this.hideInner;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(super.serialize());
        dout.writeBoolean(this.isBehavior);
        dout.writeBoolean(this.hideInner);
        dout.writeBoolean(this.sessionEnabled);
        dout.write(ActorAddressHelper.persist(this.actorDomain));
        dout.flush();
        return bout.toByteArray();
    }

    @Override
    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = super.deSerialize(data, cl);
        DataInputStream din = new DataInputStream(bin);
        this.isBehavior = din.readBoolean();
        this.hideInner = din.readBoolean();
        this.sessionEnabled = din.readBoolean();
        this.actorDomain = ActorAddressHelper.resurrect(din);
        return bin;
    }
}

