/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe.application;

import java.util.Vector;
import org.coos.javaframe.SchedulerSpec;

public class DomainSpec {
    private Vector schedulerSpec = new Vector();
    private String actor;
    private String name;
    private String domainName;
    private boolean validated = false;

    public DomainSpec(String name, String actor) {
        this.actor = actor;
        this.name = name;
        this.domainName = name + System.currentTimeMillis();
    }

    public String getActor() {
        return this.actor;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomainSpec)) {
            return false;
        }
        DomainSpec that = (DomainSpec)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public void addSchedulerSpec(String actorType, int threads) {
        SchedulerSpec ss = new SchedulerSpec();
        ss.setThreads(threads);
        ss.setId(actorType);
        ss.addActorType(actorType);
        this.schedulerSpec.addElement(ss);
    }

    public void addSchedulerSpec(SchedulerSpec spec) {
        this.schedulerSpec.addElement(spec);
    }

    public Vector getSchedulerSpecs() {
        return this.schedulerSpec;
    }

    public void setSchedulerSpec(Vector schedulerSpec) {
        this.schedulerSpec = schedulerSpec;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public SchedulerSpec getSchedulerSpec(String id) {
        for (int i = 0; i < this.schedulerSpec.size(); ++i) {
            SchedulerSpec spec = (SchedulerSpec)this.schedulerSpec.elementAt(i);
            if (!spec.getId().equals(id)) continue;
            return spec;
        }
        return null;
    }

    public SchedulerSpec containsActorType(String actorType) {
        for (int i = 0; i < this.schedulerSpec.size(); ++i) {
            SchedulerSpec spec = (SchedulerSpec)this.schedulerSpec.elementAt(i);
            if (spec.getActorType(actorType) == null) continue;
            return spec;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Name: <" + this.name + "> Domain actor: <" + this.actor + "> Domain name: <" + this.domainName + ">");
        if (this.schedulerSpec != null) {
            for (int i = 0; i < this.schedulerSpec.size(); ++i) {
                SchedulerSpec spec = (SchedulerSpec)this.schedulerSpec.elementAt(i);
                sb.append("\n   " + spec.toString());
            }
        }
        return sb.toString();
    }
}

